/*
 * Decompiled with CFR 0.152.
 */
package com.yogpc.qp.machines;

import com.yogpc.qp.machines.EnchantmentLevel;
import com.yogpc.qp.machines.PowerConfig;

public class PowerManager {
    public static <T extends EnchantmentLevel.HasEnchantments & PowerConfig.Provider> long getMakeFrameEnergy(T enchantments) {
        return PowerManager.getMakeFrameEnergy(enchantments, ((PowerConfig.Provider)enchantments).getPowerConfig());
    }

    public static long getMakeFrameEnergy(EnchantmentLevel.HasEnchantments enchantments, PowerConfig config) {
        return config.makeFrame() / (long)(1 + Math.max(0, enchantments.unbreakingLevel()));
    }

    public static <T extends EnchantmentLevel.HasEnchantments & PowerConfig.Provider> long getMoveEnergy(double distance, T enchantments) {
        return PowerManager.getMoveEnergy(distance, enchantments, ((PowerConfig.Provider)enchantments).getPowerConfig());
    }

    public static long getMoveEnergy(double distance, EnchantmentLevel.HasEnchantments enchantments, PowerConfig config) {
        double distanceEnergy = distance * (double)config.moveHeadBase();
        double efficiencyBalanced = Math.pow(config.efficiencyCoefficient(), enchantments.efficiencyLevel()) * distanceEnergy;
        return (long)(efficiencyBalanced / (double)(1 + Math.max(0, enchantments.unbreakingLevel())));
    }

    public static <T extends EnchantmentLevel.HasEnchantments & PowerConfig.Provider> long getAdvSearchEnergy(int blocks, T enchantments) {
        PowerConfig config = ((PowerConfig.Provider)enchantments).getPowerConfig();
        long heightEnergy = (long)blocks * config.moveHeadBase() * 50L;
        double efficiencyBalanced = Math.pow(config.efficiencyCoefficient(), enchantments.efficiencyLevel()) * (double)heightEnergy;
        return (long)(efficiencyBalanced / (double)(1 + Math.max(0, enchantments.unbreakingLevel())));
    }

    public static long getBreakEnergy(float hardness, EnchantmentLevel.HasEnchantments enchantments, PowerConfig config) {
        boolean silktouch;
        if (Float.isNaN(hardness) || hardness == 0.0f) {
            return 0L;
        }
        int efficiency = enchantments.efficiencyLevel();
        int fortune = enchantments.fortuneLevel();
        int unbreaking = enchantments.unbreakingLevel();
        boolean bl = silktouch = enchantments.silktouchLevel() > 0;
        if (hardness < 0.0f || Float.isInfinite(hardness)) {
            return 200L * config.breakBlockBase() * (long)(efficiency + 1);
        }
        long base = (long)((double)config.breakBlockBase() * Math.pow(config.breakFortuneCoefficient(), fortune) * Math.pow(config.breakSilktouchCoefficient(), silktouch ? 1.0 : 0.0));
        double coefficient = (double)hardness * Math.pow(config.breakEfficiencyCoefficient(), efficiency) / (double)(1 + Math.max(0, unbreaking));
        return (long)(coefficient * (double)base);
    }

    public static <T extends EnchantmentLevel.HasEnchantments & PowerConfig.Provider> long getBreakEnergy(float hardness, T enchantments) {
        return PowerManager.getBreakEnergy(hardness, enchantments, ((PowerConfig.Provider)enchantments).getPowerConfig());
    }

    public static long getBreakBlockFluidEnergy(EnchantmentLevel.HasEnchantments enchantments, PowerConfig config) {
        return config.breakBlockFluid() / (long)(1 + Math.max(0, enchantments.unbreakingLevel()));
    }

    public static <T extends EnchantmentLevel.HasEnchantments & PowerConfig.Provider> long getBreakBlockFluidEnergy(T enchantments) {
        return PowerManager.getBreakBlockFluidEnergy(enchantments, ((PowerConfig.Provider)enchantments).getPowerConfig());
    }

    public static <T extends EnchantmentLevel.HasEnchantments & PowerConfig.Provider> long getExpCollectEnergy(int exp, T enchantments) {
        PowerConfig config = ((PowerConfig.Provider)enchantments).getPowerConfig();
        return config.expCollect() * (long)exp * 2L / (long)(2 + Math.max(enchantments.unbreakingLevel(), 0));
    }

    public static <T extends EnchantmentLevel.HasEnchantments & PowerConfig.Provider> long getMiniQuarryEnergy(T enchantments) {
        return ((PowerConfig.Provider)enchantments).getPowerConfig().breakBlockBase() / (long)(1 + Math.max(0, enchantments.unbreakingLevel()));
    }

    public static <T extends PowerConfig.Provider> long getFillerEnergy(T enchantments) {
        return enchantments.getPowerConfig().breakBlockBase();
    }
}

