/*
 * Decompiled with CFR 0.152.
 */
package com.yogpc.qp.render;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.yogpc.qp.machines.Area;
import com.yogpc.qp.machines.marker.TileMarker;
import com.yogpc.qp.render.Box;
import com.yogpc.qp.render.ColorBox;
import com.yogpc.qp.render.Sprites;
import java.util.Arrays;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Stream;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.core.BlockPos;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class RenderMarker
implements BlockEntityRenderer<TileMarker> {
    private static final double a = 0.5;
    private static final double b = 0.625;
    private static final double c = 0.375;
    final boolean reduceLineIfPlayerIsFar;

    public static BlockEntityRendererProvider<TileMarker> constructor(boolean reduceLineIfPlayerIsFar) {
        return c -> new RenderMarker(c, reduceLineIfPlayerIsFar);
    }

    public RenderMarker(BlockEntityRendererProvider.Context context, boolean reduceLineIfPlayerIsFar) {
        this.reduceLineIfPlayerIsFar = reduceLineIfPlayerIsFar;
    }

    public void render(TileMarker entity, float tickDelta, PoseStack matrices, MultiBufferSource vertexConsumers, int light, int overlay) {
        ColorBox color;
        TextureAtlasSprite sprite;
        Box[] renderBoxes;
        Optional<Box[]> optionalBoxes = entity.renderArea();
        BlockPos markerPos = entity.m_58899_();
        if (optionalBoxes.isPresent()) {
            renderBoxes = optionalBoxes.get();
            sprite = Sprites.INSTANCE.getWhite();
            color = ColorBox.markerBlueColor;
        } else if (entity.rsReceiving && entity.getArea().isEmpty()) {
            LocalPlayer player = Minecraft.m_91087_().f_91074_;
            double playerX = player == null ? (double)markerPos.m_123341_() : player.m_20185_();
            double playerZ = player == null ? (double)markerPos.m_123343_() : player.m_20189_();
            int visibleRange = 32;
            double xMin = Math.max(playerX - (double)visibleRange, (double)(markerPos.m_123341_() - 256));
            double xMax = Math.min(playerX + (double)visibleRange, (double)(markerPos.m_123341_() + 256));
            double zMin = Math.max(playerZ - (double)visibleRange, (double)(markerPos.m_123343_() - 256));
            double zMax = Math.min(playerZ + (double)visibleRange, (double)(markerPos.m_123343_() + 256));
            renderBoxes = (Box[])Stream.of(!this.reduceLineIfPlayerIsFar || Math.abs((double)markerPos.m_123343_() - playerZ) < (double)visibleRange ? Box.apply(xMin + 0.625, (double)markerPos.m_123342_() + 0.5, (double)markerPos.m_123343_() + 0.5, xMax + 0.375, (double)markerPos.m_123342_() + 0.5, (double)markerPos.m_123343_() + 0.5, xMax - xMin - 0.25, 0.126, 0.126, false, false) : null, !this.reduceLineIfPlayerIsFar || Math.abs((double)markerPos.m_123341_() - playerX) < (double)visibleRange ? Box.apply((double)markerPos.m_123341_() + 0.5, (double)markerPos.m_123342_() + 0.5, zMin + 0.625, (double)markerPos.m_123341_() + 0.5, (double)markerPos.m_123342_() + 0.5, zMax + 0.375, 0.126, 0.126, zMax - zMin - 0.25, false, false) : null).filter(Objects::nonNull).toArray(Box[]::new);
            sprite = Sprites.INSTANCE.getWhite();
            color = ColorBox.markerRedColor;
        } else {
            return;
        }
        Minecraft.m_91087_().m_91307_().m_6180_("quarryplus");
        Minecraft.m_91087_().m_91307_().m_6180_("RenderMarker");
        VertexConsumer buffer = vertexConsumers.m_6299_(RenderType.m_110463_());
        matrices.m_85836_();
        matrices.m_252880_((float)(-markerPos.m_123341_()), (float)(-markerPos.m_123342_()), (float)(-markerPos.m_123343_()));
        for (Box box : renderBoxes) {
            box.render(buffer, matrices, sprite, color);
        }
        matrices.m_85849_();
        Minecraft.m_91087_().m_91307_().m_7238_();
        Minecraft.m_91087_().m_91307_().m_7238_();
    }

    public static Box[] getRenderBox(Area area) {
        int flag = 0;
        int xMin = area.minX();
        int yMin = area.minY();
        int zMin = area.minZ();
        int xMax = area.maxX();
        int yMax = area.maxY();
        int zMax = area.maxZ();
        if (xMin != xMax) {
            flag |= 1;
        }
        if (yMin != yMax) {
            flag |= 2;
        }
        if (zMin != zMax) {
            flag |= 4;
        }
        AABB[] lineBoxes = new AABB[12];
        if ((flag & 1) == 1) {
            lineBoxes[0] = new AABB((double)xMin + 0.625, (double)yMin + 0.5, (double)zMin + 0.5, (double)xMax + 0.375, (double)yMin + 0.5, (double)zMin + 0.5);
        }
        if ((flag & 2) == 2) {
            lineBoxes[4] = new AABB((double)xMin + 0.5, (double)yMin + 0.625, (double)zMin + 0.5, (double)xMin + 0.5, (double)yMax + 0.375, (double)zMin + 0.5);
        }
        if ((flag & 4) == 4) {
            lineBoxes[8] = new AABB((double)xMin + 0.5, (double)yMin + 0.5, (double)zMin + 0.625, (double)xMin + 0.5, (double)yMin + 0.5, (double)zMax + 0.375);
        }
        if ((flag & 3) == 3) {
            lineBoxes[2] = new AABB((double)xMin + 0.625, (double)yMax + 0.5, (double)zMin + 0.5, (double)xMax + 0.375, (double)yMax + 0.5, (double)zMin + 0.5);
            lineBoxes[6] = new AABB((double)xMax + 0.5, (double)yMin + 0.625, (double)zMin + 0.5, (double)xMax + 0.5, (double)yMax + 0.375, (double)zMin + 0.5);
        }
        if ((flag & 5) == 5) {
            lineBoxes[1] = new AABB((double)xMin + 0.625, (double)yMin + 0.5, (double)zMax + 0.5, (double)xMax + 0.375, (double)yMin + 0.5, (double)zMax + 0.5);
            lineBoxes[9] = new AABB((double)xMax + 0.5, (double)yMin + 0.5, (double)zMin + 0.625, (double)xMax + 0.5, (double)yMin + 0.5, (double)zMax + 0.375);
        }
        if ((flag & 6) == 6) {
            lineBoxes[5] = new AABB((double)xMin + 0.5, (double)yMin + 0.625, (double)zMax + 0.5, (double)xMin + 0.5, (double)yMax + 0.375, (double)zMax + 0.5);
            lineBoxes[10] = new AABB((double)xMin + 0.5, (double)yMax + 0.5, (double)zMin + 0.625, (double)xMin + 0.5, (double)yMax + 0.5, (double)zMax + 0.375);
        }
        if ((flag & 7) == 7) {
            lineBoxes[3] = new AABB((double)xMin + 0.625, (double)yMax + 0.5, (double)zMax + 0.5, (double)xMax + 0.375, (double)yMax + 0.5, (double)zMax + 0.5);
            lineBoxes[7] = new AABB((double)xMax + 0.5, (double)yMin + 0.625, (double)zMax + 0.5, (double)xMax + 0.5, (double)yMax + 0.375, (double)zMax + 0.5);
            lineBoxes[11] = new AABB((double)xMax + 0.5, (double)yMax + 0.5, (double)zMin + 0.625, (double)xMax + 0.5, (double)yMax + 0.5, (double)zMax + 0.375);
        }
        return (Box[])Arrays.stream(lineBoxes).filter(Objects::nonNull).map(range -> Box.apply(range, Math.max(range.m_82362_(), 0.126), Math.max(range.m_82376_(), 0.126), Math.max(range.m_82385_(), 0.126), false, false)).toArray(Box[]::new);
    }

    public int m_142163_() {
        return 256;
    }

    public boolean shouldRenderOffScreen(TileMarker blockEntity) {
        return true;
    }
}

