/*
 * Decompiled with CFR 0.152.
 */
package com.yogpc.qp.machines.quarry;

import com.yogpc.qp.Holder;
import com.yogpc.qp.machines.misc.SlotContainer;
import com.yogpc.qp.machines.quarry.SFQuarryEntity;
import java.util.Objects;
import net.minecraft.core.BlockPos;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.DataSlot;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;

public final class SFQuarryMenu
extends AbstractContainerMenu {
    public static final String GUI_ID = "quarryplus:gui_solid_fuel_quarry";
    final DataSlot fuelCountData = this.m_38895_(DataSlot.m_39401_());
    @NotNull
    final SFQuarryEntity quarry;
    private final int allSlots;

    public SFQuarryMenu(int id, Player player, BlockPos pos) {
        super(Holder.SOLID_FUEL_QUARRY_MENU_TYPE, id);
        this.quarry = Objects.requireNonNull((SFQuarryEntity)player.m_9236_().m_7702_(pos));
        this.allSlots = this.quarry.fuelContainer.m_6643_();
        this.m_38897_(new SlotContainer((Container)this.quarry.fuelContainer, 0, 44, 27));
        int oneBox = 18;
        for (int h = 0; h < 3; ++h) {
            for (int v = 0; v < 9; ++v) {
                this.m_38897_(new Slot((Container)player.m_150109_(), v + h * 9 + 9, 8 + v * oneBox, 84 + h * oneBox));
            }
        }
        for (int vertical = 0; vertical < 9; ++vertical) {
            this.m_38897_(new Slot((Container)player.m_150109_(), vertical, 8 + vertical * oneBox, 142));
        }
    }

    public boolean m_6875_(Player player) {
        return this.quarry.enabled;
    }

    public void m_38946_() {
        this.fuelCountData.m_6422_(Math.min(this.quarry.fuelCount, Short.MAX_VALUE));
        super.m_38946_();
    }

    public ItemStack m_7648_(Player player, int index) {
        Slot slot = this.m_38853_(index);
        if (slot.m_6657_()) {
            ItemStack remain = slot.m_7993_();
            ItemStack slotContent = remain.m_41777_();
            if (index < this.allSlots ? !this.m_38903_(remain, this.allSlots, 36 + this.allSlots, true) : !this.m_38903_(remain, 0, this.allSlots, false)) {
                return ItemStack.f_41583_;
            }
            if (remain.m_41619_()) {
                slot.m_5852_(ItemStack.f_41583_);
            } else {
                slot.m_6654_();
            }
            if (remain.m_41613_() == slotContent.m_41613_()) {
                return ItemStack.f_41583_;
            }
            slot.m_142406_(player, remain);
            return slotContent;
        }
        return ItemStack.f_41583_;
    }
}

