/*
 * Decompiled with CFR 0.152.
 */
package com.yogpc.qp.machines.miningwell;

import com.yogpc.qp.Holder;
import com.yogpc.qp.QuarryPlus;
import com.yogpc.qp.machines.CheckerLog;
import com.yogpc.qp.machines.EnchantmentLevel;
import com.yogpc.qp.machines.InvUtils;
import com.yogpc.qp.machines.ItemConverter;
import com.yogpc.qp.machines.MachineStorage;
import com.yogpc.qp.machines.PowerConfig;
import com.yogpc.qp.machines.PowerManager;
import com.yogpc.qp.machines.PowerTile;
import com.yogpc.qp.machines.QuarryFakePlayer;
import com.yogpc.qp.machines.miningwell.MiningWellBlock;
import java.util.List;
import java.util.stream.Stream;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.BucketPickup;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FluidState;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.event.level.BlockEvent;
import net.minecraftforge.eventbus.api.Event;
import org.jetbrains.annotations.VisibleForTesting;

public class MiningWellTile
extends PowerTile
implements CheckerLog,
MachineStorage.HasStorage,
EnchantmentLevel.HasEnchantments {
    private final MachineStorage storage = new MachineStorage();
    private final ItemConverter itemConverter = ItemConverter.defaultConverter();
    public int digMinY = 0;
    private int interval = 0;
    private boolean finished = false;
    private int efficiencyLevel = 0;

    public MiningWellTile(BlockPos pos, BlockState state) {
        super(Holder.MINING_WELL_TYPE, pos, state);
    }

    public void tick() {
        int y;
        assert (this.f_58857_ != null);
        assert (!this.f_58857_.f_46443_);
        if (!this.hasEnoughEnergy() || this.finished || --this.interval > 0) {
            return;
        }
        this.interval = this.getInterval();
        if (!((Boolean)this.m_58900_().m_61143_((Property)MiningWellBlock.WORKING)).booleanValue()) {
            this.f_58857_.m_7731_(this.m_58899_(), (BlockState)this.m_58900_().m_61124_((Property)MiningWellBlock.WORKING, (Comparable)Boolean.valueOf(true)), 2);
            this.m_6596_();
        }
        for (y = this.m_58899_().m_123342_() - 1; y >= this.digMinY; --y) {
            BlockPos targetPos = this.m_58899_().m_175288_(y);
            BlockState state = this.f_58857_.m_8055_(targetPos);
            FluidState fluid = this.f_58857_.m_6425_(targetPos);
            if (state.m_60795_() || state.m_60713_((Block)Holder.BLOCK_DUMMY)) continue;
            ItemStack pickaxe = EnchantmentLevel.HasEnchantments.super.getPickaxe();
            FakePlayer fakePlayer = QuarryFakePlayer.get((ServerLevel)this.f_58857_);
            fakePlayer.m_21008_(InteractionHand.MAIN_HAND, pickaxe);
            BlockEvent.BreakEvent breakEvent = new BlockEvent.BreakEvent(this.f_58857_, targetPos, state, (Player)fakePlayer);
            MinecraftForge.EVENT_BUS.post((Event)breakEvent);
            if (breakEvent.isCanceled()) continue;
            if (!fluid.m_76178_()) {
                if (!this.useEnergy(PowerManager.getBreakBlockFluidEnergy(EnchantmentLevel.NoEnchantments.INSTANCE, PowerConfig.DEFAULT), PowerTile.Reason.REMOVE_FLUID, false)) break;
                if (state.m_60734_() instanceof LiquidBlock) {
                    if (!fluid.m_76178_() && fluid.m_76170_()) {
                        this.storage.addFluid(fluid.m_76152_(), 1000L);
                    }
                } else {
                    Block block = state.m_60734_();
                    if (block instanceof BucketPickup) {
                        BucketPickup drain = (BucketPickup)block;
                        ItemStack bucket = drain.m_142598_((LevelAccessor)this.f_58857_, targetPos, state);
                        this.storage.addFluid(bucket);
                    } else {
                        QuarryPlus.LOGGER.warn("Fluid is nether LiquidBlock nor BucketPickup, but {}({})", (Object)state.m_60734_(), state.m_60734_().getClass());
                    }
                }
                this.f_58857_.m_7731_(targetPos, Holder.BLOCK_DUMMY.m_49966_(), 3);
                break;
            }
            if (!this.canBreak(this.f_58857_, targetPos, state)) continue;
            this.breakBlock(this.f_58857_, targetPos, state, pickaxe, (Entity)fakePlayer);
            break;
        }
        if (y < this.digMinY) {
            this.f_58857_.m_7731_(this.m_58899_(), (BlockState)this.m_58900_().m_61124_((Property)MiningWellBlock.WORKING, (Comparable)Boolean.valueOf(false)), 2);
            this.m_6596_();
            this.finished = true;
        }
    }

    @Override
    public void saveNbtData(CompoundTag nbt) {
        nbt.m_128365_("storage", (Tag)this.storage.toNbt());
        nbt.m_128405_("digMinY", this.digMinY);
        nbt.m_128405_("waitingTick", this.interval);
        nbt.m_128379_("finished", this.finished);
        nbt.m_128405_("efficiencyLevel", this.efficiencyLevel);
    }

    @Override
    public void m_142466_(CompoundTag nbt) {
        super.m_142466_(nbt);
        this.storage.readNbt(nbt.m_128469_("storage"));
        this.digMinY = nbt.m_128451_("digMinY");
        this.interval = nbt.m_128451_("waitingTick");
        this.finished = nbt.m_128471_("finished");
        this.efficiencyLevel = nbt.m_128451_("efficiencyLevel");
    }

    @Override
    public List<? extends Component> getDebugLogs() {
        return Stream.of("MinY: " + this.digMinY, "Interval: " + this.interval, "Finished: " + this.finished, "Efficiency: " + this.efficiencyLevel, this.energyString()).map(Component::m_237113_).toList();
    }

    @Override
    public MachineStorage getStorage() {
        return this.storage;
    }

    private boolean canBreak(Level targetWorld, BlockPos targetPos, BlockState state) {
        float hardness = state.m_60800_((BlockGetter)targetWorld, targetPos);
        return hardness >= 0.0f;
    }

    private void breakBlock(Level level, BlockPos pos, BlockState state, ItemStack tool, Entity entity) {
        float hardness = state.m_60800_((BlockGetter)level, pos);
        if (this.useEnergy(PowerManager.getBreakEnergy(hardness, EnchantmentLevel.NoEnchantments.INSTANCE, PowerConfig.DEFAULT), PowerTile.Reason.BREAK_BLOCK, false)) {
            List<ItemStack> drops = InvUtils.getBlockDrops(state, (ServerLevel)level, pos, level.m_7702_(pos), entity, tool);
            drops.stream().map(this.itemConverter::map).forEach(this.storage::addItem);
            level.m_7731_(pos, Blocks.f_50016_.m_49966_(), 3);
            SoundType sound = state.m_60827_();
            level.m_5594_(null, pos, sound.m_56775_(), SoundSource.BLOCKS, (sound.m_56773_() + 1.0f) / 4.0f, sound.m_56774_() * 0.8f);
        }
    }

    void reset() {
        this.finished = false;
        this.interval = this.getInterval();
    }

    int getInterval() {
        return switch (this.efficiencyLevel()) {
            case 1 -> 30;
            case 2 -> 20;
            case 3 -> 10;
            case 4 -> 5;
            case 5 -> 1;
            default -> 40;
        };
    }

    @Override
    public List<EnchantmentLevel> getEnchantments() {
        if (this.efficiencyLevel == 0) {
            return List.of();
        }
        return List.of(new EnchantmentLevel(Enchantments.f_44984_, this.efficiencyLevel));
    }

    @Override
    public int efficiencyLevel() {
        return this.efficiencyLevel;
    }

    @VisibleForTesting
    public void setEfficiencyLevel(int efficiencyLevel) {
        this.efficiencyLevel = efficiencyLevel;
    }
}

