/*
 * Decompiled with CFR 0.152.
 */
package ad_astra_giselle_addon.common.content.oxygen;

import ad_astra_giselle_addon.common.content.oxygen.IOxygenCharger;
import ad_astra_giselle_addon.common.content.oxygen.IOxygenChargerItem;
import ad_astra_giselle_addon.common.entity.LivingHelper;
import ad_astra_giselle_addon.common.fluid.FluidPredicates;
import ad_astra_giselle_addon.common.fluid.FluidUtils2;
import ad_astra_giselle_addon.common.item.ItemStackReference;
import earth.terrarium.adastra.api.systems.TemperatureApi;
import earth.terrarium.adastra.common.items.ZipGunItem;
import earth.terrarium.adastra.common.items.armor.SpaceSuitItem;
import earth.terrarium.botarium.common.fluid.FluidConstants;
import earth.terrarium.botarium.common.fluid.base.FluidContainer;
import earth.terrarium.botarium.common.fluid.base.FluidHolder;
import earth.terrarium.botarium.common.fluid.base.ItemFluidContainer;
import earth.terrarium.botarium.common.item.ItemStackHolder;
import java.util.Iterator;
import java.util.List;
import java.util.OptionalDouble;
import java.util.stream.Stream;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;

public class OxygenChargerUtils {
    public static void distributeToItems(LivingEntity living) {
        OxygenChargerUtils.streamExtractable(living, FluidConstants.fromMillibuckets((long)1L)).forEach(c -> OxygenChargerUtils.distributeToItems(living, c));
    }

    public static void distributeToItems(LivingEntity living, IOxygenCharger oxygenCharger) {
        FluidHolder moved;
        ItemFluidContainer itemFluidContainer;
        ItemStackReference itemRef;
        Item item;
        FluidContainer fluidContainer = oxygenCharger.getFluidContainer();
        List<ItemStackReference> items = oxygenCharger.getChargeMode().getItems(living);
        long transfer = oxygenCharger.getTransferAmount();
        Iterator iterator = items.iterator();
        while (iterator.hasNext() && (!((item = (itemRef = (ItemStackReference)((Object)iterator.next())).getStack().m_41720_()) instanceof SpaceSuitItem) && !(item instanceof ZipGunItem) || (itemFluidContainer = FluidContainer.of((ItemStackHolder)itemRef)) == null || (moved = FluidUtils2.moveFluidAny(fluidContainer, (FluidContainer)itemFluidContainer, FluidPredicates::isOxygen, transfer, false)).isEmpty() || (transfer -= moved.getFluidAmount()) > 0L)) {
        }
    }

    public static OptionalDouble getExtractableStoredRatio(LivingEntity living) {
        List<ItemStackReference> items = LivingHelper.getInventoryItems(living);
        long stored = 0L;
        long capacity = 0L;
        Level level = living.m_9236_();
        BlockPos pos = living.m_20183_();
        boolean isCold = TemperatureApi.API.isCold(level, pos);
        boolean isHot = TemperatureApi.API.isHot(level, pos);
        for (ItemStackReference item : items) {
            IOxygenCharger oxygenCharger = OxygenChargerUtils.get(item);
            if (oxygenCharger == null || !oxygenCharger.canUse(isCold, isHot)) continue;
            stored += oxygenCharger.getTotalAmount();
            capacity += oxygenCharger.getTotalCapacity();
        }
        if (capacity == 0L) {
            return OptionalDouble.empty();
        }
        return OptionalDouble.of((double)stored / (double)capacity);
    }

    @Nullable
    public static IOxygenCharger firstExtractable(LivingEntity living, long extracting) {
        return OxygenChargerUtils.streamExtractable(living, extracting).findFirst().orElse(null);
    }

    @Nullable
    public static Stream<IOxygenCharger> streamExtractable(LivingEntity living, long extracting) {
        Level level = living.m_9236_();
        BlockPos pos = living.m_20183_();
        boolean isCold = TemperatureApi.API.isCold(level, pos);
        boolean isHot = TemperatureApi.API.isHot(level, pos);
        return LivingHelper.getInventoryItems(living).stream().map(OxygenChargerUtils::get).filter(oxygenCharger -> {
            FluidHolder extract;
            return oxygenCharger != null && oxygenCharger.canUse(isCold, isHot) && !(extract = FluidUtils2.extractFluid(oxygenCharger.getFluidContainer(), FluidPredicates::isOxygen, extracting, true)).isEmpty() && extract.getFluidAmount() >= extracting;
        });
    }

    @Nullable
    public static IOxygenCharger get(ItemStackHolder item) {
        Item item2 = item.getStack().m_41720_();
        if (item2 instanceof IOxygenChargerItem) {
            IOxygenChargerItem oxygenChargerItem = (IOxygenChargerItem)item2;
            return oxygenChargerItem.getOxygenCharger(item);
        }
        return null;
    }

    private OxygenChargerUtils() {
    }
}

