/*
 * Decompiled with CFR 0.152.
 */
package ad_astra_giselle_addon.client.screen;

import ad_astra_giselle_addon.common.block.entity.IRocketSensingType;
import ad_astra_giselle_addon.common.block.entity.RocketSensorBlockEntity;
import ad_astra_giselle_addon.common.network.AddonNetwork;
import ad_astra_giselle_addon.common.network.RocketSensorMessage;
import com.mojang.blaze3d.vertex.PoseStack;
import com.teamresourceful.resourcefullib.client.scissor.ClosingScissorBox;
import com.teamresourceful.resourcefullib.client.utils.RenderUtils;
import com.teamresourceful.resourcefullib.common.networking.base.Packet;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractSelectionList;
import net.minecraft.client.gui.components.ObjectSelectionList;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;

public class RocketSensingTypeList
extends ObjectSelectionList<RocketSensingTypeEntry> {
    private final Screen screen;
    private final RocketSensorBlockEntity rocketSensor;

    public RocketSensingTypeList(Screen screen, RocketSensorBlockEntity rocketSensor, Minecraft pMinecraft, int pWidth, int pHeight, int pY0, int pY1) {
        super(pMinecraft, pWidth, pHeight, pY0, pY1, 20);
        this.screen = screen;
        this.rocketSensor = rocketSensor;
        this.m_93496_(false);
        this.m_93488_(false);
        this.refreshList();
    }

    protected void m_7733_(GuiGraphics guiGraphics) {
        super.m_7733_(guiGraphics);
        guiGraphics.m_280509_(this.f_93393_ - 2, this.f_93390_, this.f_93392_ + 2, this.f_93391_, -16777216);
        guiGraphics.m_280509_(this.f_93393_, this.f_93390_ + 2, this.f_93392_, this.f_93391_ - 2, -14671840);
    }

    public void renderTooltip(GuiGraphics guiGraphics, int mouseX, int mouseY) {
        RocketSensingTypeEntry entry = (RocketSensingTypeEntry)this.m_93412_(mouseX, mouseY);
        if (entry != null) {
            guiGraphics.m_280666_(this.f_93386_.f_91062_, entry.getType().getTooltip(), mouseX, mouseY);
        }
    }

    public void select(IRocketSensingType sensingType) {
        this.m_6987_(null);
        for (RocketSensingTypeEntry entry : this.m_6702_()) {
            if (entry.getType() != sensingType) continue;
            this.m_6987_((AbstractSelectionList.Entry)entry);
            break;
        }
    }

    public void refreshList() {
        this.m_93516_();
        IRocketSensingType.getRocketSensingTypes().stream().map(type -> new RocketSensingTypeEntry(this, (IRocketSensingType)type)).forEach(x$0 -> this.m_7085_((AbstractSelectionList.Entry)x$0));
    }

    public Screen getScreen() {
        return this.screen;
    }

    public RocketSensorBlockEntity getRocketSensor() {
        return this.rocketSensor;
    }

    protected int m_5756_() {
        return this.f_93393_ + this.f_93388_;
    }

    public int m_5759_() {
        return this.f_93388_;
    }

    public class RocketSensingTypeEntry
    extends ObjectSelectionList.Entry<RocketSensingTypeEntry> {
        private final RocketSensingTypeList parent;
        private final IRocketSensingType type;

        public RocketSensingTypeEntry(RocketSensingTypeList parent, IRocketSensingType type) {
            this.parent = parent;
            this.type = type;
        }

        public void m_6311_(GuiGraphics guiGraphics, int pIndex, int pTop, int pLeft, int pWidth, int pHeight, int pMouseX, int pMouseY, boolean pIsMouseOver, float pPartialTick) {
            RocketSensingTypeList parent = this.getParent();
            Minecraft minecraft = parent.f_93386_;
            int y0 = Math.max(pTop, parent.f_93390_ + 2);
            int y1 = Math.min(pTop + pHeight, parent.f_93391_ - 2);
            guiGraphics.m_280509_(pLeft - 2, pTop + pHeight + 2, pLeft + pWidth - 2, pTop + pHeight + 3, -16777216);
            try (ClosingScissorBox si = RenderUtils.createScissorBox((Minecraft)minecraft, (PoseStack)guiGraphics.m_280168_(), (int)(pLeft - 2), (int)(y0 - 2), (int)(pWidth + 4), (int)(y1 - y0 + 4));){
                if (parent.m_93511_() == this) {
                    int i = parent.m_93696_() ? -1 : -8355712;
                    parent.m_240140_(guiGraphics, pTop, pWidth, pHeight, i, -16777216);
                }
            }
            si = RenderUtils.createScissorBox((Minecraft)minecraft, (PoseStack)guiGraphics.m_280168_(), (int)pLeft, (int)y0, (int)(pWidth - 2), (int)(y1 - y0));
            try {
                IRocketSensingType sensingType = this.getType();
                int itemLeft = pLeft + 2;
                int itemTop = pTop + (pHeight - 16) / 2;
                guiGraphics.m_280480_(sensingType.getDisplayIcon(), itemLeft, itemTop);
                Component name = sensingType.getDisplayName();
                Font font = minecraft.f_91062_;
                Font font2 = minecraft.f_91062_;
                Objects.requireNonNull(font);
                guiGraphics.m_280430_(font2, name, itemLeft + 20, pTop + (pHeight - 9) / 2, 0xFFFFFF);
            }
            finally {
                if (si != null) {
                    si.close();
                }
            }
        }

        public boolean m_6375_(double p_mouseClicked_1_, double p_mouseClicked_3_, int p_mouseClicked_5_) {
            RocketSensorBlockEntity rocketSensor = this.getParent().getRocketSensor();
            IRocketSensingType newSensingType = this.getType();
            rocketSensor.setSensingType(newSensingType);
            AddonNetwork.CHANNEL.sendToServer((Packet)new RocketSensorMessage.SensingType(rocketSensor, newSensingType));
            return true;
        }

        public RocketSensingTypeList getParent() {
            return this.parent;
        }

        public IRocketSensingType getType() {
            return this.type;
        }

        public Component m_142172_() {
            return Component.m_237110_((String)"narrator.select", (Object[])new Object[]{this.getType().getDisplayName()});
        }
    }
}

