/*
 * Decompiled with CFR 0.152.
 */
package ad_astra_giselle_addon.common.item;

import earth.terrarium.botarium.common.energy.util.EnergyHooks;
import earth.terrarium.botarium.common.item.ItemStackHolder;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.Nullable;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public enum ItemUsableResource {
    None{

        @Override
        public boolean test(ItemStack item) {
            return false;
        }

        @Override
        public long extract(ItemStackHolder item, long amount, boolean simulate) {
            return 0L;
        }
    }
    ,
    Energy{

        @Override
        public boolean test(ItemStack item) {
            return EnergyHooks.isEnergyItem((ItemStack)item);
        }

        @Override
        public long extract(ItemStackHolder item, long amount, boolean simulate) {
            return EnergyHooks.safeGetItemEnergyManager((ItemStack)item.getStack()).map(e -> e.extract(item, amount, simulate)).orElse(0L);
        }
    }
    ,
    Durability{

        @Override
        public boolean test(ItemStack item) {
            return true;
        }

        @Override
        public long extract(ItemStackHolder item, long amount, boolean simulate) {
            int maxDamage;
            int damaging;
            int prevDamage;
            int nextDamage;
            ItemStack stack = item.getStack();
            if (stack.m_41763_() && (nextDamage = (prevDamage = stack.m_41773_()) + (damaging = Math.min((maxDamage = stack.m_41776_()) - prevDamage, (int)amount))) < maxDamage) {
                if (!simulate) {
                    stack.m_41721_(nextDamage);
                    item.setStack(stack);
                }
                return damaging;
            }
            return amount;
        }
    };


    @Nullable
    public static ItemUsableResource first(ItemStack item) {
        for (ItemUsableResource resource : ItemUsableResource.values()) {
            if (!resource.test(item)) continue;
            return resource;
        }
        return null;
    }

    public abstract boolean test(ItemStack var1);

    public abstract long extract(ItemStackHolder var1, long var2, boolean var4);
}

