/*
 * Decompiled with CFR 0.152.
 */
package ad_astra_giselle_addon.common.enchantment;

import ad_astra_giselle_addon.common.item.ItemStackConsumers;
import ad_astra_giselle_addon.common.item.ItemStackReference;
import com.google.common.collect.Lists;
import com.mojang.datafixers.util.Pair;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.ChatFormatting;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import org.jetbrains.annotations.NotNull;

public class EnchantmentHelper2 {
    private static final Map<Enchantment, String> DESCRIPTION_KEYS = new HashMap<Enchantment, String>();
    private static final Map<Enchantment, Component> DESCRIPTION_TEXTS = new HashMap<Enchantment, Component>();
    private static final Map<Enchantment, List<? extends Component>> DESCRIPTION_TEXTS_MULTILINES = new HashMap<Enchantment, List<? extends Component>>();
    private static final List<String> DESCRIPTION_SUFFIXES = Lists.newArrayList((Object[])new String[]{"desc", "description"});

    public static List<String> getDescriptionSuffixes() {
        return Collections.unmodifiableList(DESCRIPTION_SUFFIXES);
    }

    public static boolean addDescriptionSuffix(String suffix) {
        return DESCRIPTION_SUFFIXES.add(suffix);
    }

    public static String getDescriptionKey(Enchantment enchantment) {
        return DESCRIPTION_KEYS.computeIfAbsent(enchantment, e -> {
            String descriptionId = e.m_44704_();
            for (String suffix : DESCRIPTION_SUFFIXES) {
                String key = descriptionId + "." + suffix;
                if (!I18n.m_118936_((String)key)) continue;
                return key;
            }
            return descriptionId + DESCRIPTION_SUFFIXES.get(0);
        });
    }

    public static Component getDescriptionText(Enchantment enchantment) {
        return DESCRIPTION_TEXTS.computeIfAbsent(enchantment, e -> Component.m_237115_((String)EnchantmentHelper2.getDescriptionKey(enchantment)).m_130940_(ChatFormatting.GOLD));
    }

    public static void clearDescriptionsCache() {
        DESCRIPTION_TEXTS_MULTILINES.clear();
    }

    public static List<? extends Component> getDescriptionTexts(Enchantment enchantment) {
        return DESCRIPTION_TEXTS_MULTILINES.computeIfAbsent(enchantment, e -> Arrays.stream(Component.m_237115_((String)EnchantmentHelper2.getDescriptionKey(enchantment)).getString().split("\n")).map(Component::m_237113_).map(s -> s.m_130940_(ChatFormatting.GOLD)).toList());
    }

    @NotNull
    public static Pair<ItemStackReference, Integer> getEnchantmentItemAndLevel(Enchantment enchantment, LivingEntity living) {
        Map map = enchantment.m_44684_(living);
        EquipmentSlot slot = null;
        int level = 0;
        for (Map.Entry pair : map.entrySet()) {
            int i = EnchantmentHelper.m_44843_((Enchantment)enchantment, (ItemStack)((ItemStack)pair.getValue()));
            if (i <= level) continue;
            slot = (EquipmentSlot)pair.getKey();
            level = i;
        }
        if (slot != null) {
            return Pair.of((Object)((Object)new ItemStackReference(living.m_6844_(slot), ItemStackConsumers.equipment(slot, (arg_0, arg_1) -> ((LivingEntity)living).m_8061_(arg_0, arg_1)))), (Object)level);
        }
        return Pair.of(null, (Object)level);
    }

    private EnchantmentHelper2() {
    }
}

