/*
 * Decompiled with CFR 0.152.
 */
package ad_astra_giselle_addon.common.content.proof;

import ad_astra_giselle_addon.common.content.proof.ProofSession;
import ad_astra_giselle_addon.common.enchantment.AddonEnchantment;
import ad_astra_giselle_addon.common.enchantment.EnchantmentHelper2;
import ad_astra_giselle_addon.common.entity.LivingHelper;
import ad_astra_giselle_addon.common.item.ItemStackReference;
import ad_astra_giselle_addon.common.item.ItemUsableResource;
import com.mojang.datafixers.util.Pair;
import earth.terrarium.botarium.common.item.ItemStackHolder;
import net.minecraft.world.entity.LivingEntity;
import org.jetbrains.annotations.NotNull;

public abstract class ProofEnchantmentSession
extends ProofSession {
    private AddonEnchantment enchantment;
    private ItemStackHolder enchantedItem;
    private int enchantLevel;
    private ItemUsableResource testedUsableResource;

    public ProofEnchantmentSession(LivingEntity living, AddonEnchantment enchantment) {
        super(living);
        this.enchantment = enchantment;
        @NotNull Pair<ItemStackReference, Integer> pair = EnchantmentHelper2.getEnchantmentItemAndLevel(enchantment, living);
        this.enchantedItem = (ItemStackHolder)pair.getFirst();
        this.enchantLevel = (Integer)pair.getSecond();
        this.testedUsableResource = null;
    }

    @Override
    public boolean canProvide() {
        if (!super.canProvide()) {
            return false;
        }
        ItemStackHolder enchantedItem = this.getEnchantedItem();
        int enchantLevel = this.getEnchantLevel();
        if (enchantedItem == null || enchantLevel == 0) {
            return false;
        }
        if (LivingHelper.isPlayingMode(this.getLiving())) {
            long using;
            long extracting;
            ItemUsableResource resource;
            this.testedUsableResource = resource = ItemUsableResource.first(enchantedItem.getStack());
            return resource != null && (extracting = resource.extract(enchantedItem, using = this.getResourceUsingAmount(resource), true)) >= using;
        }
        this.testedUsableResource = ItemUsableResource.None;
        return true;
    }

    @Override
    public void onProvide() {
        super.onProvide();
        LivingEntity entity = this.getLiving();
        if (LivingHelper.isPlayingMode(entity) && !entity.m_9236_().m_5776_()) {
            ItemStackHolder enchantedItem = this.getEnchantedItem();
            ItemUsableResource resource = this.getTestedUsableResource();
            long using = this.getResourceUsingAmount(resource);
            resource.extract(enchantedItem, using, false);
        }
    }

    public abstract long getResourceUsingAmount(ItemUsableResource var1);

    public abstract int getProofDuration(ItemUsableResource var1);

    @Override
    public int getProofDuration() {
        ItemUsableResource resource = this.getTestedUsableResource();
        if (resource == ItemUsableResource.None) {
            return 10;
        }
        return this.getProofDuration(resource);
    }

    public AddonEnchantment getEnchantment() {
        return this.enchantment;
    }

    public ItemStackHolder getEnchantedItem() {
        return this.enchantedItem;
    }

    public int getEnchantLevel() {
        return this.enchantLevel;
    }

    public ItemUsableResource getTestedUsableResource() {
        return this.testedUsableResource;
    }
}

