/*
 * Decompiled with CFR 0.152.
 */
package ad_astra_giselle_addon.client.screen;

import ad_astra_giselle_addon.client.screen.AddonMachineScreen;
import ad_astra_giselle_addon.client.screen.ElementSliderButton;
import ad_astra_giselle_addon.client.screen.GuiUtil2;
import ad_astra_giselle_addon.common.AdAstraGiselleAddon;
import ad_astra_giselle_addon.common.block.entity.GravityNormalizerBlockEntity;
import ad_astra_giselle_addon.common.menu.GravityNormalizerMenu;
import ad_astra_giselle_addon.common.network.AddonNetwork;
import ad_astra_giselle_addon.common.network.GravityNormalizerMessage;
import ad_astra_giselle_addon.common.util.Vec3iUtils;
import com.teamresourceful.resourcefullib.common.networking.base.Packet;
import earth.terrarium.ad_astra.client.screen.GuiUtil;
import java.awt.Rectangle;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.IntConsumer;
import java.util.function.IntSupplier;
import java.util.function.Supplier;
import java.util.function.ToIntFunction;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Inventory;

public class GravityNormalizerScreen
extends AddonMachineScreen<GravityNormalizerBlockEntity, GravityNormalizerMenu> {
    public static final ResourceLocation TEXTURE = AdAstraGiselleAddon.rl("textures/gui/container/gravity_normalizer.png");
    public static final Component VECTOR_ELEMENT_MINUS_TEXT = Component.m_237113_((String)"-");
    public static final Component VECTOR_ELEMENT_PLUS_TEXT = Component.m_237113_((String)"+");
    public static final String VECTOR_ELEMENT_TOOLTIP = GravityNormalizerScreen.ctl("gravity_normalizer.vector_element_tooltip");
    public static final Component MOVE_TO_POS_COMPONENT = Component.m_237115_((String)GravityNormalizerScreen.ctl("gravity_normalizer.move_to_pos"));
    public static final String ENERGY_USING_KEY = GravityNormalizerScreen.ctl("gravity_normalizer.energy_using");
    public static final DecimalFormat DECIMAL_FORMAT = new DecimalFormat("+#;-#");
    public static final int DELTA_NORMAL = 1;
    public static final int DELTA_SHIFT = 5;
    public static final Component MINUS_TOOLTIP = GravityNormalizerScreen.createVectorElementButtonTooltipComponent(-1);
    public static final Component PLUS_TOOLTIP = GravityNormalizerScreen.createVectorElementButtonTooltipComponent(1);
    public static final int ENERGY_LEFT = 146;
    public static final int ENERGY_TOP = 22;
    protected final List<AbstractWidget> element_length_x_widgets;
    protected final List<AbstractWidget> element_length_y_widgets;
    protected final List<AbstractWidget> element_length_z_widgets;
    protected final List<AbstractWidget> element_offset_x_widgets;
    protected final List<AbstractWidget> element_offset_y_widgets;
    protected final List<AbstractWidget> element_offset_z_widgets;
    protected Button moveToPosButton;

    public GravityNormalizerScreen(GravityNormalizerMenu menu, Inventory inventory, Component title) {
        super(menu, inventory, title, TEXTURE);
        this.f_97726_ = 176;
        this.f_97727_ = 196;
        this.f_97731_ = this.f_97727_ - 94;
        this.element_length_x_widgets = new ArrayList<AbstractWidget>();
        this.element_length_y_widgets = new ArrayList<AbstractWidget>();
        this.element_length_z_widgets = new ArrayList<AbstractWidget>();
        this.element_offset_x_widgets = new ArrayList<AbstractWidget>();
        this.element_offset_y_widgets = new ArrayList<AbstractWidget>();
        this.element_offset_z_widgets = new ArrayList<AbstractWidget>();
    }

    @Override
    protected void m_7856_() {
        super.m_7856_();
        int x = this.f_97735_ + 6;
        int y = this.f_97736_ + 18;
        int lengthMin = GravityNormalizerBlockEntity.getMinLength();
        int lengthMax = GravityNormalizerBlockEntity.getMaxLength();
        int offsetMin = GravityNormalizerBlockEntity.getMinOffset();
        int offsetMax = GravityNormalizerBlockEntity.getMaxOffset();
        GravityNormalizerBlockEntity machine = (GravityNormalizerBlockEntity)((GravityNormalizerMenu)this.m_6262_()).getMachine();
        Supplier<Vec3i> getLength = machine::getLength;
        Consumer<Vec3i> setLength = vec -> this.setMachineLength(machine, (Vec3i)vec);
        Supplier<Vec3i> getOffset = machine::getOffset;
        Consumer<Vec3i> setOffset = vec -> this.setMachineOffset(machine, (Vec3i)vec);
        int layoutY = y;
        int offset = 12;
        this.element_length_x_widgets.clear();
        this.element_length_x_widgets.addAll(this.addVectorElementComponents(x, layoutY, GravityNormalizerScreen.ctl("gravity_normalizer.length.x"), lengthMin, lengthMax, getLength, setLength, Vec3i::m_123341_, Vec3iUtils::deriveX));
        this.element_length_y_widgets.clear();
        this.element_length_y_widgets.addAll(this.addVectorElementComponents(x, layoutY += offset, GravityNormalizerScreen.ctl("gravity_normalizer.length.y"), lengthMin, lengthMax, getLength, setLength, Vec3i::m_123342_, Vec3iUtils::deriveY));
        this.element_length_z_widgets.clear();
        this.element_length_z_widgets.addAll(this.addVectorElementComponents(x, layoutY += offset, GravityNormalizerScreen.ctl("gravity_normalizer.length.z"), lengthMin, lengthMax, getLength, setLength, Vec3i::m_123343_, Vec3iUtils::deriveZ));
        this.moveToPosButton = new Button.Builder(MOVE_TO_POS_COMPONENT, b -> this.setMachineOffset(machine, GravityNormalizerBlockEntity.offsetFromLength((Vec3i)getLength.get()))).m_252987_(x, layoutY += offset, 132, 10).m_253136_();
        this.m_142416_((GuiEventListener)this.moveToPosButton);
        this.element_offset_x_widgets.clear();
        this.element_offset_x_widgets.addAll(this.addVectorElementComponents(x, layoutY += offset, GravityNormalizerScreen.ctl("gravity_normalizer.offset.x"), offsetMin, offsetMax, getOffset, setOffset, Vec3i::m_123341_, Vec3iUtils::deriveX));
        this.element_offset_y_widgets.clear();
        this.element_offset_y_widgets.addAll(this.addVectorElementComponents(x, layoutY += offset, GravityNormalizerScreen.ctl("gravity_normalizer.offset.y"), offsetMin, offsetMax, getOffset, setOffset, Vec3i::m_123342_, Vec3iUtils::deriveY));
        this.element_offset_z_widgets.clear();
        this.element_offset_z_widgets.addAll(this.addVectorElementComponents(x, layoutY += offset, GravityNormalizerScreen.ctl("gravity_normalizer.offset.z"), offsetMin, offsetMax, getOffset, setOffset, Vec3i::m_123343_, Vec3iUtils::deriveZ));
    }

    protected List<AbstractWidget> addVectorElementComponents(int x, int y, String translationKey, int elementMin, int elementMax, Supplier<Vec3i> vectorGetter, Consumer<Vec3i> vectorSetter, ToIntFunction<Vec3i> elementGetter, BiFunction<Vec3i, Integer, Vec3i> elementSetter) {
        IntSupplier mergedGetter = this.getMergedElementGetter(vectorGetter, elementGetter);
        IntConsumer mergedSetter = this.getMergedElementSetter(vectorGetter, vectorSetter, elementSetter, elementMin, elementMax);
        ArrayList<AbstractWidget> widgets = new ArrayList<AbstractWidget>();
        int buttonWidth = 16;
        int buttonHeight = 10;
        int sliderX = x;
        int sliderWidth = 100;
        int sliderHeight = buttonHeight;
        widgets.add((AbstractWidget)this.m_142416_((GuiEventListener)new ElementSliderButton(sliderX, y, sliderWidth, sliderHeight, translationKey, mergedGetter.getAsInt(), elementMin, elementMax, mergedSetter::accept)));
        int minusButtonX = sliderX + sliderWidth;
        widgets.add((AbstractWidget)this.m_142416_((GuiEventListener)new Button.Builder(VECTOR_ELEMENT_MINUS_TEXT, b -> this.onVectorElementButtonClick(-1, mergedGetter, mergedSetter)).m_252987_(minusButtonX, y, buttonWidth, buttonHeight).m_257505_(Tooltip.m_257550_((Component)MINUS_TOOLTIP)).m_253136_()));
        int plusButtonX = minusButtonX + buttonWidth;
        widgets.add((AbstractWidget)this.m_142416_((GuiEventListener)new Button.Builder(VECTOR_ELEMENT_PLUS_TEXT, b -> this.onVectorElementButtonClick(1, mergedGetter, mergedSetter)).m_252987_(plusButtonX, y, buttonWidth, buttonHeight).m_257505_(Tooltip.m_257550_((Component)PLUS_TOOLTIP)).m_253136_()));
        return widgets;
    }

    protected void onVectorElementButtonClick(int direction, IntSupplier mergedGetter, IntConsumer mergedSetter) {
        int delta = direction * (Screen.m_96638_() ? 5 : 1);
        mergedSetter.accept(mergedGetter.getAsInt() + delta);
    }

    protected IntSupplier getMergedElementGetter(Supplier<Vec3i> vectorGetter, ToIntFunction<Vec3i> elementGetter) {
        return () -> {
            Vec3i vec = (Vec3i)vectorGetter.get();
            return elementGetter.applyAsInt(vec);
        };
    }

    protected IntConsumer getMergedElementSetter(Supplier<Vec3i> vectorGetter, Consumer<Vec3i> vectorSetter, BiFunction<Vec3i, Integer, Vec3i> elementSetter, int min, int max) {
        return i -> {
            Vec3i vec = (Vec3i)vectorGetter.get();
            Vec3i newVec = (Vec3i)elementSetter.apply(vec, Mth.m_14045_((int)i, (int)min, (int)max));
            vectorSetter.accept(newVec);
        };
    }

    protected void m_7286_(GuiGraphics guiGraphics, float partialTicks, int mouseX, int mouseY) {
        super.m_7286_(guiGraphics, partialTicks, mouseX, mouseY);
    }

    @Override
    public void m_88315_(GuiGraphics guiGraphics, int mouseX, int mouseY, float delta) {
        super.m_88315_(guiGraphics, mouseX, mouseY, delta);
        GravityNormalizerMenu menu = (GravityNormalizerMenu)this.m_6262_();
        GravityNormalizerBlockEntity machine = (GravityNormalizerBlockEntity)menu.getMachine();
        Vec3i length = machine.getLength();
        this.setElement(this.element_length_x_widgets, length.m_123341_());
        this.setElement(this.element_length_y_widgets, length.m_123342_());
        this.setElement(this.element_length_z_widgets, length.m_123343_());
        Vec3i offset = machine.getOffset();
        this.setElement(this.element_offset_x_widgets, offset.m_123341_());
        this.setElement(this.element_offset_y_widgets, offset.m_123342_());
        this.setElement(this.element_offset_z_widgets, offset.m_123343_());
        long maxCapacity = machine.getEnergyStorage().getMaxCapacity();
        GuiUtil2.drawEnergy(guiGraphics, this.getEnergyBounds(), menu.getEnergyAmount(), maxCapacity);
        if (GuiUtil.isHovering((Rectangle)this.getEnergyBounds(), (double)mouseX, (double)mouseY)) {
            GuiUtil.drawEnergyTooltip((GuiGraphics)guiGraphics, (long)menu.getEnergyAmount(), (long)maxCapacity, (int)mouseX, (int)mouseY);
        }
    }

    protected void m_280003_(GuiGraphics guiGraphics, int mouseX, int mouseY) {
        super.m_280003_(guiGraphics, mouseX, mouseY);
        GravityNormalizerBlockEntity machine = (GravityNormalizerBlockEntity)((GravityNormalizerMenu)this.m_6262_()).getMachine();
        long energyUsing = machine.getEnergyUsing();
        int maxTimer = machine.getMaxTimer();
        MutableComponent component = Component.m_237110_((String)ENERGY_USING_KEY, (Object[])new Object[]{String.valueOf(energyUsing), String.valueOf(maxTimer)});
        int componentWidth = this.f_96547_.m_92852_((FormattedText)component);
        guiGraphics.m_280614_(this.f_96547_, (Component)component, this.f_97726_ - 6 - componentWidth, this.f_97731_, this.getTextColour(), false);
    }

    protected void setMachineLength(GravityNormalizerBlockEntity blockEntity, Vec3i length) {
        if (!blockEntity.getLength().equals((Object)length)) {
            blockEntity.setLength(length);
            AddonNetwork.CHANNEL.sendToServer((Packet)new GravityNormalizerMessage.Length(blockEntity, length));
        }
    }

    protected void setMachineOffset(GravityNormalizerBlockEntity blockEntity, Vec3i offset) {
        if (!blockEntity.getOffset().equals((Object)offset)) {
            blockEntity.setOffset(offset);
            AddonNetwork.CHANNEL.sendToServer((Packet)new GravityNormalizerMessage.Offset(blockEntity, offset));
        }
    }

    protected void setElement(List<AbstractWidget> widgets, int value) {
        for (AbstractWidget widget : widgets) {
            if (!(widget instanceof ElementSliderButton)) continue;
            ElementSliderButton slider = (ElementSliderButton)widget;
            slider.setIntValue(value);
        }
    }

    public Rectangle getEnergyBounds() {
        return GuiUtil.getEnergyBounds((int)(this.f_97735_ + 146), (int)(this.f_97736_ + 22));
    }

    public static Component createVectorElementButtonTooltipComponent(int direction) {
        return Component.m_237110_((String)VECTOR_ELEMENT_TOOLTIP, (Object[])new Object[]{DECIMAL_FORMAT.format(direction * 1), DECIMAL_FORMAT.format(direction * 5)});
    }
}

