/*
 * Decompiled with CFR 0.152.
 */
package com.the9grounds.aeadditions.me.storage;

import appeng.api.config.Actionable;
import appeng.api.config.IncludeExclude;
import appeng.api.networking.security.IActionSource;
import appeng.api.stacks.AEItemKey;
import appeng.api.stacks.AEKey;
import appeng.api.stacks.AEKeyType;
import appeng.api.stacks.AEKeyTypes;
import appeng.api.stacks.KeyCounter;
import appeng.api.storage.cells.CellState;
import appeng.api.storage.cells.ISaveProvider;
import appeng.api.storage.cells.StorageCell;
import appeng.core.AELog;
import appeng.util.prioritylist.FuzzyPriorityList;
import appeng.util.prioritylist.IPartitionList;
import com.the9grounds.aeadditions.item.storage.SuperStorageCell;
import it.unimi.dsi.fastutil.longs.LongArrayList;
import it.unimi.dsi.fastutil.objects.Object2LongOpenHashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.TypeIntrinsics;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u00aa\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0010\t\n\u0002\b\u0005\n\u0002\u0010\u001d\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001c\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\n\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u000f\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u0000 l2\u00020\u0001:\u0001lB!\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\u0002\u0010\bJ\u0006\u0010@\u001a\u00020\u001eJ,\u0010A\u001a\u00020\u000e2\b\u0010B\u001a\u0004\u0018\u00010\r2\u0006\u0010C\u001a\u00020\u000e2\u0006\u0010D\u001a\u00020E2\b\u0010F\u001a\u0004\u0018\u00010GH\u0016J\u0010\u0010H\u001a\u00020I2\u0006\u0010J\u001a\u00020KH\u0016J\b\u0010L\u001a\u00020#H\u0016J\b\u0010M\u001a\u00020NH\u0016J\u0006\u0010O\u001a\u00020\u000eJ\b\u0010P\u001a\u00020QH\u0016J\u0006\u0010R\u001a\u00020\u000eJ\u000e\u0010S\u001a\u00020\u000e2\u0006\u0010T\u001a\u00020\u0015J\u0006\u0010U\u001a\u00020\u000eJ\n\u0010V\u001a\u0004\u0018\u00010WH\u0016J\b\u0010X\u001a\u00020\u000eH\u0016J\u000e\u0010Y\u001a\u00020\u000e2\u0006\u0010T\u001a\u00020\u0015J\b\u0010Z\u001a\u00020\u000eH\u0016J\n\u0010[\u001a\u0004\u0018\u00010?H\u0016J\u0006\u0010\\\u001a\u00020\u000eJ\b\u0010]\u001a\u00020\u000eH\u0016J\u0006\u0010^\u001a\u00020#J\u000e\u0010_\u001a\u00020#2\u0006\u0010T\u001a\u00020\u0015J\u0006\u0010`\u001a\u00020\u000eJ\u000e\u0010a\u001a\u00020\u000e2\u0006\u0010T\u001a\u00020\u0015J(\u0010b\u001a\u00020\u000e2\u0006\u0010B\u001a\u00020\r2\u0006\u0010C\u001a\u00020\u000e2\u0006\u0010D\u001a\u00020E2\u0006\u0010F\u001a\u00020GH\u0002J.\u0010c\u001a\u00020\u000e2\b\u0010B\u001a\u0004\u0018\u00010\r2\u0006\u0010C\u001a\u00020\u000e2\b\u0010D\u001a\u0004\u0018\u00010E2\b\u0010F\u001a\u0004\u0018\u00010GH\u0016J\u0006\u0010d\u001a\u00020\u001eJ\u0010\u0010e\u001a\u00020\u001e2\u0006\u0010f\u001a\u00020gH\u0002J\b\u0010h\u001a\u00020IH\u0002J\b\u0010i\u001a\u00020IH\u0016J\b\u0010j\u001a\u00020IH\u0002J\b\u0010k\u001a\u00020IH\u0014R\u0013\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR*\u0010\u000b\u001a\u0010\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u000e\u0018\u00010\f8DX\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\u0010\"\u0004\b\u0011\u0010\u0012R5\u0010\u0013\u001a&\u0012\f\u0012\n \u0016*\u0004\u0018\u00010\u00150\u0015 \u0016*\u0012\u0012\f\u0012\n \u0016*\u0004\u0018\u00010\u00150\u0015\u0018\u00010\u00170\u0014\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R\u000e\u0010\u001a\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u001cR\u000e\u0010\u001d\u001a\u00020\u001eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001f\u001a\u00020\u001eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b \u0010!R\u001a\u0010\"\u001a\u00020#X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b$\u0010%\"\u0004\b&\u0010'R\u000e\u0010(\u001a\u00020#X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010)\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R&\u0010*\u001a\u000e\u0012\u0004\u0012\u00020\u0015\u0012\u0004\u0012\u00020#0\fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b+\u0010\u0010\"\u0004\b,\u0010\u0012R\"\u0010/\u001a\u0004\u0018\u00010.2\b\u0010-\u001a\u0004\u0018\u00010.@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b0\u00101R\"\u00103\u001a\u0004\u0018\u0001022\b\u0010-\u001a\u0004\u0018\u000102@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b4\u00105R\u000e\u00106\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R&\u00107\u001a\u000e\u0012\u0004\u0012\u00020\u0015\u0012\u0004\u0012\u00020\u000e0\fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b8\u0010\u0010\"\u0004\b9\u0010\u0012R\u0016\u0010:\u001a\u00020;8BX\u0082\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b<\u0010=R\u0010\u0010>\u001a\u0004\u0018\u00010?X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006m"}, d2={"Lcom/the9grounds/aeadditions/me/storage/SuperCellInventory;", "Lappeng/api/storage/cells/StorageCell;", "cell", "Lcom/the9grounds/aeadditions/item/storage/SuperStorageCell;", "itemStackLocal", "Lnet/minecraft/world/item/ItemStack;", "container", "Lappeng/api/storage/cells/ISaveProvider;", "(Lcom/the9grounds/aeadditions/item/storage/SuperStorageCell;Lnet/minecraft/world/item/ItemStack;Lappeng/api/storage/cells/ISaveProvider;)V", "getCell", "()Lcom/the9grounds/aeadditions/item/storage/SuperStorageCell;", "cellItems", "", "Lappeng/api/stacks/AEKey;", "", "getCellItems", "()Ljava/util/Map;", "setCellItems", "(Ljava/util/Map;)V", "cellTypes", "", "Lappeng/api/stacks/AEKeyType;", "kotlin.jvm.PlatformType", "", "getCellTypes", "()Ljava/lang/Iterable;", "computedUsedBytes", "getContainer", "()Lappeng/api/storage/cells/ISaveProvider;", "hasVoidUpgrade", "", "isPersisted", "getItemStackLocal", "()Lnet/minecraft/world/item/ItemStack;", "itemsPerByte", "", "getItemsPerByte", "()I", "setItemsPerByte", "(I)V", "maxItemTypes", "maxItemsPerType", "numberOfTypesByKeyType", "getNumberOfTypesByKeyType", "setNumberOfTypesByKeyType", "<set-?>", "Lappeng/util/prioritylist/IPartitionList;", "partitionList", "getPartitionList", "()Lappeng/util/prioritylist/IPartitionList;", "Lappeng/api/config/IncludeExclude;", "partitionListMode", "getPartitionListMode", "()Lappeng/api/config/IncludeExclude;", "storedItemCount", "storedItemCountByKeyType", "getStoredItemCountByKeyType", "setStoredItemCountByKeyType", "storedItems", "", "getStoredItems", "()S", "tagCompound", "Lnet/minecraft/nbt/CompoundTag;", "canHoldNewItem", "extract", "what", "amount", "mode", "Lappeng/api/config/Actionable;", "source", "Lappeng/api/networking/security/IActionSource;", "getAvailableStacks", "", "out", "Lappeng/api/stacks/KeyCounter;", "getBytesPerType", "getDescription", "Lnet/minecraft/network/chat/Component;", "getFreeBytes", "getIdleDrain", "", "getRemainingItemCount", "getRemainingItemCountForKeyType", "keyType", "getRemainingItemTypes", "getStatus", "Lappeng/api/storage/cells/CellState;", "getStoredItemCount", "getStoredItemCountForKeyType", "getStoredItemTypes", "getTag", "getTotalBytes", "getTotalItemTypes", "getUnusedItemCount", "getUnusedItemCountForKeyType", "getUsedBytes", "getUsedBytesForType", "innerInsert", "insert", "isFuzzy", "isStorageCell", "key", "Lappeng/api/stacks/AEItemKey;", "loadCellItems", "persist", "recalculateValues", "saveChanges", "Companion", "AEAdditions-1.20.1"})
public final class SuperCellInventory
implements StorageCell {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private final SuperStorageCell cell;
    @NotNull
    private final ItemStack itemStackLocal;
    @Nullable
    private final ISaveProvider container;
    @Nullable
    private CompoundTag tagCompound;
    private int maxItemTypes;
    private short storedItems;
    private long storedItemCount;
    @Nullable
    private IPartitionList partitionList;
    @Nullable
    private IncludeExclude partitionListMode;
    private long maxItemsPerType;
    private boolean hasVoidUpgrade;
    @Nullable
    private Map<AEKey, Long> cellItems;
    private int itemsPerByte;
    private boolean isPersisted;
    private long computedUsedBytes;
    @NotNull
    private Map<AEKeyType, Integer> numberOfTypesByKeyType;
    @NotNull
    private Map<AEKeyType, Long> storedItemCountByKeyType;
    private final Iterable<AEKeyType> cellTypes;
    private static final int MAX_ITEM_TYPES = 1000;
    @NotNull
    private static final String ITEM_TYPE_TAG = "it";
    @NotNull
    private static final String ITEM_COUNT_TAG = "ic";
    @NotNull
    private static final String ITEM_SLOT = "#";
    @NotNull
    private static final String ITEM_SLOT_COUNT = "@";
    @NotNull
    private static final String STACK_KEYS = "keys";
    @NotNull
    private static final String STACK_AMOUNTS = "amts";
    @NotNull
    private static final String[] ITEM_SLOT_KEYS = new String[MAX_ITEM_TYPES];
    @NotNull
    private static final String[] ITEM_SLOT_COUNT_KEYS = new String[MAX_ITEM_TYPES];

    public SuperCellInventory(@Nullable SuperStorageCell cell, @NotNull ItemStack itemStackLocal, @Nullable ISaveProvider container) {
        Intrinsics.checkNotNullParameter((Object)itemStackLocal, (String)"itemStackLocal");
        this.cell = cell;
        this.itemStackLocal = itemStackLocal;
        this.container = container;
        this.maxItemTypes = MAX_ITEM_TYPES;
        this.maxItemsPerType = Long.MAX_VALUE;
        this.isPersisted = true;
        this.numberOfTypesByKeyType = new LinkedHashMap();
        this.storedItemCountByKeyType = new LinkedHashMap();
        this.cellTypes = AEKeyTypes.getAll();
        for (AEKeyType keyType : this.cellTypes) {
            Intrinsics.checkNotNullExpressionValue((Object)keyType, (String)"keyType");
            this.numberOfTypesByKeyType.put(keyType, 0);
        }
        SuperStorageCell superStorageCell = this.cell;
        Intrinsics.checkNotNull((Object)((Object)superStorageCell));
        this.maxItemTypes = superStorageCell.getTotalTypes(this.itemStackLocal);
        if (this.maxItemTypes > MAX_ITEM_TYPES) {
            this.maxItemTypes = MAX_ITEM_TYPES;
        }
        if (this.maxItemTypes < 1) {
            this.maxItemTypes = 1;
        }
        CompoundTag compoundTag = this.tagCompound = this.itemStackLocal.m_41784_();
        Intrinsics.checkNotNull((Object)compoundTag);
        this.storedItems = compoundTag.m_128448_(ITEM_TYPE_TAG);
        CompoundTag compoundTag2 = this.tagCompound;
        Intrinsics.checkNotNull((Object)compoundTag2);
        this.storedItemCount = compoundTag2.m_128454_(ITEM_COUNT_TAG);
        CompoundTag compoundTag3 = this.tagCompound;
        Intrinsics.checkNotNull((Object)compoundTag3);
        this.computedUsedBytes = compoundTag3.m_128454_("usedBytes");
        this.cellItems = null;
        this.recalculateValues();
    }

    @Nullable
    public final SuperStorageCell getCell() {
        return this.cell;
    }

    @NotNull
    public final ItemStack getItemStackLocal() {
        return this.itemStackLocal;
    }

    @Nullable
    public final ISaveProvider getContainer() {
        return this.container;
    }

    private final short getStoredItems() {
        Map<AEKey, Long> map = this.getCellItems();
        return (short)(map != null ? map.size() : 0);
    }

    @Nullable
    public final IPartitionList getPartitionList() {
        return this.partitionList;
    }

    @Nullable
    public final IncludeExclude getPartitionListMode() {
        return this.partitionListMode;
    }

    @Nullable
    protected final Map<AEKey, Long> getCellItems() {
        if (this.cellItems == null) {
            this.cellItems = (Map)new Object2LongOpenHashMap();
            this.loadCellItems();
        }
        return this.cellItems;
    }

    protected final void setCellItems(@Nullable Map<AEKey, Long> map) {
        this.cellItems = map;
    }

    protected final int getItemsPerByte() {
        return this.itemsPerByte;
    }

    protected final void setItemsPerByte(int n) {
        this.itemsPerByte = n;
    }

    @NotNull
    public final Map<AEKeyType, Integer> getNumberOfTypesByKeyType() {
        return this.numberOfTypesByKeyType;
    }

    public final void setNumberOfTypesByKeyType(@NotNull Map<AEKeyType, Integer> map) {
        Intrinsics.checkNotNullParameter(map, (String)"<set-?>");
        this.numberOfTypesByKeyType = map;
    }

    @NotNull
    public final Map<AEKeyType, Long> getStoredItemCountByKeyType() {
        return this.storedItemCountByKeyType;
    }

    public final void setStoredItemCountByKeyType(@NotNull Map<AEKeyType, Long> map) {
        Intrinsics.checkNotNullParameter(map, (String)"<set-?>");
        this.storedItemCountByKeyType = map;
    }

    public final Iterable<AEKeyType> getCellTypes() {
        return this.cellTypes;
    }

    public void persist() {
        if (this.isPersisted) {
            return;
        }
        long itemCount = 0L;
        Map localItemCountByKeyType = new LinkedHashMap();
        Map localNumberOfTypesByKeyType = new LinkedHashMap();
        Map<AEKey, Long> map = this.getCellItems();
        Intrinsics.checkNotNull(map);
        LongArrayList amounts = new LongArrayList(map.size());
        ListTag keys = new ListTag();
        Map<AEKey, Long> map2 = this.getCellItems();
        Intrinsics.checkNotNull(map2);
        for (Map.Entry<AEKey, Long> entry : map2.entrySet()) {
            long amount = ((Number)entry.getValue()).longValue();
            if (amount <= 0L) continue;
            Long l = (Long)localItemCountByKeyType.get(entry.getKey().getType());
            long currentAmount = l != null ? l : 0L;
            Map map3 = localItemCountByKeyType;
            AEKeyType aEKeyType = entry.getKey().getType();
            Intrinsics.checkNotNullExpressionValue((Object)aEKeyType, (String)"entry.key.type");
            Object object = aEKeyType;
            Long l2 = currentAmount + amount;
            map3.put(object, l2);
            keys.add((Object)entry.getKey().toTagGeneric());
            amounts.add(amount);
            Integer n = (Integer)localNumberOfTypesByKeyType.get(entry.getKey().getType());
            int currentNumber = n != null ? n : 0;
            object = localNumberOfTypesByKeyType;
            AEKeyType aEKeyType2 = entry.getKey().getType();
            Intrinsics.checkNotNullExpressionValue((Object)aEKeyType2, (String)"entry.key.type");
            l2 = aEKeyType2;
            Integer n2 = currentNumber + 1;
            object.put(l2, n2);
        }
        if (keys.isEmpty()) {
            CompoundTag compoundTag = this.getTag();
            Intrinsics.checkNotNull((Object)compoundTag);
            compoundTag.m_128473_(STACK_KEYS);
            CompoundTag compoundTag2 = this.getTag();
            Intrinsics.checkNotNull((Object)compoundTag2);
            compoundTag2.m_128473_(STACK_AMOUNTS);
        } else {
            CompoundTag compoundTag = this.getTag();
            Intrinsics.checkNotNull((Object)compoundTag);
            compoundTag.m_128365_(STACK_KEYS, (Tag)keys);
            CompoundTag compoundTag3 = this.getTag();
            Intrinsics.checkNotNull((Object)compoundTag3);
            compoundTag3.m_128388_(STACK_AMOUNTS, amounts.toArray(new long[0]));
        }
        Map<AEKey, Long> map4 = this.getCellItems();
        Intrinsics.checkNotNull(map4);
        this.storedItems = (short)map4.size();
        this.storedItemCount = itemCount;
        this.storedItemCountByKeyType = localItemCountByKeyType;
        this.numberOfTypesByKeyType = localNumberOfTypesByKeyType;
        long localComputedUsedBytes = 0L;
        for (AEKeyType keyType : this.cellTypes) {
            Intrinsics.checkNotNullExpressionValue((Object)keyType, (String)"keyType");
            localComputedUsedBytes += this.getUsedBytesForType(keyType);
        }
        this.computedUsedBytes = localComputedUsedBytes;
        if (this.computedUsedBytes == 0L) {
            CompoundTag compoundTag = this.getTag();
            Intrinsics.checkNotNull((Object)compoundTag);
            compoundTag.m_128473_(ITEM_COUNT_TAG);
        } else {
            CompoundTag compoundTag = this.getTag();
            Intrinsics.checkNotNull((Object)compoundTag);
            compoundTag.m_128356_(ITEM_COUNT_TAG, this.computedUsedBytes);
            CompoundTag compoundTag4 = this.getTag();
            Intrinsics.checkNotNull((Object)compoundTag4);
            compoundTag4.m_128356_("usedBytes", this.computedUsedBytes);
        }
        this.isPersisted = true;
    }

    @Nullable
    public CompoundTag getTag() {
        return this.itemStackLocal.m_41784_();
    }

    protected void saveChanges() {
        this.recalculateValues();
        this.isPersisted = false;
        if (this.container != null) {
            this.container.saveChanges();
        } else {
            this.persist();
        }
    }

    private final void recalculateValues() {
        Map<AEKey, Long> map = this.getCellItems();
        Intrinsics.checkNotNull(map);
        this.storedItems = (short)map.size();
        this.storedItemCount = 0L;
        Map localItemCountByKeyType = new LinkedHashMap();
        Map localNumberOfTypesByKeyType = new LinkedHashMap();
        Map<AEKey, Long> map2 = this.getCellItems();
        Intrinsics.checkNotNull(map2);
        for (Map.Entry<AEKey, Long> entry : map2.entrySet()) {
            Long l = (Long)localItemCountByKeyType.get(entry.getKey().getType());
            long currentAmount = l != null ? l : 0L;
            Map map3 = localItemCountByKeyType;
            AEKeyType aEKeyType = entry.getKey().getType();
            Intrinsics.checkNotNullExpressionValue((Object)aEKeyType, (String)"entry.key.type");
            Object object = aEKeyType;
            Long l2 = currentAmount + ((Number)entry.getValue()).longValue();
            map3.put(object, l2);
            Long l3 = entry.getValue();
            Intrinsics.checkNotNull((Object)l3);
            this.storedItemCount += ((Number)l3).longValue();
            Integer n = (Integer)localNumberOfTypesByKeyType.get(entry.getKey().getType());
            int currentNumber = n != null ? n : 0;
            object = localNumberOfTypesByKeyType;
            AEKeyType aEKeyType2 = entry.getKey().getType();
            Intrinsics.checkNotNullExpressionValue((Object)aEKeyType2, (String)"entry.key.type");
            l2 = aEKeyType2;
            Integer n2 = currentNumber + 1;
            object.put(l2, n2);
        }
        this.storedItemCountByKeyType = localItemCountByKeyType;
        this.numberOfTypesByKeyType = localNumberOfTypesByKeyType;
        long localComputedUsedBytes = 0L;
        for (AEKeyType keyType : this.cellTypes) {
            Intrinsics.checkNotNullExpressionValue((Object)keyType, (String)"keyType");
            localComputedUsedBytes += this.getUsedBytesForType(keyType);
        }
        this.computedUsedBytes = localComputedUsedBytes;
    }

    private final void loadCellItems() {
        boolean corruptedTag = false;
        CompoundTag compoundTag = this.getTag();
        Intrinsics.checkNotNull((Object)compoundTag);
        long[] amounts = compoundTag.m_128467_(STACK_AMOUNTS);
        CompoundTag compoundTag2 = this.getTag();
        Intrinsics.checkNotNull((Object)compoundTag2);
        ListTag tags = compoundTag2.m_128437_(STACK_KEYS, 10);
        if (amounts.length != tags.size()) {
            Object[] objectArray = new Object[]{amounts.length, tags.size()};
            AELog.warn((String)"Loading storage cell with mismatched amounts/tags: %d != %d", (Object[])objectArray);
        }
        int n = amounts.length;
        for (int i = 0; i < n; ++i) {
            long amount = amounts[i];
            AEKey key = AEKey.fromTagGeneric((CompoundTag)tags.m_128728_(i));
            if (amount <= 0L || key == null) {
                corruptedTag = true;
                continue;
            }
            Map<AEKey, Long> map = this.getCellItems();
            Intrinsics.checkNotNull(map);
            map.put(key, amount);
        }
        this.recalculateValues();
        if (corruptedTag) {
            this.saveChanges();
        }
    }

    public void getAvailableStacks(@NotNull KeyCounter out) {
        Intrinsics.checkNotNullParameter((Object)out, (String)"out");
        Map<AEKey, Long> map = this.getCellItems();
        Intrinsics.checkNotNull(map);
        for (Map.Entry<AEKey, Long> entry : map.entrySet()) {
            out.add(entry.getKey(), ((Number)entry.getValue()).longValue());
        }
    }

    public double getIdleDrain() {
        SuperStorageCell superStorageCell = this.cell;
        Intrinsics.checkNotNull((Object)((Object)superStorageCell));
        return superStorageCell.getIdleDrain();
    }

    public int getBytesPerType() {
        SuperStorageCell superStorageCell = this.cell;
        Intrinsics.checkNotNull((Object)((Object)superStorageCell));
        return superStorageCell.getBytesPerType(this.itemStackLocal);
    }

    public final boolean canHoldNewItem() {
        return this.getTotalBytes() > this.getUsedBytes() && this.getRemainingItemTypes() > 0L;
    }

    public final long getTotalBytes() {
        SuperStorageCell superStorageCell = this.cell;
        Intrinsics.checkNotNull((Object)((Object)superStorageCell));
        return superStorageCell.getBytes(this.itemStackLocal);
    }

    public final long getFreeBytes() {
        return this.getTotalBytes() - this.getUsedBytes();
    }

    public long getTotalItemTypes() {
        return this.maxItemTypes;
    }

    public long getStoredItemCount() {
        long storedItemCount = 0L;
        for (Map.Entry<AEKeyType, Long> keyType : this.storedItemCountByKeyType.entrySet()) {
            storedItemCount += ((Number)keyType.getValue()).longValue();
        }
        return storedItemCount;
    }

    public final long getStoredItemCountForKeyType(@NotNull AEKeyType keyType) {
        Intrinsics.checkNotNullParameter((Object)keyType, (String)"keyType");
        Long l = this.storedItemCountByKeyType.get(keyType);
        return l != null ? l : 0L;
    }

    public long getStoredItemTypes() {
        return this.getStoredItems();
    }

    public final long getRemainingItemTypes() {
        long baseOnTotal;
        long basedOnStorage = this.getFreeBytes() / (long)this.getBytesPerType();
        return basedOnStorage > (baseOnTotal = this.getTotalItemTypes() - this.getStoredItemTypes()) ? baseOnTotal : basedOnStorage;
    }

    public final long getUsedBytesForType(@NotNull AEKeyType keyType) {
        Intrinsics.checkNotNullParameter((Object)keyType, (String)"keyType");
        long bytesForItemCount = (this.getStoredItemCountForKeyType(keyType) + (long)this.getUnusedItemCountForKeyType(keyType)) / (long)keyType.getAmountPerByte();
        Integer n = this.numberOfTypesByKeyType.get(keyType);
        return (long)((n != null ? n : 0) * this.getBytesPerType()) + bytesForItemCount;
    }

    public final long getUsedBytes() {
        return this.computedUsedBytes;
    }

    public final long getRemainingItemCount() {
        long remaining = this.getFreeBytes() * (long)this.itemsPerByte + (long)this.getUnusedItemCount();
        return remaining > 0L ? remaining : 0L;
    }

    public final long getRemainingItemCountForKeyType(@NotNull AEKeyType keyType) {
        Intrinsics.checkNotNullParameter((Object)keyType, (String)"keyType");
        return this.getFreeBytes() * (long)keyType.getAmountPerByte() + (long)this.getUnusedItemCountForKeyType(keyType);
    }

    public final int getUnusedItemCount() {
        int div = (int)(this.getStoredItemCount() % (long)8);
        return div == 0 ? 0 : this.itemsPerByte - div;
    }

    public final int getUnusedItemCountForKeyType(@NotNull AEKeyType keyType) {
        Intrinsics.checkNotNullParameter((Object)keyType, (String)"keyType");
        int div = (int)(this.getStoredItemCountForKeyType(keyType) % (long)8);
        return div == 0 ? 0 : keyType.getAmountPerByte() - div;
    }

    @Nullable
    public CellState getStatus() {
        if (this.getStoredItemTypes() == 0L) {
            return CellState.EMPTY;
        }
        if (this.canHoldNewItem()) {
            return CellState.NOT_EMPTY;
        }
        return CellState.FULL;
    }

    private final boolean isStorageCell(AEItemKey key) {
        SuperStorageCell type = SuperCellInventory.Companion.getStorageCell(key);
        return type != null && !type.storableInStorageCell();
    }

    public long insert(@Nullable AEKey what, long amount, @Nullable Actionable mode, @Nullable IActionSource source) {
        AEKey aEKey = what;
        Intrinsics.checkNotNull((Object)aEKey);
        Actionable actionable = mode;
        Intrinsics.checkNotNull((Object)actionable);
        IActionSource iActionSource = source;
        Intrinsics.checkNotNull((Object)iActionSource);
        long inserted = this.innerInsert(aEKey, amount, actionable, iActionSource);
        return this.hasVoidUpgrade ? amount : inserted;
    }

    private final long innerInsert(AEKey what, long amount, Actionable mode, IActionSource source) {
        long _amount;
        if (what instanceof AEItemKey && this.isStorageCell((AEItemKey)what)) {
            ItemStack itemStack = ((AEItemKey)what).toStack();
            Intrinsics.checkNotNullExpressionValue((Object)itemStack, (String)"what.toStack()");
            SuperCellInventory meInventory = Companion.createInventory(itemStack, null);
            if (!SuperCellInventory.Companion.isCellEmpty(meInventory)) {
                return 0L;
            }
        }
        Map<AEKey, Long> map = this.getCellItems();
        Intrinsics.checkNotNull(map);
        Long l = map.get(what);
        long currentAmount = l != null ? l : 0L;
        AEKeyType aEKeyType = what.getType();
        Intrinsics.checkNotNullExpressionValue((Object)aEKeyType, (String)"what.type");
        long remainingItemCount = this.getRemainingItemCountForKeyType(aEKeyType);
        if (currentAmount <= 0L) {
            if (!this.canHoldNewItem()) {
                return 0L;
            }
            long l2 = this.getBytesPerType();
            AEKeyType aEKeyType2 = what.getType();
            Intrinsics.checkNotNull((Object)aEKeyType2);
            if ((remainingItemCount -= l2 * (long)aEKeyType2.getAmountPerByte()) <= 0L) {
                return 0L;
            }
        }
        if ((_amount = amount) > (remainingItemCount = Math.max(0L, Math.min(this.maxItemsPerType - currentAmount, remainingItemCount)))) {
            _amount = remainingItemCount;
        }
        if (mode == Actionable.MODULATE) {
            Map<AEKey, Long> map2 = this.getCellItems();
            Intrinsics.checkNotNull(map2);
            map2.put(what, currentAmount + _amount);
            this.saveChanges();
        }
        return _amount;
    }

    public long extract(@Nullable AEKey what, long amount, @NotNull Actionable mode, @Nullable IActionSource source) {
        Intrinsics.checkNotNullParameter((Object)mode, (String)"mode");
        long extractAmount = Math.min(Integer.MAX_VALUE, amount);
        Map<AEKey, Long> map = this.getCellItems();
        Intrinsics.checkNotNull(map);
        Long currentAmount = map.get(what);
        if (currentAmount != null && currentAmount > 0L) {
            if (extractAmount > currentAmount) {
                if (mode == Actionable.MODULATE) {
                    Map<AEKey, Long> map2 = this.getCellItems();
                    Intrinsics.checkNotNull(map2);
                    TypeIntrinsics.asMutableMap(map2).remove(what, currentAmount);
                    this.saveChanges();
                }
                return currentAmount;
            }
            if (mode == Actionable.MODULATE) {
                Map<AEKey, Long> map3 = this.getCellItems();
                Intrinsics.checkNotNull(map3);
                AEKey aEKey = what;
                Intrinsics.checkNotNull((Object)aEKey);
                map3.put(aEKey, currentAmount - extractAmount);
                this.saveChanges();
            }
            return extractAmount;
        }
        return 0L;
    }

    @NotNull
    public Component getDescription() {
        Component component = this.itemStackLocal.m_41786_();
        Intrinsics.checkNotNullExpressionValue((Object)component, (String)"itemStackLocal.hoverName");
        return component;
    }

    public final boolean isFuzzy() {
        return this.partitionList instanceof FuzzyPriorityList;
    }

    static {
        int n = MAX_ITEM_TYPES;
        for (int x = 0; x < n; ++x) {
            SuperCellInventory.ITEM_SLOT_KEYS[x] = ITEM_SLOT + x;
            SuperCellInventory.ITEM_SLOT_COUNT_KEYS[x] = ITEM_SLOT_COUNT + x;
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001a\u0010\u0010\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u0012\u001a\u00020\u00132\b\u0010\u0014\u001a\u0004\u0018\u00010\u0015J\u0012\u0010\u0016\u001a\u0004\u0018\u00010\u00172\u0006\u0010\u0018\u001a\u00020\u0019H\u0002J\u0014\u0010\u0016\u001a\u0004\u0018\u00010\u00172\b\u0010\u001a\u001a\u0004\u0018\u00010\u0013H\u0002J\u0010\u0010\u001b\u001a\u00020\u001c2\b\u0010\u0012\u001a\u0004\u0018\u00010\u0013J\u0012\u0010\u001d\u001a\u00020\u001c2\b\u0010\u001e\u001a\u0004\u0018\u00010\u0011H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u0007\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00040\bX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\tR\u0018\u0010\n\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00040\bX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\tR\u000e\u0010\u000b\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lcom/the9grounds/aeadditions/me/storage/SuperCellInventory$Companion;", "", "()V", "ITEM_COUNT_TAG", "", "ITEM_SLOT", "ITEM_SLOT_COUNT", "ITEM_SLOT_COUNT_KEYS", "", "[Ljava/lang/String;", "ITEM_SLOT_KEYS", "ITEM_TYPE_TAG", "MAX_ITEM_TYPES", "", "STACK_AMOUNTS", "STACK_KEYS", "createInventory", "Lcom/the9grounds/aeadditions/me/storage/SuperCellInventory;", "itemStack", "Lnet/minecraft/world/item/ItemStack;", "container", "Lappeng/api/storage/cells/ISaveProvider;", "getStorageCell", "Lcom/the9grounds/aeadditions/item/storage/SuperStorageCell;", "itemKey", "Lappeng/api/stacks/AEItemKey;", "input", "isCell", "", "isCellEmpty", "cellInventory", "AEAdditions-1.20.1"})
    public static final class Companion {
        private Companion() {
        }

        private final SuperStorageCell getStorageCell(ItemStack input) {
            if (input != null && input.m_41720_() instanceof SuperStorageCell) {
                Item item2 = input.m_41720_();
                Intrinsics.checkNotNull((Object)item2, (String)"null cannot be cast to non-null type com.the9grounds.aeadditions.item.storage.SuperStorageCell");
                return (SuperStorageCell)item2;
            }
            return null;
        }

        private final SuperStorageCell getStorageCell(AEItemKey itemKey) {
            if (itemKey.getItem() instanceof SuperStorageCell) {
                Item item2 = itemKey.getItem();
                Intrinsics.checkNotNull((Object)item2, (String)"null cannot be cast to non-null type com.the9grounds.aeadditions.item.storage.SuperStorageCell");
                return (SuperStorageCell)item2;
            }
            return null;
        }

        private final boolean isCellEmpty(SuperCellInventory cellInventory) {
            if (cellInventory == null) {
                return true;
            }
            return cellInventory.getAvailableStacks().isEmpty();
        }

        public final boolean isCell(@Nullable ItemStack itemStack) {
            return this.getStorageCell(itemStack) != null;
        }

        @Nullable
        public final SuperCellInventory createInventory(@NotNull ItemStack itemStack, @Nullable ISaveProvider container) {
            Intrinsics.checkNotNullParameter((Object)itemStack, (String)"itemStack");
            Item item2 = itemStack.m_41720_();
            if (!(item2 instanceof SuperStorageCell)) {
                return null;
            }
            if (!((SuperStorageCell)item2).isStorageCell(itemStack)) {
                return null;
            }
            return new SuperCellInventory((SuperStorageCell)item2, itemStack, container);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

