/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.util;

import java.util.HashMap;
import java.util.Map;
import net.geforcemods.securitycraft.blockentities.AlarmBlockEntity;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.core.Holder;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.Level;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.event.PlayLevelSoundEvent;

public final class AlarmSoundHandler {
    private static final Map<AlarmBlockEntity, SoundInstance> SOUND_STORAGE = new HashMap<AlarmBlockEntity, SoundInstance>();

    private AlarmSoundHandler() {
    }

    public static void playSound(AlarmBlockEntity be, Level level, double x, double y, double z, Holder<SoundEvent> sound, SoundSource source, float volume, float pitch, long seed) {
        PlayLevelSoundEvent.AtPosition event = ForgeEventFactory.onPlaySoundAtPosition((Level)level, (double)x, (double)y, (double)z, sound, (SoundSource)source, (float)volume, (float)pitch);
        if (event.isCanceled() || event.getSound() == null) {
            return;
        }
        SimpleSoundInstance soundInstance = new SimpleSoundInstance((SoundEvent)event.getSound().m_203334_(), event.getSource(), event.getNewVolume(), event.getNewPitch(), RandomSource.m_216335_((long)seed), x, y, z);
        AlarmSoundHandler.stopCurrentSound(be);
        Minecraft.m_91087_().m_91106_().m_120367_((SoundInstance)soundInstance);
        SOUND_STORAGE.put(be, (SoundInstance)soundInstance);
    }

    public static void stopCurrentSound(AlarmBlockEntity be) {
        SoundInstance soundInstance = SOUND_STORAGE.remove(be);
        if (soundInstance != null) {
            Minecraft.m_91087_().m_91106_().m_120399_(soundInstance);
        }
    }
}

