/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.screen;

import com.mojang.blaze3d.platform.InputConstants;
import net.geforcemods.securitycraft.SCContent;
import net.geforcemods.securitycraft.SecurityCraft;
import net.geforcemods.securitycraft.api.IExplosive;
import net.geforcemods.securitycraft.network.server.RemoteControlMine;
import net.geforcemods.securitycraft.network.server.RemoveMineFromMRAT;
import net.geforcemods.securitycraft.screen.components.PictureButton;
import net.geforcemods.securitycraft.util.Utils;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;

public class MineRemoteAccessToolScreen
extends Screen {
    private static final ResourceLocation TEXTURE = new ResourceLocation("securitycraft:textures/gui/container/mrat.png");
    private static final ResourceLocation INFO_BOOK_ICONS = new ResourceLocation("securitycraft:textures/gui/info_book_icons.png");
    private static final int DEFUSE = 0;
    private static final int ACTIVATE = 1;
    private static final int DETONATE = 2;
    private static final int UNBIND = 3;
    private ItemStack mrat;
    private Button[][] guiButtons = new Button[6][4];
    private int xSize = 256;
    private int ySize = 184;
    private final Component notBound = Utils.localize("gui.securitycraft:mrat.notBound", new Object[0]);
    private final Component[] lines = new Component[6];
    private final int[] lengths = new int[6];

    public MineRemoteAccessToolScreen(ItemStack item) {
        super(item.m_41786_());
        this.mrat = item;
    }

    public void m_7856_() {
        super.m_7856_();
        int padding = 25;
        int y = 50;
        int[] coords = null;
        int id = 0;
        int startX = (this.f_96543_ - this.xSize) / 2;
        int startY = (this.f_96544_ - this.ySize) / 2;
        for (int i = 0; i < 6; ++i) {
            y += 25;
            coords = this.getMineCoordinates(i);
            for (int j = 0; j < 4; ++j) {
                int btnX = startX + j * padding + 154;
                int btnY = startY + y - 48;
                int mine = id / 4;
                int action = id % 4;
                ++id;
                switch (j) {
                    case 0: {
                        this.guiButtons[i][j] = new PictureButton(btnX, btnY, 20, 20, new ItemStack((ItemLike)SCContent.WIRE_CUTTERS.get()), b -> this.buttonClicked(mine, action));
                        break;
                    }
                    case 1: {
                        this.guiButtons[i][j] = new PictureButton(btnX, btnY, 20, 20, new ItemStack((ItemLike)Items.f_42409_), b -> this.buttonClicked(mine, action));
                        break;
                    }
                    case 2: {
                        this.guiButtons[i][j] = new PictureButton(btnX, btnY, 20, 20, INFO_BOOK_ICONS, 54, 1, 0, 1, 18, 18, 256, 256, b -> this.buttonClicked(mine, action));
                        break;
                    }
                    case 3: {
                        this.guiButtons[i][j] = new Button(btnX, btnY, 20, 20, (Component)Component.m_237113_((String)"X"), b -> this.buttonClicked(mine, action), Button.f_252438_);
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException("Mine actions can only range from 0-3 (inclusive)");
                    }
                }
                this.guiButtons[i][j].f_93623_ = false;
                this.m_142416_((GuiEventListener)this.guiButtons[i][j]);
            }
            if (coords.length == 3) {
                BlockPos minePos = new BlockPos(coords[0], coords[1], coords[2]);
                this.guiButtons[i][3].f_93623_ = true;
                this.lines[i] = Utils.localize("gui.securitycraft:mrat.mineLocations", minePos);
                if (Minecraft.m_91087_().f_91074_.m_9236_().m_46749_(minePos)) {
                    Block block = this.f_96541_.f_91073_.m_8055_(minePos).m_60734_();
                    if (block instanceof IExplosive) {
                        IExplosive explosive = (IExplosive)block;
                        boolean active = explosive.isActive((Level)this.f_96541_.f_91073_, minePos);
                        boolean defusable = explosive.isDefusable();
                        this.guiButtons[i][0].f_93623_ = active && defusable;
                        this.guiButtons[i][1].f_93623_ = !active && defusable;
                        this.guiButtons[i][2].f_93623_ = active;
                        this.guiButtons[i][0].m_257544_(Tooltip.m_257550_((Component)Utils.localize("gui.securitycraft:mrat.defuse", new Object[0])));
                        this.guiButtons[i][1].m_257544_(Tooltip.m_257550_((Component)Utils.localize("gui.securitycraft:mrat.activate", new Object[0])));
                        this.guiButtons[i][2].m_257544_(Tooltip.m_257550_((Component)Utils.localize("gui.securitycraft:mrat.detonate", new Object[0])));
                        this.guiButtons[i][3].m_257544_(Tooltip.m_257550_((Component)Utils.localize("gui.securitycraft:mrat.unbind", new Object[0])));
                    } else {
                        this.removeTagFromToolAndUpdate(this.mrat, coords[0], coords[1], coords[2]);
                        for (int j = 0; j < 4; ++j) {
                            this.guiButtons[i][j].f_93623_ = false;
                        }
                    }
                } else {
                    for (int j = 0; j < 3; ++j) {
                        this.guiButtons[i][j].m_257544_(Tooltip.m_257550_((Component)Utils.localize("gui.securitycraft:mrat.outOfRange", new Object[0])));
                    }
                    this.guiButtons[i][3].m_257544_(Tooltip.m_257550_((Component)Utils.localize("gui.securitycraft:mrat.unbind", new Object[0])));
                }
            } else {
                this.lines[i] = this.notBound;
            }
            this.lengths[i] = this.f_96547_.m_92852_((FormattedText)this.lines[i]);
        }
    }

    public void m_88315_(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        int startX = (this.f_96543_ - this.xSize) / 2;
        int startY = (this.f_96544_ - this.ySize) / 2;
        this.m_280273_(guiGraphics);
        guiGraphics.m_280218_(TEXTURE, startX, startY, 0, 0, this.xSize, this.ySize);
        super.m_88315_(guiGraphics, mouseX, mouseY, partialTicks);
        guiGraphics.m_280614_(this.f_96547_, this.f_96539_, startX + this.xSize / 2 - this.f_96547_.m_92852_((FormattedText)this.f_96539_) / 2, startY + 6, 0x404040, false);
        for (int i = 0; i < 6; ++i) {
            guiGraphics.m_280614_(this.f_96547_, this.lines[i], startX + this.xSize / 2 - this.lengths[i] + 25, startY + i * 25 + 33, 0x404040, false);
        }
    }

    private void buttonClicked(int mine, int action) {
        int[] coords = this.getMineCoordinates(mine);
        if (coords.length == 3) {
            switch (action) {
                case 0: {
                    ((IExplosive)Minecraft.m_91087_().f_91074_.m_9236_().m_8055_(new BlockPos(coords[0], coords[1], coords[2])).m_60734_()).defuseMine(Minecraft.m_91087_().f_91074_.m_9236_(), new BlockPos(coords[0], coords[1], coords[2]));
                    SecurityCraft.CHANNEL.sendToServer((Object)new RemoteControlMine(coords[0], coords[1], coords[2], RemoteControlMine.Action.DEFUSE));
                    this.guiButtons[mine][0].f_93623_ = false;
                    this.guiButtons[mine][1].f_93623_ = true;
                    this.guiButtons[mine][2].f_93623_ = false;
                    break;
                }
                case 1: {
                    ((IExplosive)Minecraft.m_91087_().f_91074_.m_9236_().m_8055_(new BlockPos(coords[0], coords[1], coords[2])).m_60734_()).activateMine(Minecraft.m_91087_().f_91074_.m_9236_(), new BlockPos(coords[0], coords[1], coords[2]));
                    SecurityCraft.CHANNEL.sendToServer((Object)new RemoteControlMine(coords[0], coords[1], coords[2], RemoteControlMine.Action.ACTIVATE));
                    this.guiButtons[mine][0].f_93623_ = true;
                    this.guiButtons[mine][1].f_93623_ = false;
                    this.guiButtons[mine][2].f_93623_ = true;
                    break;
                }
                case 2: {
                    SecurityCraft.CHANNEL.sendToServer((Object)new RemoteControlMine(coords[0], coords[1], coords[2], RemoteControlMine.Action.DETONATE));
                    this.removeTagFromToolAndUpdate(this.mrat, coords[0], coords[1], coords[2]);
                    for (int i = 0; i < 4; ++i) {
                        this.guiButtons[mine][i].f_93623_ = false;
                    }
                    break;
                }
                case 3: {
                    this.removeTagFromToolAndUpdate(this.mrat, coords[0], coords[1], coords[2]);
                    for (int i = 0; i < 4; ++i) {
                        this.guiButtons[mine][i].f_93623_ = false;
                    }
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Mine actions can only range from 0-3 (inclusive)");
                }
            }
        }
    }

    private int[] getMineCoordinates(int mine) {
        int[] coords;
        if (this.mrat.m_41720_() == SCContent.MINE_REMOTE_ACCESS_TOOL.get() && this.mrat.m_41782_() && (coords = this.mrat.m_41783_().m_128465_("mine" + ++mine)).length == 3) {
            return coords;
        }
        return new int[0];
    }

    private void removeTagFromToolAndUpdate(ItemStack stack, int x, int y, int z) {
        if (stack.m_41783_() == null) {
            return;
        }
        for (int i = 1; i <= 6; ++i) {
            int[] coords = stack.m_41783_().m_128465_("mine" + i);
            if (coords.length != 3 || coords[0] != x || coords[1] != y || coords[2] != z) continue;
            stack.m_41783_().m_128473_("mine" + i);
            SecurityCraft.CHANNEL.sendToServer((Object)new RemoveMineFromMRAT(i));
            return;
        }
    }

    public boolean m_7043_() {
        return false;
    }

    public boolean m_7933_(int keyCode, int scanCode, int modifiers) {
        if (this.f_96541_.f_91066_.f_92092_.isActiveAndMatches(InputConstants.m_84827_((int)keyCode, (int)scanCode))) {
            this.m_7379_();
            return true;
        }
        return super.m_7933_(keyCode, scanCode, modifiers);
    }
}

