/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.network.server;

import java.util.function.Supplier;
import net.geforcemods.securitycraft.blockentities.AlarmBlockEntity;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.network.NetworkEvent;

public class SyncAlarmSettings {
    private BlockPos pos;
    private ResourceLocation soundEvent;
    private float pitch;
    private int soundLength;

    public SyncAlarmSettings() {
    }

    public SyncAlarmSettings(BlockPos pos, ResourceLocation soundEvent, float pitch, int soundLength) {
        this.pos = pos;
        this.soundEvent = soundEvent;
        this.pitch = pitch;
        this.soundLength = soundLength;
    }

    public SyncAlarmSettings(FriendlyByteBuf buf) {
        this.pos = BlockPos.m_122022_((long)buf.readLong());
        this.soundEvent = buf.m_130281_();
        this.pitch = buf.readFloat();
        this.soundLength = buf.m_130242_();
    }

    public void encode(FriendlyByteBuf buf) {
        buf.writeLong(this.pos.m_121878_());
        buf.m_130085_(this.soundEvent);
        buf.writeFloat(this.pitch);
        buf.m_130130_(this.soundLength);
    }

    public void handle(Supplier<NetworkEvent.Context> ctx) {
        AlarmBlockEntity be;
        BlockEntity blockEntity = ctx.get().getSender().m_9236_().m_7702_(this.pos);
        if (blockEntity instanceof AlarmBlockEntity && (be = (AlarmBlockEntity)blockEntity).isOwnedBy((Player)ctx.get().getSender())) {
            if (!this.soundEvent.equals((Object)be.getSound().m_11660_())) {
                be.setSound(this.soundEvent);
            }
            if (this.pitch != be.getPitch()) {
                be.setPitch(this.pitch);
            }
            if (this.soundLength != be.getSoundLength()) {
                be.setSoundLength(this.soundLength);
            }
        }
    }
}

