/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.network.server;

import java.util.Arrays;
import java.util.function.Supplier;
import net.geforcemods.securitycraft.api.IPasscodeProtected;
import net.geforcemods.securitycraft.util.PasscodeUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.network.NetworkEvent;

public class CheckPasscode {
    private String passcode;
    private int x;
    private int y;
    private int z;

    public CheckPasscode() {
    }

    public CheckPasscode(int x, int y, int z, String passcode) {
        this.x = x;
        this.y = y;
        this.z = z;
        this.passcode = PasscodeUtils.hashPasscodeWithoutSalt(passcode);
    }

    public CheckPasscode(FriendlyByteBuf buf) {
        this.x = buf.readInt();
        this.y = buf.readInt();
        this.z = buf.readInt();
        this.passcode = buf.m_130136_(0x1FFFFFFF);
    }

    public void encode(FriendlyByteBuf buf) {
        buf.writeInt(this.x);
        buf.writeInt(this.y);
        buf.writeInt(this.z);
        buf.m_130070_(this.passcode);
    }

    public void handle(Supplier<NetworkEvent.Context> ctx) {
        BlockPos pos = new BlockPos(this.x, this.y, this.z);
        ServerPlayer player = ctx.get().getSender();
        BlockEntity blockEntity = player.m_9236_().m_7702_(pos);
        if (blockEntity instanceof IPasscodeProtected) {
            IPasscodeProtected be = (IPasscodeProtected)blockEntity;
            if (be.isOnCooldown()) {
                return;
            }
            PasscodeUtils.hashPasscode(this.passcode, be.getSalt(), p -> {
                if (Arrays.equals(be.getPasscode(), p)) {
                    player.m_6915_();
                    be.activate((Player)player);
                } else {
                    be.onIncorrectPasscodeEntered((Player)player, this.passcode);
                }
            });
        }
    }
}

