/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.network.client;

import java.util.function.Supplier;
import net.geforcemods.securitycraft.ClientHandler;
import net.geforcemods.securitycraft.blockentities.AlarmBlockEntity;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.network.NetworkEvent;

public class PlayAlarmSound {
    private BlockPos bePos;
    private Holder<SoundEvent> sound;
    private int soundX;
    private int soundY;
    private int soundZ;
    private float volume;
    private float pitch;
    private long seed;

    public PlayAlarmSound() {
    }

    public PlayAlarmSound(BlockPos bePos, Holder<SoundEvent> sound, float volume, float pitch, long seed) {
        this.bePos = bePos;
        this.sound = sound;
        this.soundX = (int)((float)bePos.m_123341_() * 8.0f);
        this.soundY = (int)((float)bePos.m_123342_() * 8.0f);
        this.soundZ = (int)((float)bePos.m_123343_() * 8.0f);
        this.volume = volume;
        this.pitch = pitch;
        this.seed = seed;
    }

    public PlayAlarmSound(FriendlyByteBuf buf) {
        this.bePos = buf.m_130135_();
        this.sound = buf.m_263187_(BuiltInRegistries.f_256894_.m_206115_(), SoundEvent::m_263214_);
        this.soundX = buf.readInt();
        this.soundY = buf.readInt();
        this.soundZ = buf.readInt();
        this.volume = buf.readFloat();
        this.pitch = buf.readFloat();
        this.seed = buf.readLong();
    }

    public void encode(FriendlyByteBuf buf) {
        buf.m_130064_(this.bePos);
        buf.m_263218_(BuiltInRegistries.f_256894_.m_206115_(), this.sound, (buffer, soundEvent) -> soundEvent.m_263231_(buffer));
        buf.writeInt(this.soundX);
        buf.writeInt(this.soundY);
        buf.writeInt(this.soundZ);
        buf.writeFloat(this.volume);
        buf.writeFloat(this.pitch);
        buf.writeLong(this.seed);
    }

    public double getX() {
        return (float)this.soundX / 8.0f;
    }

    public double getY() {
        return (float)this.soundY / 8.0f;
    }

    public double getZ() {
        return (float)this.soundZ / 8.0f;
    }

    public void handle(Supplier<NetworkEvent.Context> ctx) {
        Level level = ClientHandler.getClientLevel();
        BlockEntity blockEntity = level.m_7702_(this.bePos);
        if (blockEntity instanceof AlarmBlockEntity) {
            AlarmBlockEntity be = (AlarmBlockEntity)blockEntity;
            be.playSound(level, this.getX(), this.getY(), this.getZ(), this.sound, this.volume, this.pitch, this.seed);
        }
    }
}

