/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.mixin.camera;

import java.util.function.Consumer;
import net.geforcemods.securitycraft.entity.camera.CameraController;
import net.geforcemods.securitycraft.misc.IChunkStorageProvider;
import net.geforcemods.securitycraft.util.PlayerUtils;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientChunkCache;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.protocol.game.ClientboundLevelChunkPacketData;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.ChunkStatus;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.level.ChunkEvent;
import net.minecraftforge.eventbus.api.Event;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={ClientChunkCache.class}, priority=1100)
public abstract class ClientChunkCacheMixin
implements IChunkStorageProvider {
    @Shadow
    volatile ClientChunkCache.Storage f_104410_;
    @Shadow
    @Final
    ClientLevel f_104411_;

    @Shadow
    private static boolean m_104438_(LevelChunk chunk, int x, int z) {
        throw new IllegalStateException("Shadowing isValidChunk did not work!");
    }

    @Inject(method={"<init>"}, at={@At(value="TAIL")})
    public void securitycraft$onInit(ClientLevel level, int viewDistance, CallbackInfo ci) {
        CameraController.setCameraStorage(this.newStorage(Math.max(2, viewDistance) + 3));
    }

    @Inject(method={"updateViewRadius"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/multiplayer/ClientChunkCache$Storage;<init>(Lnet/minecraft/client/multiplayer/ClientChunkCache;I)V")})
    public void securitycraft$onUpdateViewRadius(int viewDistance, CallbackInfo ci) {
        ClientChunkCache.Storage oldStorage = CameraController.getCameraStorage();
        ClientChunkCache.Storage newStorage = this.newStorage(Math.max(2, viewDistance) + 3);
        newStorage.f_104469_ = oldStorage.f_104469_;
        newStorage.f_104470_ = oldStorage.f_104470_;
        for (int i = 0; i < oldStorage.f_104466_.length(); ++i) {
            LevelChunk chunk = (LevelChunk)oldStorage.f_104466_.get(i);
            if (chunk == null) continue;
            ChunkPos pos = chunk.m_7697_();
            if (!newStorage.m_104500_(pos.f_45578_, pos.f_45579_)) continue;
            newStorage.m_104484_(newStorage.m_104481_(pos.f_45578_, pos.f_45579_), chunk);
        }
        CameraController.setCameraStorage(newStorage);
    }

    @Inject(method={"drop"}, at={@At(value="HEAD")})
    public void securitycraft$onDrop(int x, int z, CallbackInfo ci) {
        int i;
        LevelChunk chunk;
        ClientChunkCache.Storage cameraStorage = CameraController.getCameraStorage();
        if (cameraStorage.m_104500_(x, z) && (chunk = cameraStorage.m_104479_(i = cameraStorage.m_104481_(x, z))) != null && chunk.m_7697_().f_45578_ == x && chunk.m_7697_().f_45579_ == z) {
            MinecraftForge.EVENT_BUS.post((Event)new ChunkEvent.Unload((ChunkAccess)chunk));
            cameraStorage.m_104487_(i, chunk, null);
        }
    }

    @Inject(method={"replaceWithPacketData"}, at={@At(value="HEAD")}, cancellable=true)
    private void securitycraft$onReplace(int x, int z, FriendlyByteBuf buffer, CompoundTag chunkTag, Consumer<ClientboundLevelChunkPacketData.BlockEntityTagOutput> tagOutputConsumer, CallbackInfoReturnable<LevelChunk> callback) {
        ClientChunkCache.Storage cameraStorage = CameraController.getCameraStorage();
        if (PlayerUtils.isPlayerMountedOnCamera((LivingEntity)Minecraft.m_91087_().f_91074_) && cameraStorage.m_104500_(x, z)) {
            int index = cameraStorage.m_104481_(x, z);
            LevelChunk chunk = cameraStorage.m_104479_(index);
            ChunkPos chunkPos = new ChunkPos(x, z);
            if (!ClientChunkCacheMixin.m_104438_(chunk, x, z)) {
                chunk = new LevelChunk((Level)this.f_104411_, chunkPos);
                chunk.m_187971_(buffer, chunkTag, tagOutputConsumer);
                cameraStorage.m_104484_(index, chunk);
            } else {
                chunk.m_187971_(buffer, chunkTag, tagOutputConsumer);
            }
            this.f_104411_.m_171649_(chunkPos);
            MinecraftForge.EVENT_BUS.post((Event)new ChunkEvent.Load((ChunkAccess)chunk, false));
            callback.setReturnValue((Object)chunk);
        }
    }

    @Inject(method={"getChunk(IILnet/minecraft/world/level/chunk/ChunkStatus;Z)Lnet/minecraft/world/level/chunk/LevelChunk;"}, at={@At(value="TAIL")}, cancellable=true)
    private void securitycraft$onGetChunk(int x, int z, ChunkStatus requiredStatus, boolean load, CallbackInfoReturnable<LevelChunk> callback) {
        LevelChunk chunk;
        if (PlayerUtils.isPlayerMountedOnCamera((LivingEntity)Minecraft.m_91087_().f_91074_) && CameraController.getCameraStorage().m_104500_(x, z) && (chunk = CameraController.getCameraStorage().m_104479_(CameraController.getCameraStorage().m_104481_(x, z))) != null && chunk.m_7697_().f_45578_ == x && chunk.m_7697_().f_45579_ == z) {
            callback.setReturnValue((Object)chunk);
        }
    }
}

