/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.items;

import net.geforcemods.securitycraft.ConfigHandler;
import net.geforcemods.securitycraft.SCContent;
import net.geforcemods.securitycraft.SecurityCraft;
import net.geforcemods.securitycraft.inventory.BriefcaseMenu;
import net.geforcemods.securitycraft.inventory.ItemContainer;
import net.geforcemods.securitycraft.items.BriefcaseItem;
import net.geforcemods.securitycraft.util.PlayerUtils;
import net.geforcemods.securitycraft.util.Utils;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.level.Level;
import net.minecraftforge.network.NetworkHooks;

public class CodebreakerItem
extends Item {
    public static final ResourceLocation STATE_PROPERTY = new ResourceLocation("securitycraft", "codebreaker_state");
    public static final String WORKING = "working";
    public static final String LAST_USED_TIME = "last_used_time";
    public static final String WAS_SUCCESSFUL = "was_successful";

    public CodebreakerItem(Item.Properties properties) {
        super(properties);
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, InteractionHand hand) {
        ItemStack briefcase;
        ItemStack codebreaker = player.m_21120_(hand);
        if (hand == InteractionHand.MAIN_HAND && (briefcase = player.m_21206_()).m_150930_((Item)SCContent.BRIEFCASE.get())) {
            if (BriefcaseItem.isOwnedBy(briefcase, player)) {
                PlayerUtils.sendMessageToPlayer(player, Utils.localize(((Item)SCContent.CODEBREAKER.get()).m_5524_(), new Object[0]), Utils.localize("messages.securitycraft:codebreaker.owned", new Object[0]), ChatFormatting.RED);
            } else {
                double chance = (Double)ConfigHandler.SERVER.codebreakerChance.get();
                if (chance < 0.0) {
                    PlayerUtils.sendMessageToPlayer(player, Utils.localize(((Item)SCContent.CODEBREAKER.get()).m_5524_(), new Object[0]), Utils.localize("messages.securitycraft:codebreakerDisabled", new Object[0]), ChatFormatting.RED);
                } else {
                    codebreaker.m_41622_(1, (LivingEntity)player, p -> p.m_21190_(hand));
                    if (!level.f_46443_) {
                        if (CodebreakerItem.wasRecentlyUsed(codebreaker)) {
                            return InteractionResultHolder.m_19098_((Object)codebreaker);
                        }
                        boolean isSuccessful = player.m_7500_() || SecurityCraft.RANDOM.nextDouble() < chance;
                        CompoundTag tag = codebreaker.m_41784_();
                        tag.m_128356_(LAST_USED_TIME, System.currentTimeMillis());
                        tag.m_128379_(WAS_SUCCESSFUL, isSuccessful);
                        if (isSuccessful) {
                            NetworkHooks.openScreen((ServerPlayer)((ServerPlayer)player), (MenuProvider)new MenuProvider(){

                                public AbstractContainerMenu m_7208_(int windowId, Inventory inv, Player player) {
                                    return new BriefcaseMenu(windowId, inv, ItemContainer.briefcase(briefcase));
                                }

                                public Component m_5446_() {
                                    return briefcase.m_41786_();
                                }
                            }, (BlockPos)player.m_20183_());
                        } else {
                            PlayerUtils.sendMessageToPlayer(player, Component.m_237115_((String)((Item)SCContent.CODEBREAKER.get()).m_5524_()), Utils.localize("messages.securitycraft:codebreaker.failed", new Object[0]), ChatFormatting.RED);
                        }
                    }
                }
            }
            return InteractionResultHolder.m_19090_((Object)codebreaker);
        }
        return InteractionResultHolder.m_19098_((Object)codebreaker);
    }

    public static boolean wasRecentlyUsed(ItemStack stack) {
        long lastUsedTime = stack.m_41784_().m_128454_(LAST_USED_TIME);
        return lastUsedTime != 0L && System.currentTimeMillis() - lastUsedTime < 3000L;
    }

    public boolean m_5812_(ItemStack stack) {
        return true;
    }

    public Rarity m_41460_(ItemStack stack) {
        return Rarity.RARE;
    }

    public boolean canApplyAtEnchantingTable(ItemStack stack, Enchantment enchantment) {
        return false;
    }

    public boolean isBookEnchantable(ItemStack stack, ItemStack book) {
        return false;
    }

    public boolean m_8120_(ItemStack stack) {
        return false;
    }
}

