/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.items;

import java.util.Arrays;
import java.util.List;
import java.util.UUID;
import java.util.function.Consumer;
import net.geforcemods.securitycraft.SCContent;
import net.geforcemods.securitycraft.SecurityCraft;
import net.geforcemods.securitycraft.inventory.BriefcaseMenu;
import net.geforcemods.securitycraft.inventory.ItemContainer;
import net.geforcemods.securitycraft.misc.SaltData;
import net.geforcemods.securitycraft.network.client.OpenScreen;
import net.geforcemods.securitycraft.util.PasscodeUtils;
import net.geforcemods.securitycraft.util.PlayerUtils;
import net.geforcemods.securitycraft.util.Utils;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.DyeableLeatherItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.Level;
import net.minecraftforge.network.NetworkHooks;
import net.minecraftforge.network.PacketDistributor;

public class BriefcaseItem
extends Item
implements DyeableLeatherItem {
    public BriefcaseItem(Item.Properties properties) {
        super(properties);
    }

    public InteractionResult m_6225_(UseOnContext ctx) {
        this.handle(ctx.m_43722_(), ctx.m_43725_(), ctx.m_43723_());
        return InteractionResult.CONSUME;
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, InteractionHand hand) {
        ItemStack stack = player.m_21120_(hand);
        this.handle(stack, level, player);
        return InteractionResultHolder.m_19096_((Object)stack);
    }

    public boolean canApplyAtEnchantingTable(ItemStack stack, Enchantment enchantment) {
        return enchantment == Enchantments.f_44963_;
    }

    private void handle(ItemStack stack, Level level, Player player) {
        if (!level.f_46443_) {
            SecurityCraft.CHANNEL.send(PacketDistributor.PLAYER.with(() -> (ServerPlayer)player), (Object)new OpenScreen(stack.m_41784_().m_128441_("passcode") ? OpenScreen.DataType.CHECK_BRIEFCASE_PASSCODE : OpenScreen.DataType.SET_BRIEFCASE_PASSCODE));
        }
    }

    public void m_7373_(ItemStack briefcase, Level level, List<Component> tooltip, TooltipFlag flag) {
        String ownerName = BriefcaseItem.getOwnerName(briefcase);
        if (!ownerName.isEmpty()) {
            tooltip.add((Component)Utils.localize("tooltip.securitycraft:briefcase.owner", ownerName).m_6270_(Utils.GRAY_STYLE));
        }
    }

    public CompoundTag getShareTag(ItemStack stack) {
        CompoundTag tag = super.getShareTag(stack);
        return tag == null ? null : PasscodeUtils.filterPasscodeAndSaltFromTag(tag.m_6426_());
    }

    public static void hashAndSetPasscode(CompoundTag briefcaseTag, String passcode, Consumer<byte[]> afterSet) {
        byte[] salt = PasscodeUtils.generateSalt();
        briefcaseTag.m_128362_("saltKey", SaltData.putSalt(salt));
        PasscodeUtils.hashPasscode(passcode, salt, p -> {
            briefcaseTag.m_128359_("passcode", PasscodeUtils.bytesToString(p));
            afterSet.accept((byte[])p);
        });
    }

    public static void checkPasscode(ServerPlayer player, final ItemStack briefcase, String incomingCode, String briefcaseCode, CompoundTag tag) {
        UUID saltKey = tag.m_128425_("saltKey", 11) ? tag.m_128342_("saltKey") : null;
        byte[] salt = SaltData.getSalt(saltKey);
        if (salt == null) {
            PasscodeUtils.filterPasscodeAndSaltFromTag(tag);
            return;
        }
        PasscodeUtils.hashPasscode(incomingCode, salt, p -> {
            if (Arrays.equals(PasscodeUtils.stringToBytes(briefcaseCode), p)) {
                if (!tag.m_128441_("owner")) {
                    tag.m_128359_("owner", player.m_7755_().getString());
                    tag.m_128359_("ownerUUID", player.m_20148_().toString());
                }
                NetworkHooks.openScreen((ServerPlayer)player, (MenuProvider)new MenuProvider(){

                    public AbstractContainerMenu m_7208_(int windowId, Inventory inv, Player player) {
                        return new BriefcaseMenu(windowId, inv, ItemContainer.briefcase(PlayerUtils.getItemStackFromAnyHand(player, (Item)SCContent.BRIEFCASE.get())));
                    }

                    public Component m_5446_() {
                        return briefcase.m_41786_();
                    }
                }, (BlockPos)player.m_20183_());
            }
        });
    }

    public static boolean isOwnedBy(ItemStack briefcase, Player player) {
        if (!briefcase.m_41782_()) {
            return true;
        }
        String ownerName = BriefcaseItem.getOwnerName(briefcase);
        String ownerUUID = BriefcaseItem.getOwnerUUID(briefcase);
        return ownerName.isEmpty() || ownerUUID.equals(player.m_20148_().toString()) || ownerUUID.equals("ownerUUID") && ownerName.equals(player.m_7755_().getString());
    }

    public static String getOwnerName(ItemStack briefcase) {
        return briefcase.m_41782_() ? briefcase.m_41783_().m_128461_("owner") : "";
    }

    public static String getOwnerUUID(ItemStack briefcase) {
        return briefcase.m_41782_() ? briefcase.m_41783_().m_128461_("ownerUUID") : "";
    }
}

