/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.fluids;

import javax.annotation.Nullable;
import net.geforcemods.securitycraft.SCContent;
import net.geforcemods.securitycraft.SecurityCraft;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.fluids.ForgeFlowingFluid;

public abstract class FakeLavaFluid
extends ForgeFlowingFluid {
    protected FakeLavaFluid(ForgeFlowingFluid.Properties properties) {
        super(properties);
    }

    public Fluid m_5615_() {
        return (Fluid)SCContent.FLOWING_FAKE_LAVA.get();
    }

    public Fluid m_5613_() {
        return (Fluid)SCContent.FAKE_LAVA.get();
    }

    public Item m_6859_() {
        return (Item)SCContent.FAKE_LAVA_BUCKET.get();
    }

    public void m_213811_(Level level, BlockPos pos, FluidState state, RandomSource random) {
        BlockPos posAbove = pos.m_7494_();
        if (level.m_8055_(posAbove).m_60795_() && !level.m_8055_(posAbove).m_60804_((BlockGetter)level, posAbove)) {
            if (random.m_188503_(100) == 0) {
                double x = (float)pos.m_123341_() + random.m_188501_();
                double y = pos.m_123342_() + 1;
                double z = (float)pos.m_123343_() + random.m_188501_();
                level.m_7106_((ParticleOptions)ParticleTypes.f_123756_, x, y, z, 0.0, 0.0, 0.0);
                level.m_7785_(x, y, z, SoundEvents.f_12032_, SoundSource.BLOCKS, 0.2f + random.m_188501_() * 0.2f, 0.9f + random.m_188501_() * 0.15f, false);
            }
            if (random.m_188503_(200) == 0) {
                level.m_7785_((double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), SoundEvents.f_12030_, SoundSource.BLOCKS, 0.2f + random.m_188501_() * 0.2f, 0.9f + random.m_188501_() * 0.15f, false);
            }
        }
    }

    public void m_213812_(Level level, BlockPos pos, FluidState state, RandomSource random) {
        block7: {
            if (!level.m_46469_().m_46207_(GameRules.f_46131_)) break block7;
            int i = random.m_188503_(3);
            if (i > 0) {
                BlockPos posToUpdate = pos;
                for (int j = 0; j < i; ++j) {
                    if (!level.m_46749_(posToUpdate = posToUpdate.m_7918_(random.m_188503_(3) - 1, 1, random.m_188503_(3) - 1))) {
                        return;
                    }
                    BlockState stateToUpdate = level.m_8055_(posToUpdate);
                    if (stateToUpdate.m_60795_()) {
                        if (!this.isSurroundingBlockFlammable(level, posToUpdate)) continue;
                        level.m_46597_(posToUpdate, ForgeEventFactory.fireFluidPlaceBlockEvent((LevelAccessor)level, (BlockPos)posToUpdate, (BlockPos)pos, (BlockState)Blocks.f_50083_.m_49966_()));
                        return;
                    }
                    if (!stateToUpdate.m_280555_()) continue;
                    return;
                }
            } else {
                for (int k = 0; k < 3; ++k) {
                    BlockPos posToUpdate = pos.m_7918_(random.m_188503_(3) - 1, 0, random.m_188503_(3) - 1);
                    if (!level.m_46749_(posToUpdate)) {
                        return;
                    }
                    BlockPos posAbove = posToUpdate.m_7494_();
                    if (!level.m_46859_(posAbove) || !this.isFlammable((LevelReader)level, posToUpdate, Direction.UP)) continue;
                    level.m_46597_(posAbove, ForgeEventFactory.fireFluidPlaceBlockEvent((LevelAccessor)level, (BlockPos)posAbove, (BlockPos)pos, (BlockState)Blocks.f_50083_.m_49966_()));
                }
            }
        }
    }

    private boolean isSurroundingBlockFlammable(Level level, BlockPos pos) {
        for (Direction direction : Direction.values()) {
            if (!this.isFlammable((LevelReader)level, pos.m_121945_(direction), direction.m_122424_())) continue;
            return true;
        }
        return false;
    }

    private boolean isFlammable(LevelReader level, BlockPos pos, Direction face) {
        return pos.m_123342_() < level.m_141937_() || pos.m_123342_() >= level.m_151558_() || level.m_46805_(pos) || level.m_8055_(pos).isFlammable((BlockGetter)level, pos, face);
    }

    @Nullable
    public ParticleOptions m_7792_() {
        return ParticleTypes.f_123800_;
    }

    protected boolean m_6760_(Level level) {
        return level.m_46469_().m_46207_(SecurityCraft.RULE_FAKE_LAVA_SOURCE_CONVERSION);
    }

    public boolean canConvertToSource(FluidState state, Level level, BlockPos pos) {
        return this.m_6760_(level);
    }

    protected void m_7456_(LevelAccessor level, BlockPos pos, BlockState state) {
        this.triggerEffects(level, pos);
    }

    public int m_6719_(LevelReader level) {
        return level.m_6042_().f_63857_() ? 4 : 2;
    }

    public BlockState m_5804_(FluidState state) {
        return (BlockState)((LiquidBlock)SCContent.FAKE_LAVA_BLOCK.get()).m_49966_().m_61124_((Property)LiquidBlock.f_54688_, (Comparable)Integer.valueOf(FakeLavaFluid.m_76092_((FluidState)state)));
    }

    public boolean m_6212_(Fluid fluid) {
        return fluid == SCContent.FAKE_LAVA.get() || fluid == SCContent.FLOWING_FAKE_LAVA.get();
    }

    public int m_6713_(LevelReader level) {
        return level.m_6042_().f_63857_() ? 1 : 2;
    }

    public boolean m_5486_(FluidState fluidState, BlockGetter level, BlockPos pos, Fluid fluid, Direction dir) {
        return fluidState.m_76155_(level, pos) >= 0.44444445f && fluid.m_205067_(FluidTags.f_13131_);
    }

    public int m_6718_(LevelReader level) {
        return level.m_6042_().f_63857_() ? 10 : 30;
    }

    public int m_6886_(Level level, BlockPos pos, FluidState fluidState1, FluidState fluidState2) {
        int tickDelay = this.m_6718_((LevelReader)level);
        if (!(fluidState1.m_76178_() || fluidState2.m_76178_() || ((Boolean)fluidState1.m_61143_((Property)f_75947_)).booleanValue() || ((Boolean)fluidState2.m_61143_((Property)f_75947_)).booleanValue() || !(fluidState2.m_76155_((BlockGetter)level, pos) > fluidState1.m_76155_((BlockGetter)level, pos)) || level.m_213780_().m_188503_(4) == 0)) {
            tickDelay *= 4;
        }
        return tickDelay;
    }

    protected void triggerEffects(LevelAccessor level, BlockPos pos) {
        level.m_46796_(1501, pos, 0);
    }

    protected void m_6364_(LevelAccessor level, BlockPos pos, BlockState state, Direction direction, FluidState fluidState) {
        if (direction == Direction.DOWN && this.m_205067_(FluidTags.f_13132_) && fluidState.m_205070_(FluidTags.f_13131_)) {
            if (state.m_60734_() instanceof LiquidBlock) {
                level.m_7731_(pos, ForgeEventFactory.fireFluidPlaceBlockEvent((LevelAccessor)level, (BlockPos)pos, (BlockPos)pos, (BlockState)Blocks.f_50069_.m_49966_()), 3);
            }
            this.triggerEffects(level, pos);
            return;
        }
        super.m_6364_(level, pos, state, direction, fluidState);
    }

    protected boolean m_6685_() {
        return true;
    }

    protected float m_6752_() {
        return 100.0f;
    }

    public static class Source
    extends FakeLavaFluid {
        public Source(ForgeFlowingFluid.Properties properties) {
            super(properties);
        }

        public int m_7430_(FluidState state) {
            return 8;
        }

        public boolean m_7444_(FluidState state) {
            return true;
        }
    }

    public static class Flowing
    extends FakeLavaFluid {
        public Flowing(ForgeFlowingFluid.Properties properties) {
            super(properties);
        }

        protected void m_7180_(StateDefinition.Builder<Fluid, FluidState> builder) {
            super.m_7180_(builder);
            builder.m_61104_(new Property[]{f_75948_});
        }

        public int m_7430_(FluidState state) {
            return (Integer)state.m_61143_((Property)f_75948_);
        }

        public boolean m_7444_(FluidState state) {
            return false;
        }
    }
}

