/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.compat.waila;

import java.util.Optional;
import net.geforcemods.securitycraft.ClientHandler;
import net.geforcemods.securitycraft.api.IModuleInventory;
import net.geforcemods.securitycraft.api.IOwnable;
import net.geforcemods.securitycraft.blocks.DisguisableBlock;
import net.geforcemods.securitycraft.blocks.FakeLavaBlock;
import net.geforcemods.securitycraft.blocks.FakeWaterBlock;
import net.geforcemods.securitycraft.compat.IOverlayDisplay;
import net.geforcemods.securitycraft.compat.waila.WailaCompatConstants;
import net.geforcemods.securitycraft.entity.sentry.Sentry;
import net.geforcemods.securitycraft.misc.ModuleType;
import net.geforcemods.securitycraft.util.PlayerUtils;
import net.geforcemods.securitycraft.util.Utils;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import snownee.jade.api.BlockAccessor;
import snownee.jade.api.EntityAccessor;
import snownee.jade.api.IBlockComponentProvider;
import snownee.jade.api.IEntityComponentProvider;
import snownee.jade.api.ITooltip;
import snownee.jade.api.IWailaClientRegistration;
import snownee.jade.api.IWailaPlugin;
import snownee.jade.api.WailaPlugin;
import snownee.jade.api.config.IPluginConfig;
import snownee.jade.api.ui.IElement;
import snownee.jade.impl.Tooltip;
import snownee.jade.impl.ui.TextElement;

@WailaPlugin(value="securitycraft")
public final class JadeDataProvider
extends WailaCompatConstants
implements IWailaPlugin {
    public static final SecurityCraftInfo SECURITYCRAFT_INFO = new SecurityCraftInfo();

    public void registerClient(IWailaClientRegistration registration) {
        registration.addConfig(SHOW_OWNER, true);
        registration.addConfig(SHOW_MODULES, true);
        registration.addConfig(SHOW_CUSTOM_NAME, true);
        registration.registerBlockComponent((IBlockComponentProvider)SECURITYCRAFT_INFO, Block.class);
        registration.registerEntityComponent((IEntityComponentProvider)SECURITYCRAFT_INFO, Sentry.class);
        registration.addBeforeRenderCallback((tooltip, rect, guiGraphics, accessor, color) -> ClientHandler.isPlayerMountedOnCamera());
        registration.addRayTraceCallback((hit, accessor, original) -> {
            if (accessor instanceof BlockAccessor) {
                BlockAccessor blockAccessor = (BlockAccessor)accessor;
                Block block = blockAccessor.getBlock();
                if (block instanceof IOverlayDisplay) {
                    BlockPos pos;
                    BlockState state;
                    IOverlayDisplay overlayDisplay = (IOverlayDisplay)block;
                    Level level = blockAccessor.getLevel();
                    if (!overlayDisplay.shouldShowSCInfo(level, state = blockAccessor.getBlockState(), pos = blockAccessor.getPosition())) {
                        return registration.blockAccessor().from(blockAccessor).fakeBlock(overlayDisplay.getDisplayStack(level, state, pos)).build();
                    }
                } else {
                    if (block instanceof FakeWaterBlock) {
                        return registration.blockAccessor().from(blockAccessor).blockState(Blocks.f_49990_.m_49966_()).build();
                    }
                    if (block instanceof FakeLavaBlock) {
                        return registration.blockAccessor().from(blockAccessor).blockState(Blocks.f_49991_.m_49966_()).build();
                    }
                }
            }
            return accessor;
        });
    }

    private static class SecurityCraftInfo
    implements IBlockComponentProvider,
    IEntityComponentProvider {
        private SecurityCraftInfo() {
        }

        public void appendTooltip(ITooltip tooltip, BlockAccessor data, IPluginConfig config) {
            IOverlayDisplay display;
            Optional<BlockState> disguisedBlockState;
            Block block = data.getBlock();
            boolean disguised = false;
            if (block instanceof DisguisableBlock && (disguisedBlockState = DisguisableBlock.getDisguisedBlockState((LevelReader)data.getLevel(), data.getPosition())).isPresent()) {
                disguised = true;
                block = disguisedBlockState.get().m_60734_();
            }
            if (block instanceof IOverlayDisplay && !(display = (IOverlayDisplay)block).shouldShowSCInfo(data.getLevel(), data.getBlockState(), data.getPosition())) {
                return;
            }
            BlockEntity be = data.getBlockEntity();
            if (be != null) {
                if (tooltip instanceof Tooltip) {
                    Tooltip t = (Tooltip)tooltip;
                    Block block2 = data.getBlock();
                    if (block2 instanceof IOverlayDisplay) {
                        IOverlayDisplay overlayDisplay = (IOverlayDisplay)block2;
                        ((Tooltip.Line)t.lines.get(0)).getAlignedElements(IElement.Align.LEFT).set(0, new TextElement((Component)Component.m_237115_((String)overlayDisplay.getDisplayStack(data.getLevel(), data.getBlockState(), data.getPosition()).m_41778_()).m_6270_(WailaCompatConstants.ITEM_NAME_STYLE)));
                    }
                }
                if (config.get(WailaCompatConstants.SHOW_OWNER) && be instanceof IOwnable) {
                    IOwnable ownable = (IOwnable)be;
                    if (Utils.getRegistryName(block).m_135827_().equals("securitycraft")) {
                        tooltip.add((Component)Utils.localize("waila.securitycraft:owner", PlayerUtils.getOwnerComponent(ownable.getOwner())));
                    }
                }
                if (disguised) {
                    return;
                }
                if (config.get(WailaCompatConstants.SHOW_MODULES) && be instanceof IModuleInventory) {
                    IOwnable ownable;
                    IModuleInventory inv = (IModuleInventory)be;
                    if (!(be instanceof IOwnable) || (ownable = (IOwnable)be).isOwnedBy(data.getPlayer())) {
                        if (!inv.getInsertedModules().isEmpty()) {
                            tooltip.add((Component)WailaCompatConstants.EQUIPPED);
                        }
                        for (ModuleType module : inv.getInsertedModules()) {
                            tooltip.add((Component)Component.m_237113_((String)"- ").m_7220_((Component)Component.m_237115_((String)module.getTranslationKey())));
                        }
                    }
                }
            }
        }

        public void appendTooltip(ITooltip tooltip, EntityAccessor data, IPluginConfig config) {
            Entity entity = data.getEntity();
            if (entity instanceof Sentry) {
                Sentry sentry = (Sentry)entity;
                Sentry.SentryMode mode = sentry.getMode();
                if (config.get(WailaCompatConstants.SHOW_OWNER)) {
                    tooltip.add((Component)Utils.localize("waila.securitycraft:owner", PlayerUtils.getOwnerComponent(sentry.getOwner())));
                }
                if (config.get(WailaCompatConstants.SHOW_MODULES) && sentry.isOwnedBy(data.getPlayer()) && (!sentry.getAllowlistModule().m_41619_() || !sentry.getDisguiseModule().m_41619_() || sentry.hasSpeedModule())) {
                    tooltip.add((Component)WailaCompatConstants.EQUIPPED);
                    if (!sentry.getAllowlistModule().m_41619_()) {
                        tooltip.add((Component)WailaCompatConstants.ALLOWLIST_MODULE);
                    }
                    if (!sentry.getDisguiseModule().m_41619_()) {
                        tooltip.add((Component)WailaCompatConstants.DISGUISE_MODULE);
                    }
                    if (sentry.hasSpeedModule()) {
                        tooltip.add((Component)WailaCompatConstants.SPEED_MODULE);
                    }
                }
                MutableComponent modeDescription = Utils.localize(mode.getModeKey(), new Object[0]);
                if (mode != Sentry.SentryMode.IDLE) {
                    modeDescription.m_130946_("- ").m_7220_((Component)Utils.localize(mode.getTargetKey(), new Object[0]));
                }
                tooltip.add((Component)modeDescription);
            }
        }

        public ResourceLocation getUid() {
            return new ResourceLocation("securitycraft", "info");
        }
    }
}

