/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.blocks;

import net.geforcemods.securitycraft.SCContent;
import net.geforcemods.securitycraft.api.IOwnable;
import net.geforcemods.securitycraft.api.IPasscodeConvertible;
import net.geforcemods.securitycraft.api.IPasscodeProtected;
import net.geforcemods.securitycraft.blockentities.KeypadTrapdoorBlockEntity;
import net.geforcemods.securitycraft.blocks.reinforced.BaseIronTrapDoorBlock;
import net.geforcemods.securitycraft.misc.SaltData;
import net.geforcemods.securitycraft.util.PlayerUtils;
import net.geforcemods.securitycraft.util.Utils;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.TrapDoorBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockSetType;
import net.minecraft.world.level.block.state.properties.Half;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;

public class KeypadTrapDoorBlock
extends BaseIronTrapDoorBlock {
    public KeypadTrapDoorBlock(BlockBehaviour.Properties properties, BlockSetType blockSetType) {
        super(properties, blockSetType);
    }

    @Override
    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        if (((Boolean)state.m_61143_((Property)f_57514_)).booleanValue()) {
            return InteractionResult.PASS;
        }
        if (!level.f_46443_) {
            KeypadTrapdoorBlockEntity be = (KeypadTrapdoorBlockEntity)level.m_7702_(pos);
            if (be.isDisabled()) {
                player.m_5661_((Component)Utils.localize("gui.securitycraft:scManual.disabled", new Object[0]), true);
            } else if (be.verifyPasscodeSet(level, pos, be, player)) {
                if (be.isDenied((Entity)player)) {
                    if (be.sendsMessages()) {
                        PlayerUtils.sendMessageToPlayer(player, Utils.localize(this.m_7705_(), new Object[0]), Utils.localize("messages.securitycraft:module.onDenylist", new Object[0]), ChatFormatting.RED);
                    }
                } else if (be.isAllowed((Entity)player)) {
                    if (be.sendsMessages()) {
                        PlayerUtils.sendMessageToPlayer(player, Utils.localize(this.m_7705_(), new Object[0]), Utils.localize("messages.securitycraft:module.onAllowlist", new Object[0]), ChatFormatting.GREEN);
                    }
                    this.activate(state, level, pos, be.getSignalLength());
                } else if (!player.m_21120_(hand).m_150930_((Item)SCContent.CODEBREAKER.get())) {
                    be.openPasscodeGUI(level, pos, player);
                }
            }
        }
        return InteractionResult.SUCCESS;
    }

    public void activate(BlockState state, Level level, BlockPos pos, int signalLength) {
        level.m_46597_(pos, (BlockState)state.m_61124_((Property)f_57514_, (Comparable)Boolean.valueOf(true)));
        level.m_186460_(pos, (Block)this, signalLength);
        this.m_57527_(null, level, pos, true);
    }

    public void m_213897_(BlockState state, ServerLevel level, BlockPos pos, RandomSource random) {
        if (((Boolean)state.m_61143_((Property)f_57514_)).booleanValue()) {
            level.m_46597_(pos, (BlockState)state.m_61124_((Property)f_57514_, (Comparable)Boolean.valueOf(false)));
            this.m_57527_(null, (Level)level, pos, false);
        }
    }

    @Override
    public void m_6810_(BlockState state, Level level, BlockPos pos, BlockState newState, boolean isMoving) {
        BlockEntity blockEntity;
        if (!state.m_60713_(newState.m_60734_()) && (blockEntity = level.m_7702_(pos)) instanceof IPasscodeProtected) {
            IPasscodeProtected be = (IPasscodeProtected)blockEntity;
            SaltData.removeSalt(be.getSaltKey());
        }
        super.m_6810_(state, level, pos, newState, isMoving);
    }

    public void m_6861_(BlockState state, Level level, BlockPos pos, Block block, BlockPos neighbor, boolean flag) {
    }

    @Override
    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return new KeypadTrapdoorBlockEntity(pos, state);
    }

    public static class Convertible
    implements IPasscodeConvertible {
        @Override
        public boolean isValidStateForConversion(BlockState state) {
            return state.m_60713_((Block)SCContent.REINFORCED_IRON_TRAPDOOR.get());
        }

        @Override
        public boolean convert(Player player, Level level, BlockPos pos) {
            BlockState state = level.m_8055_(pos);
            Direction facing = (Direction)state.m_61143_((Property)HorizontalDirectionalBlock.f_54117_);
            boolean open = (Boolean)state.m_61143_((Property)TrapDoorBlock.f_57514_);
            Half half = (Half)state.m_61143_((Property)TrapDoorBlock.f_57515_);
            boolean powered = (Boolean)state.m_61143_((Property)TrapDoorBlock.f_57516_);
            boolean waterlogged = (Boolean)state.m_61143_((Property)TrapDoorBlock.f_57517_);
            BlockEntity trapdoor = level.m_7702_(pos);
            CompoundTag tag = trapdoor.m_187480_();
            level.m_46597_(pos, (BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((KeypadTrapDoorBlock)((Object)SCContent.KEYPAD_TRAPDOOR.get())).m_49966_().m_61124_((Property)HorizontalDirectionalBlock.f_54117_, (Comparable)facing)).m_61124_((Property)TrapDoorBlock.f_57514_, (Comparable)Boolean.valueOf(open))).m_61124_((Property)TrapDoorBlock.f_57515_, (Comparable)half)).m_61124_((Property)TrapDoorBlock.f_57516_, (Comparable)Boolean.valueOf(powered))).m_61124_((Property)TrapDoorBlock.f_57517_, (Comparable)Boolean.valueOf(waterlogged)));
            trapdoor = level.m_7702_(pos);
            trapdoor.m_142466_(tag);
            ((IOwnable)trapdoor).setOwner(player.m_20148_().toString(), player.m_7755_().getString());
            return true;
        }
    }
}

