/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.blocks;

import net.geforcemods.securitycraft.ConfigHandler;
import net.geforcemods.securitycraft.api.Owner;
import net.geforcemods.securitycraft.blockentities.KeycardLockBlockEntity;
import net.geforcemods.securitycraft.blocks.AbstractPanelBlock;
import net.geforcemods.securitycraft.blocks.KeycardReaderBlock;
import net.geforcemods.securitycraft.items.KeycardItem;
import net.geforcemods.securitycraft.items.UniversalKeyChangerItem;
import net.geforcemods.securitycraft.util.PlayerUtils;
import net.geforcemods.securitycraft.util.TeamUtils;
import net.geforcemods.securitycraft.util.Utils;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.AttachFace;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class KeycardLockBlock
extends AbstractPanelBlock {
    public static final VoxelShape FLOOR_NS = Block.m_49796_((double)4.0, (double)0.0, (double)3.0, (double)12.0, (double)3.0, (double)13.0);
    public static final VoxelShape FLOOR_EW = Block.m_49796_((double)3.0, (double)0.0, (double)4.0, (double)13.0, (double)3.0, (double)12.0);
    public static final VoxelShape CEILING_NS = Block.m_49796_((double)4.0, (double)13.0, (double)3.0, (double)12.0, (double)16.0, (double)13.0);
    public static final VoxelShape CEILING_EW = Block.m_49796_((double)3.0, (double)13.0, (double)4.0, (double)13.0, (double)16.0, (double)12.0);
    public static final VoxelShape WALL_N = Block.m_49796_((double)4.0, (double)3.0, (double)13.0, (double)12.0, (double)13.0, (double)16.0);
    public static final VoxelShape WALL_E = Block.m_49796_((double)0.0, (double)3.0, (double)4.0, (double)3.0, (double)13.0, (double)12.0);
    public static final VoxelShape WALL_S = Block.m_49796_((double)4.0, (double)3.0, (double)0.0, (double)12.0, (double)13.0, (double)3.0);
    public static final VoxelShape WALL_W = Block.m_49796_((double)13.0, (double)3.0, (double)4.0, (double)16.0, (double)13.0, (double)12.0);

    public KeycardLockBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        return KeycardReaderBlock.use(state, level, pos, player, hand, (stack, be) -> {
            if (!be.isSetUp()) {
                PlayerUtils.sendMessageToPlayer(player, Utils.localize(this.m_7705_(), new Object[0]), Utils.localize("messages.securitycraft:keycard_lock.not_set_up", new Object[0]), ChatFormatting.RED);
                return;
            }
            if (stack.m_41720_() instanceof KeycardItem) {
                boolean hasTag = stack.m_41782_();
                if (!hasTag || !stack.m_41783_().m_128471_("linked")) {
                    PlayerUtils.sendMessageToPlayer(player, Utils.localize(this.m_7705_(), new Object[0]), Utils.localize("messages.securitycraft:keycard_lock.unlinked_keycard", new Object[0]), ChatFormatting.RED);
                } else if (hasTag) {
                    CompoundTag tag = stack.m_41783_();
                    Owner keycardOwner = new Owner(tag.m_128461_("ownerName"), tag.m_128461_("ownerUUID"));
                    if (((Boolean)ConfigHandler.SERVER.enableTeamOwnership.get()).booleanValue() && !TeamUtils.areOnSameTeam(be.getOwner(), keycardOwner) || !be.getOwner().getUUID().equals(keycardOwner.getUUID())) {
                        PlayerUtils.sendMessageToPlayer(player, Utils.localize(this.m_7705_(), new Object[0]), Utils.localize("messages.securitycraft:keycard_lock.different_owner", new Object[0]), ChatFormatting.RED);
                    }
                }
                return;
            }
            if (stack.m_41720_() instanceof UniversalKeyChangerItem) {
                if (be.isOwnedBy(player)) {
                    stack.m_41622_(1, (LivingEntity)player, p -> p.m_21190_(hand));
                    be.reset();
                    PlayerUtils.sendMessageToPlayer(player, Utils.localize(this.m_7705_(), new Object[0]), Utils.localize("messages.securitycraft:keycard_lock.reset", new Object[0]), ChatFormatting.GREEN);
                } else {
                    PlayerUtils.sendMessageToPlayer(player, Utils.localize(this.m_7705_(), new Object[0]), Utils.localize("messages.securitycraft:notOwned", be.getOwner().getName()), ChatFormatting.RED);
                }
            }
        });
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext ctx) {
        return switch ((AttachFace)state.m_61143_((Property)FACE)) {
            default -> throw new IncompatibleClassChangeError();
            case AttachFace.FLOOR -> {
                switch ((Direction)state.m_61143_((Property)FACING)) {
                    case NORTH: 
                    case SOUTH: {
                        yield FLOOR_NS;
                    }
                    case EAST: 
                    case WEST: {
                        yield FLOOR_EW;
                    }
                }
                yield Shapes.m_83040_();
            }
            case AttachFace.CEILING -> {
                switch ((Direction)state.m_61143_((Property)FACING)) {
                    case NORTH: 
                    case SOUTH: {
                        yield CEILING_NS;
                    }
                    case EAST: 
                    case WEST: {
                        yield CEILING_EW;
                    }
                }
                yield Shapes.m_83040_();
            }
            case AttachFace.WALL -> {
                switch ((Direction)state.m_61143_((Property)FACING)) {
                    case NORTH: {
                        yield WALL_N;
                    }
                    case EAST: {
                        yield WALL_E;
                    }
                    case SOUTH: {
                        yield WALL_S;
                    }
                    case WEST: {
                        yield WALL_W;
                    }
                }
                yield Shapes.m_83040_();
            }
        };
    }

    @Override
    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return new KeycardLockBlockEntity(pos, state);
    }
}

