/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.blocks;

import net.geforcemods.securitycraft.SCContent;
import net.geforcemods.securitycraft.blockentities.KeyPanelBlockEntity;
import net.geforcemods.securitycraft.blocks.AbstractPanelBlock;
import net.geforcemods.securitycraft.util.PlayerUtils;
import net.geforcemods.securitycraft.util.Utils;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.AttachFace;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class KeyPanelBlock
extends AbstractPanelBlock {
    public static final VoxelShape FLOOR_NS = Block.m_49796_((double)2.0, (double)0.0, (double)1.0, (double)14.0, (double)1.0, (double)15.0);
    public static final VoxelShape FLOOR_EW = Block.m_49796_((double)1.0, (double)0.0, (double)2.0, (double)15.0, (double)1.0, (double)14.0);
    public static final VoxelShape CEILING_NS = Block.m_49796_((double)2.0, (double)15.0, (double)1.0, (double)14.0, (double)16.0, (double)15.0);
    public static final VoxelShape CEILING_EW = Block.m_49796_((double)1.0, (double)15.0, (double)2.0, (double)15.0, (double)16.0, (double)14.0);
    public static final VoxelShape WALL_N = Block.m_49796_((double)2.0, (double)1.0, (double)15.0, (double)14.0, (double)15.0, (double)16.0);
    public static final VoxelShape WALL_E = Block.m_49796_((double)0.0, (double)1.0, (double)2.0, (double)1.0, (double)15.0, (double)14.0);
    public static final VoxelShape WALL_S = Block.m_49796_((double)2.0, (double)1.0, (double)0.0, (double)14.0, (double)15.0, (double)1.0);
    public static final VoxelShape WALL_W = Block.m_49796_((double)15.0, (double)1.0, (double)2.0, (double)16.0, (double)15.0, (double)14.0);

    public KeyPanelBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        if (((Boolean)state.m_61143_((Property)POWERED)).booleanValue()) {
            return InteractionResult.PASS;
        }
        if (!level.f_46443_) {
            KeyPanelBlockEntity be = (KeyPanelBlockEntity)level.m_7702_(pos);
            if (be.isDisabled()) {
                player.m_5661_((Component)Utils.localize("gui.securitycraft:scManual.disabled", new Object[0]), true);
            } else if (be.verifyPasscodeSet(level, pos, be, player)) {
                if (be.isDenied((Entity)player)) {
                    if (be.sendsMessages()) {
                        PlayerUtils.sendMessageToPlayer(player, Utils.localize(this.m_7705_(), new Object[0]), Utils.localize("messages.securitycraft:module.onDenylist", new Object[0]), ChatFormatting.RED);
                    }
                } else if (be.isAllowed((Entity)player)) {
                    if (be.sendsMessages()) {
                        PlayerUtils.sendMessageToPlayer(player, Utils.localize(this.m_7705_(), new Object[0]), Utils.localize("messages.securitycraft:module.onAllowlist", new Object[0]), ChatFormatting.GREEN);
                    }
                    this.activate(state, level, pos, be.getSignalLength());
                } else if (!player.m_21120_(hand).m_150930_((Item)SCContent.CODEBREAKER.get())) {
                    be.openPasscodeGUI(level, pos, player);
                }
            }
        }
        return InteractionResult.SUCCESS;
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext ctx) {
        return switch ((AttachFace)state.m_61143_((Property)FACE)) {
            default -> throw new IncompatibleClassChangeError();
            case AttachFace.FLOOR -> {
                switch ((Direction)state.m_61143_((Property)FACING)) {
                    case NORTH: 
                    case SOUTH: {
                        yield FLOOR_NS;
                    }
                    case EAST: 
                    case WEST: {
                        yield FLOOR_EW;
                    }
                }
                yield Shapes.m_83040_();
            }
            case AttachFace.CEILING -> {
                switch ((Direction)state.m_61143_((Property)FACING)) {
                    case NORTH: 
                    case SOUTH: {
                        yield CEILING_NS;
                    }
                    case EAST: 
                    case WEST: {
                        yield CEILING_EW;
                    }
                }
                yield Shapes.m_83040_();
            }
            case AttachFace.WALL -> {
                switch ((Direction)state.m_61143_((Property)FACING)) {
                    case NORTH: {
                        yield WALL_N;
                    }
                    case EAST: {
                        yield WALL_E;
                    }
                    case SOUTH: {
                        yield WALL_S;
                    }
                    case WEST: {
                        yield WALL_W;
                    }
                }
                yield Shapes.m_83040_();
            }
        };
    }

    public VoxelShape m_5939_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext ctx) {
        return Shapes.m_83040_();
    }

    @Override
    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return new KeyPanelBlockEntity(pos, state);
    }
}

