/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.blockentities;

import net.geforcemods.securitycraft.ConfigHandler;
import net.geforcemods.securitycraft.SCContent;
import net.geforcemods.securitycraft.api.CustomizableBlockEntity;
import net.geforcemods.securitycraft.api.ILockable;
import net.geforcemods.securitycraft.api.IViewActivated;
import net.geforcemods.securitycraft.api.Option;
import net.geforcemods.securitycraft.api.Owner;
import net.geforcemods.securitycraft.blocks.ScannerTrapDoorBlock;
import net.geforcemods.securitycraft.misc.ModuleType;
import net.geforcemods.securitycraft.util.BlockUtils;
import net.geforcemods.securitycraft.util.EntityUtils;
import net.geforcemods.securitycraft.util.ITickingBlockEntity;
import net.geforcemods.securitycraft.util.PlayerUtils;
import net.geforcemods.securitycraft.util.Utils;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.TrapDoorBlock;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;

public class ScannerTrapdoorBlockEntity
extends CustomizableBlockEntity
implements IViewActivated,
ITickingBlockEntity,
ILockable {
    private Option.BooleanOption sendMessage = new Option.BooleanOption("sendMessage", true);
    protected Option.IntOption signalLength = new Option.IntOption("signalLength", 0, 0, 400, 5, true);
    private Option.DoubleOption maximumDistance = new Option.DoubleOption("maximumDistance", 5.0, 0.1, 25.0, 0.1, true){

        @Override
        public String getKey(Block block) {
            return "option.generic.viewActivated.maximumDistance";
        }
    };
    private Option.DisabledOption disabled = new Option.DisabledOption(false);
    private int viewCooldown = 0;

    public ScannerTrapdoorBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)SCContent.SCANNER_TRAPDOOR_BLOCK_ENTITY.get(), pos, state);
    }

    @Override
    public void tick(Level level, BlockPos pos, BlockState state) {
        this.checkView(level, pos);
    }

    @Override
    public boolean onEntityViewed(LivingEntity entity, BlockHitResult hitResult) {
        block13: {
            Player player;
            BlockState state;
            block15: {
                block14: {
                    if (EntityUtils.isInvisible(entity)) break block13;
                    state = this.m_58900_();
                    if (!(entity instanceof Player)) break block14;
                    player = (Player)entity;
                    if ((Boolean)state.m_61143_((Property)TrapDoorBlock.f_57514_) == false ? hitResult.m_82434_().m_122434_() == Direction.Axis.Y : hitResult.m_82434_().m_122434_() == ((Direction)state.m_61143_((Property)HorizontalDirectionalBlock.f_54117_)).m_122434_()) break block15;
                }
                return false;
            }
            if (!this.isLocked() && !this.isDisabled()) {
                boolean shouldBeOpen;
                Owner viewingPlayer = new Owner(player);
                if (((Boolean)ConfigHandler.SERVER.trickScannersWithPlayerHeads.get()).booleanValue() && player.m_6844_(EquipmentSlot.HEAD).m_41720_() == Items.f_42680_) {
                    viewingPlayer = PlayerUtils.getSkullOwner(player);
                }
                if (!this.isOwnedBy(viewingPlayer) && !this.isAllowed(viewingPlayer.getName())) {
                    PlayerUtils.sendMessageToPlayer(player, Utils.localize(((ScannerTrapDoorBlock)((Object)SCContent.SCANNER_TRAPDOOR.get())).m_7705_(), new Object[0]), Utils.localize("messages.securitycraft:retinalScanner.notOwner", PlayerUtils.getOwnerComponent(this.getOwner())), ChatFormatting.RED);
                    return true;
                }
                boolean bl = shouldBeOpen = (Boolean)state.m_61143_((Property)TrapDoorBlock.f_57514_) == false;
                if (shouldBeOpen && ((Boolean)this.sendMessage.get()).booleanValue()) {
                    PlayerUtils.sendMessageToPlayer(player, Utils.localize(((ScannerTrapDoorBlock)((Object)SCContent.SCANNER_TRAPDOOR.get())).m_7705_(), new Object[0]), Utils.localize("messages.securitycraft:retinalScanner.hello", viewingPlayer.getName()), ChatFormatting.GREEN);
                }
                this.f_58857_.m_46597_(this.f_58858_, (BlockState)state.m_61124_((Property)TrapDoorBlock.f_57514_, (Comparable)Boolean.valueOf(shouldBeOpen)));
                BlockUtils.updateIndirectNeighbors(this.f_58857_, this.f_58858_, (Block)SCContent.SCANNER_TRAPDOOR.get());
                ((ScannerTrapDoorBlock)((Object)SCContent.SCANNER_TRAPDOOR.get())).m_57527_(null, this.f_58857_, this.f_58858_, shouldBeOpen);
                if (this.getSignalLength() > 0) {
                    this.f_58857_.m_186460_(this.f_58858_, (Block)SCContent.SCANNER_TRAPDOOR.get(), this.getSignalLength());
                }
            } else if (this.isLocked() && ((Boolean)this.sendMessage.get()).booleanValue()) {
                MutableComponent blockName = Utils.localize(((ScannerTrapDoorBlock)((Object)SCContent.SCANNER_TRAPDOOR.get())).m_7705_(), new Object[0]);
                PlayerUtils.sendMessageToPlayer(player, blockName, Utils.localize("messages.securitycraft:sonic_security_system.locked", blockName), ChatFormatting.DARK_RED, false);
            } else if (this.isDisabled()) {
                player.m_5661_((Component)Utils.localize("gui.securitycraft:scManual.disabled", new Object[0]), true);
            }
            return true;
        }
        return false;
    }

    @Override
    public int getViewCooldown() {
        return this.viewCooldown;
    }

    @Override
    public void setViewCooldown(int viewCooldown) {
        this.viewCooldown = viewCooldown;
        this.m_6596_();
    }

    public int getSignalLength() {
        return (Integer)this.signalLength.get();
    }

    public boolean isDisabled() {
        return (Boolean)this.disabled.get();
    }

    @Override
    public double getMaximumDistance() {
        return (Double)this.maximumDistance.get();
    }

    @Override
    public ModuleType[] acceptedModules() {
        return new ModuleType[]{ModuleType.ALLOWLIST};
    }

    @Override
    public Option<?>[] customOptions() {
        return new Option[]{this.sendMessage, this.signalLength, this.disabled, this.maximumDistance};
    }
}

