/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.blockentities;

import java.util.Collection;
import java.util.List;
import net.geforcemods.securitycraft.SCContent;
import net.geforcemods.securitycraft.api.CustomizableBlockEntity;
import net.geforcemods.securitycraft.api.Option;
import net.geforcemods.securitycraft.api.Owner;
import net.geforcemods.securitycraft.blocks.PortableRadarBlock;
import net.geforcemods.securitycraft.misc.ModuleType;
import net.geforcemods.securitycraft.util.EntityUtils;
import net.geforcemods.securitycraft.util.ITickingBlockEntity;
import net.geforcemods.securitycraft.util.PlayerUtils;
import net.geforcemods.securitycraft.util.TeamUtils;
import net.geforcemods.securitycraft.util.Utils;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;

public class PortableRadarBlockEntity
extends CustomizableBlockEntity
implements ITickingBlockEntity {
    private Option.DoubleOption searchRadiusOption = new Option.DoubleOption("searchRadius", 25.0, 1.0, 50.0, 1.0, true);
    private Option.IntOption searchDelayOption = new Option.IntOption("searchDelay", 4, 4, 10, 1, true);
    private Option.BooleanOption repeatMessageOption = new Option.BooleanOption("repeatMessage", true);
    private Option.DisabledOption disabled = new Option.DisabledOption(false);
    private Option.IgnoreOwnerOption ignoreOwner = new Option.IgnoreOwnerOption(true);
    private boolean shouldSendNewMessage = true;
    private Owner lastPlayer = new Owner();
    private int ticksUntilNextSearch = this.getSearchDelay();

    public PortableRadarBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)SCContent.PORTABLE_RADAR_BLOCK_ENTITY.get(), pos, state);
    }

    @Override
    public void tick(Level level, BlockPos pos, BlockState state) {
        if (!((Boolean)this.disabled.get()).booleanValue() && this.ticksUntilNextSearch-- <= 0) {
            this.ticksUntilNextSearch = this.getSearchDelay();
            AABB area = new AABB(pos).m_82400_(this.getSearchRadius());
            List closebyPlayers = level.m_6443_(Player.class, area, e -> (!this.isOwnedBy((Player)e) || !this.ignoresOwner()) && !this.isAllowed((Entity)e) && e.m_142065_() && !EntityUtils.isInvisible((LivingEntity)e));
            if (this.isModuleEnabled(ModuleType.REDSTONE)) {
                PortableRadarBlock.togglePowerOutput(level, pos, !closebyPlayers.isEmpty());
            }
            if (!closebyPlayers.isEmpty()) {
                Collection<ServerPlayer> onlineTeamPlayers = TeamUtils.getOnlinePlayersInTeam(level.m_7654_(), this.getOwner());
                for (Player closebyPlayer : closebyPlayers) {
                    if (!this.shouldSendMessage(closebyPlayer)) continue;
                    MutableComponent attackedName = closebyPlayer.m_7755_().m_6879_().m_130940_(ChatFormatting.ITALIC);
                    MutableComponent text = this.m_8077_() ? Utils.localize("messages.securitycraft:portableRadar.withName", attackedName, this.m_7770_().m_6879_().m_130940_(ChatFormatting.ITALIC)) : Utils.localize("messages.securitycraft:portableRadar.withoutName", attackedName, Utils.getFormattedCoordinates(pos));
                    onlineTeamPlayers.forEach(player -> PlayerUtils.sendMessageToPlayer((Player)player, Utils.localize(((Block)SCContent.PORTABLE_RADAR.get()).m_7705_(), new Object[0]), text, ChatFormatting.BLUE));
                    this.setSentMessage();
                }
            }
        }
    }

    @Override
    public void onModuleRemoved(ItemStack stack, ModuleType module, boolean toggled) {
        super.onModuleRemoved(stack, module, toggled);
        if (module == ModuleType.REDSTONE) {
            PortableRadarBlock.togglePowerOutput(this.f_58857_, this.f_58858_, false);
        }
    }

    @Override
    public void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        CompoundTag lastPlayerTag = new CompoundTag();
        tag.m_128379_("shouldSendNewMessage", this.shouldSendNewMessage);
        this.lastPlayer.save(lastPlayerTag, this.needsValidation());
        tag.m_128365_("lastPlayer", (Tag)lastPlayerTag);
    }

    @Override
    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        this.shouldSendNewMessage = tag.m_128471_("shouldSendNewMessage");
        this.lastPlayer = Owner.fromCompound(tag.m_128469_("lastPlayer"));
    }

    @Override
    public void readOptions(CompoundTag tag) {
        if (tag.m_128441_("enabled")) {
            tag.m_128379_("disabled", !tag.m_128471_("enabled"));
        }
        for (Option<?> option : this.customOptions()) {
            option.load(tag);
        }
    }

    public boolean shouldSendMessage(Player player) {
        Owner currentPlayer = new Owner(player);
        if (!currentPlayer.equals(this.lastPlayer)) {
            this.shouldSendNewMessage = true;
            this.lastPlayer = currentPlayer;
            this.m_6596_();
        }
        return !(!this.shouldSendNewMessage && (Boolean)this.repeatMessageOption.get() == false || this.lastPlayer.owns(this) && this.ignoresOwner());
    }

    public void setSentMessage() {
        this.shouldSendNewMessage = false;
        this.m_6596_();
    }

    public double getSearchRadius() {
        return (Double)this.searchRadiusOption.get();
    }

    public int getSearchDelay() {
        return (Integer)this.searchDelayOption.get() * 20;
    }

    public boolean ignoresOwner() {
        return (Boolean)this.ignoreOwner.get();
    }

    @Override
    public ModuleType[] acceptedModules() {
        return new ModuleType[]{ModuleType.REDSTONE, ModuleType.ALLOWLIST};
    }

    @Override
    public Option<?>[] customOptions() {
        return new Option[]{this.searchRadiusOption, this.searchDelayOption, this.repeatMessageOption, this.disabled, this.ignoreOwner};
    }
}

