/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.blockentities;

import net.geforcemods.securitycraft.SCContent;
import net.geforcemods.securitycraft.api.Option;
import net.geforcemods.securitycraft.blockentities.KeycardReaderBlockEntity;
import net.geforcemods.securitycraft.items.KeycardItem;
import net.geforcemods.securitycraft.misc.ModuleType;
import net.geforcemods.securitycraft.util.PlayerUtils;
import net.geforcemods.securitycraft.util.Utils;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;

public class KeycardLockBlockEntity
extends KeycardReaderBlockEntity {
    protected Option.BooleanOption exactLevel = new Option.BooleanOption("exactLevel", true);
    private boolean setUp = false;

    public KeycardLockBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)SCContent.KEYCARD_LOCK_BLOCK_ENTITY.get(), pos, state);
    }

    @Override
    public InteractionResult onRightClickWithActionItem(ItemStack stack, InteractionHand hand, Player player, boolean isCodebreaker, boolean isKeycardHolder) {
        if (!this.isSetUp() && this.isOwnedBy(player)) {
            Item item = stack.m_41720_();
            if (item instanceof KeycardItem) {
                String keySuffix;
                KeycardItem item2 = (KeycardItem)item;
                boolean[] levels = new boolean[]{false, false, false, false, false};
                if (((Boolean)this.exactLevel.get()).booleanValue()) {
                    levels[item2.getLevel()] = true;
                    keySuffix = "exact";
                } else {
                    for (int i = item2.getLevel(); i < 5; ++i) {
                        levels[i] = true;
                    }
                    keySuffix = "above";
                }
                this.setUp = true;
                this.setAcceptedLevels(levels);
                this.setSignature(stack.m_41784_().m_128451_("signature"));
                PlayerUtils.sendMessageToPlayer(player, Utils.localize(this.m_58900_().m_60734_().m_7705_(), new Object[0]), Utils.localize("messages.securitycraft:keycard_lock.setup_successful." + keySuffix, item2.getLevel() + 1), ChatFormatting.GREEN);
                return InteractionResult.SUCCESS;
            }
            PlayerUtils.sendMessageToPlayer(player, Utils.localize(this.m_58900_().m_60734_().m_7705_(), new Object[0]), Utils.localize("messages.securitycraft:keycard_lock.not_set_up", new Object[0]), ChatFormatting.RED);
            return InteractionResult.FAIL;
        }
        return super.onRightClickWithActionItem(stack, hand, player, isCodebreaker, isKeycardHolder);
    }

    public boolean isSetUp() {
        return this.setUp;
    }

    public void reset() {
        this.setUp = false;
        this.setAcceptedLevels(new boolean[]{false, false, false, false, false});
        this.setSignature(0);
    }

    @Override
    public void onOptionChanged(Option<?> option) {
        if (option.getName().equals(this.exactLevel.getName())) {
            boolean[] acceptedLevels = this.getAcceptedLevels();
            boolean swap = false;
            for (int i = 0; i < acceptedLevels.length; ++i) {
                if (swap) {
                    acceptedLevels[i] = !acceptedLevels[i];
                    continue;
                }
                if (!acceptedLevels[i]) continue;
                swap = true;
            }
        }
    }

    @Override
    public void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        tag.m_128379_("set_up", this.setUp);
    }

    @Override
    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        this.setUp = tag.m_128471_("set_up");
    }

    @Override
    public ModuleType[] acceptedModules() {
        return new ModuleType[]{ModuleType.DENYLIST};
    }

    @Override
    public Option<?>[] customOptions() {
        return new Option[]{this.sendMessage, this.signalLength, this.disabled, this.exactLevel};
    }
}

