/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.blockentities;

import java.util.UUID;
import net.geforcemods.securitycraft.SCContent;
import net.geforcemods.securitycraft.api.CustomizableBlockEntity;
import net.geforcemods.securitycraft.api.ILockable;
import net.geforcemods.securitycraft.api.IPasscodeProtected;
import net.geforcemods.securitycraft.api.Option;
import net.geforcemods.securitycraft.blocks.DisplayCaseBlock;
import net.geforcemods.securitycraft.misc.ModuleType;
import net.geforcemods.securitycraft.misc.SCSounds;
import net.geforcemods.securitycraft.util.ITickingBlockEntity;
import net.geforcemods.securitycraft.util.PasscodeUtils;
import net.geforcemods.securitycraft.util.Utils;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;

public class DisplayCaseBlockEntity
extends CustomizableBlockEntity
implements ITickingBlockEntity,
IPasscodeProtected,
ILockable {
    private final AABB renderBoundingBox;
    private Option.BooleanOption sendMessage = new Option.BooleanOption("sendMessage", true);
    private Option.DisabledOption disabled = new Option.DisabledOption(false);
    private Option.SmartModuleCooldownOption smartModuleCooldown = new Option.SmartModuleCooldownOption();
    private long cooldownEnd = 0L;
    private ItemStack displayedStack = ItemStack.f_41583_;
    private boolean shouldBeOpen;
    private float openness;
    private float oOpenness;
    private byte[] passcode;
    private UUID saltKey;

    public DisplayCaseBlockEntity(BlockPos pos, BlockState state) {
        this((BlockEntityType)SCContent.DISPLAY_CASE_BLOCK_ENTITY.get(), pos, state);
    }

    public DisplayCaseBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
        this.renderBoundingBox = new AABB(pos);
    }

    @Override
    public void tick(Level level, BlockPos pos, BlockState state) {
        this.oOpenness = this.openness;
        if (!this.shouldBeOpen && this.openness > 0.0f) {
            this.openness = Math.max(this.openness - 0.1f, 0.0f);
        } else if (this.shouldBeOpen && this.openness < 1.0f) {
            this.openness = Math.min(this.openness + 0.1f, 1.0f);
        }
    }

    @Override
    public void activate(Player player) {
        Block block;
        if (!this.f_58857_.f_46443_ && (block = this.m_58900_().m_60734_()) instanceof DisplayCaseBlock) {
            DisplayCaseBlock block2 = (DisplayCaseBlock)block;
            block2.activate(this);
        }
    }

    @Override
    public boolean shouldAttemptCodebreak(BlockState state, Player player) {
        if (this.isDisabled()) {
            player.m_5661_((Component)Utils.localize("gui.securitycraft:scManual.disabled", new Object[0]), true);
            return false;
        }
        return !this.isOpen() && IPasscodeProtected.super.shouldAttemptCodebreak(state, player);
    }

    @Override
    public byte[] getPasscode() {
        return this.passcode == null || this.passcode.length == 0 ? null : this.passcode;
    }

    @Override
    public void setPasscode(byte[] passcode) {
        this.passcode = passcode;
        this.m_6596_();
    }

    @Override
    public UUID getSaltKey() {
        return this.saltKey;
    }

    @Override
    public void setSaltKey(UUID saltKey) {
        this.saltKey = saltKey;
    }

    @Override
    public void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        tag.m_128365_("DisplayedStack", (Tag)this.getDisplayedStack().m_41739_(new CompoundTag()));
        tag.m_128379_("ShouldBeOpen", this.shouldBeOpen);
        long cooldownLeft = this.getCooldownEnd() - System.currentTimeMillis();
        tag.m_128356_("cooldownLeft", cooldownLeft <= 0L ? -1L : cooldownLeft);
        if (this.saltKey != null) {
            tag.m_128362_("saltKey", this.saltKey);
        }
        if (this.passcode != null) {
            tag.m_128359_("passcode", PasscodeUtils.bytesToString(this.passcode));
        }
    }

    @Override
    public void m_142466_(CompoundTag tag) {
        this.load(tag, true);
    }

    public void load(CompoundTag tag, boolean forceOpenness) {
        super.m_142466_(tag);
        this.setDisplayedStack(ItemStack.m_41712_((CompoundTag)((CompoundTag)tag.m_128423_("DisplayedStack"))));
        this.shouldBeOpen = tag.m_128471_("ShouldBeOpen");
        this.cooldownEnd = System.currentTimeMillis() + tag.m_128454_("cooldownLeft");
        this.loadSaltKey(tag);
        this.loadPasscode(tag);
        if (forceOpenness) {
            this.forceOpen(this.shouldBeOpen);
        }
    }

    @Override
    public void startCooldown() {
        if (!this.isOnCooldown()) {
            this.cooldownEnd = System.currentTimeMillis() + (long)((Integer)this.smartModuleCooldown.get() * 50);
            this.f_58857_.m_7260_(this.f_58858_, this.m_58900_(), this.m_58900_(), 2);
            this.m_6596_();
        }
    }

    @Override
    public long getCooldownEnd() {
        return this.cooldownEnd;
    }

    @Override
    public boolean isOnCooldown() {
        return System.currentTimeMillis() < this.getCooldownEnd();
    }

    @Override
    public ModuleType[] acceptedModules() {
        return new ModuleType[]{ModuleType.ALLOWLIST, ModuleType.DENYLIST, ModuleType.SMART, ModuleType.HARMING};
    }

    @Override
    public Option<?>[] customOptions() {
        return new Option[]{this.sendMessage, this.disabled, this.smartModuleCooldown};
    }

    public boolean sendsMessages() {
        return (Boolean)this.sendMessage.get();
    }

    public boolean isDisabled() {
        return (Boolean)this.disabled.get();
    }

    @Override
    public void handleUpdateTag(CompoundTag tag) {
        this.load(tag, false);
    }

    public void setDisplayedStack(ItemStack displayedStack) {
        this.displayedStack = displayedStack;
        this.sync();
    }

    public ItemStack getDisplayedStack() {
        return this.displayedStack;
    }

    public void setOpen(boolean shouldBeOpen) {
        this.f_58857_.m_5594_(null, this.f_58858_, shouldBeOpen ? SCSounds.DISPLAY_CASE_OPEN.event : SCSounds.DISPLAY_CASE_CLOSE.event, SoundSource.BLOCKS, 1.0f, 1.0f);
        this.shouldBeOpen = shouldBeOpen;
        this.sync();
    }

    public void forceOpen(boolean open) {
        this.shouldBeOpen = open;
        this.openness = open ? 1.0f : 0.0f;
        this.oOpenness = this.openness;
        this.sync();
    }

    public float getOpenness(float partialTicks) {
        return Mth.m_14179_((float)partialTicks, (float)this.oOpenness, (float)this.openness);
    }

    public boolean isOpen() {
        return this.shouldBeOpen;
    }

    private void sync() {
        if (this.f_58857_ != null && !this.f_58857_.f_46443_) {
            this.m_6596_();
            this.f_58857_.m_7260_(this.f_58858_, this.m_58900_(), this.m_58900_(), 2);
        }
    }

    public AABB getRenderBoundingBox() {
        return this.renderBoundingBox;
    }
}

