/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.api;

import net.geforcemods.securitycraft.ConfigHandler;
import net.geforcemods.securitycraft.SCContent;
import net.geforcemods.securitycraft.api.IOwnable;
import net.geforcemods.securitycraft.util.TeamUtils;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import org.apache.commons.lang3.builder.HashCodeBuilder;

public class Owner {
    private String ownerName = "owner";
    private String ownerUUID = "ownerUUID";
    private boolean validated = true;

    public Owner() {
    }

    public Owner(Entity entity) {
        if (entity instanceof Player) {
            Player player = (Player)entity;
            this.ownerName = player.m_7755_().getString();
            this.ownerUUID = player.m_36316_().getId().toString();
        }
    }

    public Owner(Player player) {
        if (player != null) {
            this.ownerName = player.m_7755_().getString();
            this.ownerUUID = player.m_36316_().getId().toString();
        }
    }

    public Owner(String playerName, String playerUUID) {
        this.ownerName = playerName;
        this.ownerUUID = playerUUID;
    }

    public Owner(String playerName, String playerUUID, boolean validated) {
        this.ownerName = playerName;
        this.ownerUUID = playerUUID;
        this.validated = validated;
    }

    public static Owner fromCompound(CompoundTag tag) {
        Owner owner = new Owner();
        if (tag != null) {
            owner.load(tag);
        }
        return owner;
    }

    public void load(CompoundTag tag) {
        if (tag.m_128441_("owner")) {
            this.ownerName = tag.m_128461_("owner");
        }
        if (tag.m_128441_("ownerUUID")) {
            this.ownerUUID = tag.m_128461_("ownerUUID");
        }
        if (tag.m_128441_("ownerValidated")) {
            this.validated = tag.m_128471_("ownerValidated");
        }
    }

    public void save(CompoundTag tag, boolean saveValidationStatus) {
        tag.m_128359_("owner", this.ownerName);
        tag.m_128359_("ownerUUID", this.ownerUUID);
        if (saveValidationStatus) {
            tag.m_128379_("ownerValidated", this.validated);
        }
    }

    public boolean owns(IOwnable ... ownables) {
        for (IOwnable ownable : ownables) {
            if (ownable == null) continue;
            Owner ownableOwner = ownable.getOwner();
            String uuidToCheck = ownableOwner.getUUID();
            String nameToCheck = ownableOwner.getName();
            if (((Boolean)ConfigHandler.SERVER.enableTeamOwnership.get()).booleanValue() && TeamUtils.areOnSameTeam(this, ownableOwner)) continue;
            if (uuidToCheck != null && !uuidToCheck.equals(this.ownerUUID)) {
                return false;
            }
            if (nameToCheck == null || !uuidToCheck.equals("ownerUUID") || nameToCheck.equals("owner") || nameToCheck.equals(this.ownerName)) continue;
            return false;
        }
        return true;
    }

    public void set(String uuid, String name) {
        this.ownerName = name;
        this.ownerUUID = uuid;
    }

    public void setOwnerName(String name) {
        this.ownerName = name;
    }

    public void setOwnerUUID(String uuid) {
        this.ownerUUID = uuid;
    }

    public void setValidated(boolean validated) {
        this.validated = validated;
    }

    public String getName() {
        return this.ownerName;
    }

    public String getUUID() {
        return this.ownerUUID;
    }

    public boolean isValidated() {
        return this.validated;
    }

    public String toString() {
        return "Name: " + this.ownerName + "  UUID: " + this.ownerUUID;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Deprecated
    public boolean equals(Object obj) {
        if (!(obj instanceof Owner)) return false;
        Owner owner = (Owner)obj;
        if (!this.getName().equals(owner.getName())) return false;
        if (!this.getUUID().equals(owner.getUUID())) return false;
        return true;
    }

    public int hashCode() {
        return new HashCodeBuilder().append((Object)this.ownerName).append((Object)this.ownerUUID).build();
    }

    public static EntityDataSerializer<Owner> getSerializer() {
        return (EntityDataSerializer)SCContent.OWNER_SERIALIZER.get();
    }
}

