/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.api;

import net.minecraft.ChatFormatting;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.level.block.Block;

public abstract class Option<T> {
    private String name;
    protected T value;
    private T defaultValue;
    private T increment;
    private T minimum;
    private T maximum;

    protected Option(String optionName, T value) {
        this.name = optionName;
        this.value = value;
        this.defaultValue = value;
    }

    protected Option(String optionName, T value, T min, T max, T increment) {
        this.name = optionName;
        this.value = value;
        this.defaultValue = value;
        this.increment = increment;
        this.minimum = min;
        this.maximum = max;
    }

    public abstract void toggle();

    public abstract void load(CompoundTag var1);

    public abstract void save(CompoundTag var1);

    public void copy(Option<?> option) {
        this.value = option.get();
    }

    public final String getName() {
        return this.name;
    }

    public T get() {
        return this.value;
    }

    public void setValue(T value) {
        this.value = value;
    }

    public T getDefaultValue() {
        return this.defaultValue;
    }

    public T getIncrement() {
        return this.increment;
    }

    public T getMin() {
        return this.minimum;
    }

    public T getMax() {
        return this.maximum;
    }

    public boolean isSlider() {
        return false;
    }

    public String getKey(Block block) {
        return "option." + block.m_7705_().substring(6) + "." + this.getName();
    }

    public String getDescriptionKey(Block block) {
        return this.getKey(block) + ".description";
    }

    public Component getDefaultInfo() {
        return Component.m_237110_((String)"securitycraft.option.default_with_range", (Object[])new Object[]{this.getDefaultValue(), this.getMin(), this.getMax()}).m_130940_(ChatFormatting.GRAY);
    }

    public String toString() {
        return "" + this.value;
    }

    public static class EnumOption<T extends Enum<T>>
    extends Option<T> {
        private final Class<T> enumClass;

        protected EnumOption(String optionName, T value, Class<T> enumClass) {
            super(optionName, value);
            this.enumClass = enumClass;
        }

        @Override
        public void toggle() {
            Enum[] enumConstants = (Enum[])this.enumClass.getEnumConstants();
            int next = (((Enum)this.value).ordinal() + 1) % enumConstants.length;
            this.value = enumConstants[next];
        }

        @Override
        public void load(CompoundTag tag) {
            Enum[] enumConstants = (Enum[])this.enumClass.getEnumConstants();
            int ordinal = tag.m_128451_(this.getName());
            this.value = ordinal >= 0 && ordinal < enumConstants.length ? enumConstants[ordinal] : this.getDefaultValue();
        }

        @Override
        public void save(CompoundTag tag) {
            tag.m_128405_(this.getName(), ((Enum)this.value).ordinal());
        }

        public Component getValueName() {
            return Component.m_237113_((String)((Enum)this.value).name());
        }

        @Override
        public Component getDefaultInfo() {
            return Component.m_237110_((String)"securitycraft.option.default", (Object[])new Object[]{this.getValueName()}).m_130940_(ChatFormatting.GRAY);
        }
    }

    public static class FloatOption
    extends Option<Float> {
        public FloatOption(String optionName, Float value, Float min, Float max, Float increment) {
            super(optionName, value, min, max, increment);
        }

        @Override
        public void toggle() {
            if (((Float)this.get()).floatValue() >= ((Float)this.getMax()).floatValue()) {
                this.setValue((Float)this.getMin());
                return;
            }
            if (((Float)this.get()).floatValue() + ((Float)this.getIncrement()).floatValue() >= ((Float)this.getMax()).floatValue()) {
                this.setValue((Float)this.getMax());
                return;
            }
            this.setValue(Float.valueOf(((Float)this.get()).floatValue() + ((Float)this.getIncrement()).floatValue()));
        }

        @Override
        public void load(CompoundTag tag) {
            this.value = tag.m_128441_(this.getName()) ? Float.valueOf(tag.m_128457_(this.getName())) : this.getDefaultValue();
        }

        @Override
        public void save(CompoundTag tag) {
            tag.m_128350_(this.getName(), ((Float)this.value).floatValue());
        }

        @Override
        public String toString() {
            return Float.toString(((Float)this.value).floatValue()).length() > 5 ? Float.toString(((Float)this.value).floatValue()).substring(0, 5) : Float.toString(((Float)this.value).floatValue());
        }
    }

    public static class DoubleOption
    extends Option<Double> {
        private boolean isSlider;

        public DoubleOption(String optionName, Double value, Double min, Double max, Double increment) {
            super(optionName, value, min, max, increment);
            this.isSlider = false;
        }

        public DoubleOption(String optionName, Double value, Double min, Double max, Double increment, boolean isSlider) {
            super(optionName, value, min, max, increment);
            this.isSlider = isSlider;
        }

        @Override
        public void toggle() {
            if (this.isSlider()) {
                return;
            }
            if ((Double)this.get() >= (Double)this.getMax()) {
                this.setValue((Double)this.getMin());
                return;
            }
            if ((Double)this.get() + (Double)this.getIncrement() >= (Double)this.getMax()) {
                this.setValue((Double)this.getMax());
                return;
            }
            this.setValue((Double)this.get() + (Double)this.getIncrement());
        }

        @Override
        public void load(CompoundTag tag) {
            this.value = tag.m_128441_(this.getName()) ? Double.valueOf(tag.m_128459_(this.getName())) : this.getDefaultValue();
        }

        @Override
        public void save(CompoundTag tag) {
            tag.m_128347_(this.getName(), ((Double)this.value).doubleValue());
        }

        @Override
        public String toString() {
            return Double.toString((Double)this.value).length() > 5 ? Double.toString((Double)this.value).substring(0, 5) : Double.toString((Double)this.value);
        }

        @Override
        public boolean isSlider() {
            return this.isSlider;
        }
    }

    public static class SignalLengthOption
    extends IntOption {
        public SignalLengthOption(int defaultLength) {
            super("signalLength", defaultLength, 0, 400, 5, true);
        }

        @Override
        public String getKey(Block block) {
            return "option.generic.signalLength";
        }
    }

    public static class SmartModuleCooldownOption
    extends IntOption {
        public SmartModuleCooldownOption() {
            super("smartModuleCooldown", 100, 20, 400, 1, true);
        }

        @Override
        public String getKey(Block block) {
            return "option.generic.smartModuleCooldown";
        }
    }

    public static class IntOption
    extends Option<Integer> {
        private boolean isSlider;

        public IntOption(String optionName, Integer value, Integer min, Integer max, Integer increment) {
            this(optionName, value, min, max, increment, false);
        }

        public IntOption(String optionName, Integer value, Integer min, Integer max, Integer increment, boolean isSlider) {
            super(optionName, value, min, max, increment);
            this.isSlider = isSlider;
        }

        @Override
        public void toggle() {
            if (this.isSlider()) {
                return;
            }
            if ((Integer)this.get() >= (Integer)this.getMax()) {
                this.setValue((Integer)this.getMin());
                return;
            }
            if ((Integer)this.get() + (Integer)this.getIncrement() >= (Integer)this.getMax()) {
                this.setValue((Integer)this.getMax());
                return;
            }
            this.setValue((Integer)this.get() + (Integer)this.getIncrement());
        }

        @Override
        public void load(CompoundTag tag) {
            this.value = tag.m_128441_(this.getName()) ? Integer.valueOf(tag.m_128451_(this.getName())) : this.getDefaultValue();
        }

        @Override
        public void save(CompoundTag tag) {
            tag.m_128405_(this.getName(), ((Integer)this.value).intValue());
        }

        @Override
        public boolean isSlider() {
            return this.isSlider;
        }
    }

    public static class IgnoreOwnerOption
    extends BooleanOption {
        public IgnoreOwnerOption(Boolean value) {
            super("ignoreOwner", value);
        }

        @Override
        public String getKey(Block block) {
            return "option.generic.ignoreOwner";
        }
    }

    public static class DisabledOption
    extends BooleanOption {
        public DisabledOption(Boolean value) {
            super("disabled", value);
        }

        @Override
        public String getKey(Block block) {
            return "option.generic.disabled";
        }
    }

    public static class BooleanOption
    extends Option<Boolean> {
        public BooleanOption(String optionName, Boolean value) {
            super(optionName, value);
        }

        @Override
        public void toggle() {
            this.setValue((Boolean)this.get() == false);
        }

        @Override
        public void load(CompoundTag tag) {
            this.value = tag.m_128441_(this.getName()) ? Boolean.valueOf(tag.m_128471_(this.getName())) : this.getDefaultValue();
        }

        @Override
        public void save(CompoundTag tag) {
            tag.m_128379_(this.getName(), ((Boolean)this.value).booleanValue());
        }

        @Override
        public Component getDefaultInfo() {
            return Component.m_237110_((String)"securitycraft.option.default", (Object[])new Object[]{Component.m_237115_((String)((Boolean)this.getDefaultValue() != false ? "gui.securitycraft:invScan.yes" : "gui.securitycraft:invScan.no"))}).m_130940_(ChatFormatting.GRAY);
        }
    }
}

