/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.item;

import java.util.UUID;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;
import twilightforest.entity.CubeOfAnnihilation;
import twilightforest.init.TFEntities;

public class CubeOfAnnihilationItem
extends Item {
    private static final String THROWN_UUID_KEY = "cubeEntity";

    public CubeOfAnnihilationItem(Item.Properties properties) {
        super(properties);
    }

    public void m_6883_(ItemStack stack, Level level, Entity holder, int slot, boolean isSelected) {
        if (!level.m_5776_() && CubeOfAnnihilationItem.getThrownUuid(stack) != null && CubeOfAnnihilationItem.getThrownEntity(level, stack) == null) {
            stack.m_41783_().m_128473_(THROWN_UUID_KEY);
        }
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, InteractionHand hand) {
        ItemStack stack = player.m_21120_(hand);
        if (CubeOfAnnihilationItem.getThrownUuid(stack) != null) {
            return new InteractionResultHolder(InteractionResult.PASS, (Object)stack);
        }
        if (!level.m_5776_()) {
            CubeOfAnnihilation launchedCube = new CubeOfAnnihilation((EntityType<? extends CubeOfAnnihilation>)((EntityType)TFEntities.CUBE_OF_ANNIHILATION.get()), level, (LivingEntity)player);
            level.m_7967_((Entity)launchedCube);
            CubeOfAnnihilationItem.setThrownEntity(stack, launchedCube);
        }
        player.m_6672_(hand);
        return new InteractionResultHolder(InteractionResult.SUCCESS, (Object)stack);
    }

    @Nullable
    public static UUID getThrownUuid(ItemStack stack) {
        if (stack.m_41782_() && stack.m_41783_().m_128403_(THROWN_UUID_KEY)) {
            return stack.m_41783_().m_128342_(THROWN_UUID_KEY);
        }
        return null;
    }

    @Nullable
    private static CubeOfAnnihilation getThrownEntity(Level level, ItemStack stack) {
        if (level instanceof ServerLevel) {
            Entity e;
            ServerLevel server = (ServerLevel)level;
            UUID id = CubeOfAnnihilationItem.getThrownUuid(stack);
            if (id != null && (e = server.m_8791_(id)) instanceof CubeOfAnnihilation) {
                return (CubeOfAnnihilation)e;
            }
        }
        return null;
    }

    private static void setThrownEntity(ItemStack stack, CubeOfAnnihilation cube) {
        if (!stack.m_41782_()) {
            stack.m_41751_(new CompoundTag());
        }
        stack.m_41783_().m_128362_(THROWN_UUID_KEY, cube.m_20148_());
    }

    public int m_8105_(ItemStack stack) {
        return 72000;
    }

    public UseAnim m_6164_(ItemStack stack) {
        return UseAnim.BLOCK;
    }

    public boolean canDisableShield(ItemStack stack, ItemStack shield, LivingEntity entity, LivingEntity attacker) {
        return true;
    }
}

