/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.events;

import com.mojang.authlib.GameProfile;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.ItemTags;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.EntityDamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractHurtingProjectile;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.AbstractSkullBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SkullBlock;
import net.minecraft.world.level.block.WallSkullBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.SkullBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.entity.ProjectileImpactEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.level.BlockEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.registries.ForgeRegistries;
import twilightforest.TFConfig;
import twilightforest.block.AbstractLightableBlock;
import twilightforest.block.AbstractSkullCandleBlock;
import twilightforest.block.SkullCandleBlock;
import twilightforest.block.WallSkullCandleBlock;
import twilightforest.block.entity.KeepsakeCasketBlockEntity;
import twilightforest.block.entity.SkullCandleBlockEntity;
import twilightforest.entity.projectile.ITFProjectile;
import twilightforest.init.TFBlocks;
import twilightforest.init.TFItems;
import twilightforest.init.TFMobEffects;
import twilightforest.init.TFStats;
import twilightforest.item.FieryArmorItem;
import twilightforest.item.YetiArmorItem;

@Mod.EventBusSubscriber(modid="twilightforest")
public class EntityEvents {
    private static final boolean SHIELD_PARRY_MOD_LOADED = ModList.get().isLoaded("parry");

    @SubscribeEvent
    public static void entityHurts(LivingHurtEvent event) {
        Player player;
        LivingEntity living = event.getEntity();
        DamageSource source = event.getSource();
        Entity trueSource = source.m_7639_();
        if (source instanceof EntityDamageSource && trueSource != null && event.getAmount() > 0.0f) {
            int fireLevel = EntityEvents.getGearCoverage(living, false) * 5;
            int chillLevel = EntityEvents.getGearCoverage(living, true);
            if (fireLevel > 0 && living.m_217043_().m_188503_(25) < fireLevel) {
                trueSource.m_20254_(fireLevel / 2);
            }
            if (chillLevel > 0 && trueSource instanceof LivingEntity) {
                LivingEntity target = (LivingEntity)trueSource;
                target.m_7292_(new MobEffectInstance((MobEffect)TFMobEffects.FROSTY.get(), chillLevel * 5 + 5, chillLevel));
            }
        }
        if (source.m_19385_().equals("arrow") && trueSource instanceof Player && (player = (Player)trueSource).m_21120_(player.m_7655_()).m_150930_((Item)TFItems.TRIPLE_BOW.get())) {
            living.f_19802_ = 0;
        }
    }

    @SubscribeEvent
    public static void onCasketBreak(BlockEvent.BreakEvent event) {
        Block block = event.getState().m_60734_();
        Player player = event.getPlayer();
        BlockEntity te = event.getLevel().m_7702_(event.getPos());
        if (block == TFBlocks.KEEPSAKE_CASKET.get()) {
            UUID checker;
            if (te instanceof KeepsakeCasketBlockEntity) {
                KeepsakeCasketBlockEntity casket = (KeepsakeCasketBlockEntity)te;
                checker = casket.playeruuid;
            } else {
                checker = null;
            }
            if (!(checker == null || ((KeepsakeCasketBlockEntity)te).m_7983_() || player.m_20310_(3) && player.m_36316_().getId().equals(checker))) {
                event.setCanceled(true);
            }
        }
    }

    @SubscribeEvent
    public static void onCrafting(PlayerEvent.ItemCraftedEvent event) {
        ItemStack itemStack = event.getCrafting();
        if (itemStack.m_150930_(Items.f_42647_) && itemStack.m_41613_() == 64 && event.getInventory().m_18947_(((Block)TFBlocks.GIANT_LOG.get()).m_5456_()) > 0) {
            Player player = event.getEntity();
            ItemHandlerHelper.giveItemToPlayer((Player)player, (ItemStack)new ItemStack((ItemLike)Items.f_42647_, 64));
            ItemHandlerHelper.giveItemToPlayer((Player)player, (ItemStack)new ItemStack((ItemLike)Items.f_42647_, 64));
            ItemHandlerHelper.giveItemToPlayer((Player)player, (ItemStack)new ItemStack((ItemLike)Items.f_42647_, 64));
        }
    }

    @SubscribeEvent
    public static void onParryProjectile(ProjectileImpactEvent event) {
        HitResult hitResult;
        Projectile projectile = event.getProjectile();
        if (!projectile.m_20193_().m_5776_() && !SHIELD_PARRY_MOD_LOADED && (((Boolean)TFConfig.COMMON_CONFIG.SHIELD_INTERACTIONS.parryNonTwilightAttacks.get()).booleanValue() || projectile instanceof ITFProjectile) && (hitResult = event.getRayTraceResult()) instanceof EntityHitResult) {
            LivingEntity entityBlocking;
            EntityHitResult result = (EntityHitResult)hitResult;
            Entity entity = result.m_82443_();
            if (event.getEntity() != null && entity instanceof LivingEntity && (entityBlocking = (LivingEntity)entity).m_21254_() && entityBlocking.m_21211_().m_41779_() - entityBlocking.m_21212_() <= (Integer)TFConfig.COMMON_CONFIG.SHIELD_INTERACTIONS.shieldParryTicks.get()) {
                projectile.m_5602_((Entity)entityBlocking);
                Vec3 rebound = entityBlocking.m_20154_();
                projectile.m_6686_(rebound.m_7096_(), rebound.m_7098_(), rebound.m_7094_(), 1.1f, 0.1f);
                if (projectile instanceof AbstractHurtingProjectile) {
                    AbstractHurtingProjectile hurting = (AbstractHurtingProjectile)projectile;
                    hurting.f_36813_ = rebound.m_7096_() * 0.1;
                    hurting.f_36814_ = rebound.m_7098_() * 0.1;
                    hurting.f_36815_ = rebound.m_7094_() * 0.1;
                }
                event.setCanceled(true);
            }
        }
    }

    @SubscribeEvent
    public static void createSkullCandle(PlayerInteractEvent.RightClickBlock event) {
        Block block;
        ItemStack stack = event.getItemStack();
        Level level = event.getLevel();
        BlockPos pos = event.getPos();
        BlockState state = level.m_8055_(pos);
        if (!((Boolean)TFConfig.COMMON_CONFIG.disableSkullCandles.get()).booleanValue() && stack.m_204117_(ItemTags.f_144319_) && ForgeRegistries.ITEMS.getKey((Object)stack.m_41720_()).m_135827_().equals("minecraft") && !event.getEntity().m_6144_() && (block = state.m_60734_()) instanceof AbstractSkullBlock) {
            AbstractSkullBlock skull = (AbstractSkullBlock)block;
            if (ForgeRegistries.BLOCKS.getKey((Object)state.m_60734_()).m_135827_().equals("minecraft")) {
                SkullBlock.Types type = (SkullBlock.Types)skull.m_48754_();
                boolean wall = state.m_60734_() instanceof WallSkullBlock;
                switch (type) {
                    case SKELETON: {
                        if (wall) {
                            EntityEvents.makeWallSkull(event, (Block)TFBlocks.SKELETON_WALL_SKULL_CANDLE.get());
                            break;
                        }
                        EntityEvents.makeFloorSkull(event, (Block)TFBlocks.SKELETON_SKULL_CANDLE.get());
                        break;
                    }
                    case WITHER_SKELETON: {
                        if (wall) {
                            EntityEvents.makeWallSkull(event, (Block)TFBlocks.WITHER_SKELE_WALL_SKULL_CANDLE.get());
                            break;
                        }
                        EntityEvents.makeFloorSkull(event, (Block)TFBlocks.WITHER_SKELE_SKULL_CANDLE.get());
                        break;
                    }
                    case PLAYER: {
                        if (wall) {
                            EntityEvents.makeWallSkull(event, (Block)TFBlocks.PLAYER_WALL_SKULL_CANDLE.get());
                            break;
                        }
                        EntityEvents.makeFloorSkull(event, (Block)TFBlocks.PLAYER_SKULL_CANDLE.get());
                        break;
                    }
                    case ZOMBIE: {
                        if (wall) {
                            EntityEvents.makeWallSkull(event, (Block)TFBlocks.ZOMBIE_WALL_SKULL_CANDLE.get());
                            break;
                        }
                        EntityEvents.makeFloorSkull(event, (Block)TFBlocks.ZOMBIE_SKULL_CANDLE.get());
                        break;
                    }
                    case CREEPER: {
                        if (wall) {
                            EntityEvents.makeWallSkull(event, (Block)TFBlocks.CREEPER_WALL_SKULL_CANDLE.get());
                            break;
                        }
                        EntityEvents.makeFloorSkull(event, (Block)TFBlocks.CREEPER_SKULL_CANDLE.get());
                        break;
                    }
                    default: {
                        return;
                    }
                }
                if (!event.getEntity().m_150110_().f_35937_) {
                    stack.m_41774_(1);
                }
                event.getEntity().m_6674_(event.getHand());
                if (event.getEntity() instanceof ServerPlayer) {
                    event.getEntity().m_36220_((ResourceLocation)TFStats.SKULL_CANDLES_MADE.get());
                }
                event.setCanceled(true);
            }
        }
    }

    private static void makeFloorSkull(PlayerInteractEvent.RightClickBlock event, Block newBlock) {
        GameProfile profile = null;
        Level level = event.getLevel();
        BlockEntity blockEntity = level.m_7702_(event.getPos());
        if (blockEntity instanceof SkullBlockEntity) {
            SkullBlockEntity skull = (SkullBlockEntity)blockEntity;
            profile = skull.m_59779_();
        }
        level.m_5594_(null, event.getPos(), SoundEvents.f_144101_, SoundSource.BLOCKS, 1.0f, 1.0f);
        level.m_46597_(event.getPos(), (BlockState)((BlockState)newBlock.m_49966_().m_61124_((Property)AbstractSkullCandleBlock.LIGHTING, (Comparable)((Object)AbstractLightableBlock.Lighting.NONE))).m_61124_((Property)SkullCandleBlock.ROTATION, (Comparable)((Integer)level.m_8055_(event.getPos()).m_61143_((Property)SkullBlock.f_56314_))));
        level.m_151523_((BlockEntity)new SkullCandleBlockEntity(event.getPos(), (BlockState)((BlockState)newBlock.m_49966_().m_61124_((Property)AbstractSkullCandleBlock.LIGHTING, (Comparable)((Object)AbstractLightableBlock.Lighting.NONE))).m_61124_((Property)SkullCandleBlock.ROTATION, (Comparable)((Integer)level.m_8055_(event.getPos()).m_61143_((Property)SkullBlock.f_56314_))), AbstractSkullCandleBlock.candleToCandleColor(event.getItemStack().m_41720_()).getValue(), 1));
        blockEntity = level.m_7702_(event.getPos());
        if (blockEntity instanceof SkullCandleBlockEntity) {
            SkullCandleBlockEntity sc = (SkullCandleBlockEntity)blockEntity;
            sc.m_59769_(profile);
        }
    }

    private static void makeWallSkull(PlayerInteractEvent.RightClickBlock event, Block newBlock) {
        GameProfile profile = null;
        Level level = event.getLevel();
        BlockEntity blockEntity = level.m_7702_(event.getPos());
        if (blockEntity instanceof SkullBlockEntity) {
            SkullBlockEntity skull = (SkullBlockEntity)blockEntity;
            profile = skull.m_59779_();
        }
        level.m_5594_(null, event.getPos(), SoundEvents.f_144101_, SoundSource.BLOCKS, 1.0f, 1.0f);
        level.m_46597_(event.getPos(), (BlockState)((BlockState)newBlock.m_49966_().m_61124_((Property)AbstractSkullCandleBlock.LIGHTING, (Comparable)((Object)AbstractLightableBlock.Lighting.NONE))).m_61124_((Property)WallSkullCandleBlock.FACING, (Comparable)((Direction)level.m_8055_(event.getPos()).m_61143_((Property)WallSkullBlock.f_58097_))));
        level.m_151523_((BlockEntity)new SkullCandleBlockEntity(event.getPos(), (BlockState)((BlockState)newBlock.m_49966_().m_61124_((Property)AbstractSkullCandleBlock.LIGHTING, (Comparable)((Object)AbstractLightableBlock.Lighting.NONE))).m_61124_((Property)WallSkullCandleBlock.FACING, (Comparable)((Direction)level.m_8055_(event.getPos()).m_61143_((Property)WallSkullBlock.f_58097_))), AbstractSkullCandleBlock.candleToCandleColor(event.getItemStack().m_41720_()).getValue(), 1));
        blockEntity = level.m_7702_(event.getPos());
        if (blockEntity instanceof SkullCandleBlockEntity) {
            SkullCandleBlockEntity sc = (SkullCandleBlockEntity)blockEntity;
            sc.m_59769_(profile);
        }
    }

    public static int getGearCoverage(LivingEntity entity, boolean yeti) {
        int amount = 0;
        for (ItemStack armor : entity.m_6168_()) {
            if (armor.m_41619_() || !(yeti ? armor.m_41720_() instanceof YetiArmorItem : armor.m_41720_() instanceof FieryArmorItem)) continue;
            ++amount;
        }
        return amount;
    }
}

