/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.command;

import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.util.Mth;
import net.minecraft.world.level.WorldGenLevel;
import twilightforest.command.TFCommand;
import twilightforest.init.TFLandmark;
import twilightforest.util.LegacyLandmarkPlacements;
import twilightforest.world.registration.TFGenerationSettings;

public class CenterCommand {
    public static LiteralArgumentBuilder<CommandSourceStack> register() {
        return (LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"center").requires(cs -> cs.m_6761_(2))).executes(CenterCommand::run);
    }

    private static int run(CommandContext<CommandSourceStack> ctx) throws CommandSyntaxException {
        CommandSourceStack source = (CommandSourceStack)ctx.getSource();
        if (!TFGenerationSettings.usesTwilightChunkGenerator(source.m_81372_())) {
            throw TFCommand.NOT_IN_TF.create();
        }
        int dx = Mth.m_14107_((double)source.m_81371_().m_7096_());
        int dz = Mth.m_14107_((double)source.m_81371_().m_7094_());
        BlockPos cc = LegacyLandmarkPlacements.getNearestCenterXZ(dx >> 4, dz >> 4);
        TFLandmark closestFeature = LegacyLandmarkPlacements.pickLandmarkAtBlock(cc.m_123341_(), cc.m_123343_(), (WorldGenLevel)source.m_81372_());
        boolean fc = LegacyLandmarkPlacements.blockIsInLandmarkCenter(dx, dz);
        if (closestFeature == TFLandmark.NOTHING) {
            source.m_81354_((Component)Component.m_237115_((String)"commands.tffeature.none_nearby").m_130940_(ChatFormatting.RED), false);
        } else {
            String structurename = Component.m_237115_((String)("structure." + closestFeature.name)).m_130940_(ChatFormatting.DARK_GREEN).getString();
            source.m_81354_((Component)Component.m_237110_((String)"commands.tffeature.nearest", (Object[])new Object[]{structurename}), false);
            source.m_81354_((Component)Component.m_237110_((String)"commands.tffeature.center", (Object[])new Object[]{cc}), false);
            source.m_81354_((Component)Component.m_237110_((String)"commands.tffeature.chunk", (Object[])new Object[]{fc}), false);
        }
        return 1;
    }
}

