/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.particle;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.math.Quaternion;
import com.mojang.math.Vector3f;
import java.util.Arrays;
import java.util.function.Supplier;
import net.minecraft.client.Camera;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import ovh.corail.tombstone.compatibility.CompatibilityOculus;
import ovh.corail.tombstone.helper.Helper;
import ovh.corail.tombstone.registry.ClientModEvents;

@OnlyIn(value=Dist.CLIENT)
abstract class CustomParticle
extends Particle {
    protected static final float DEFAULT_ROLL = 0.31415927f;
    protected float rollIncrement = 0.0f;
    protected float quadSize = 0.2f;
    private boolean isSolid = false;
    private Supplier<Float> alphaSupplier = null;
    private Runnable colorSetter = null;
    private static final ParticleRenderType CUSTOM_SOLID = new ParticleRenderType(){

        public void m_6505_(BufferBuilder builder, TextureManager textureManager) {
            RenderSystem.m_157427_(GameRenderer::m_172829_);
            RenderSystem.m_69458_((boolean)true);
            RenderSystem.m_69461_();
        }

        public void m_6294_(Tesselator tesselator) {
        }
    };
    private static final ParticleRenderType CUSTOM_ALPHA = new ParticleRenderType(){

        public void m_6505_(BufferBuilder builder, TextureManager textureManager) {
            ALPHA_STATE.run();
        }

        public void m_6294_(Tesselator tesselator) {
        }
    };
    protected static final Runnable ALPHA_STATE = () -> {
        RenderSystem.m_157427_(CompatibilityOculus.instance.isShaderEnabled() ? GameRenderer::m_172829_ : ClientModEvents::getLowAlphaShader);
        RenderSystem.m_69458_((boolean)false);
        RenderSystem.m_69478_();
        RenderSystem.m_69408_((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
    };

    CustomParticle(ClientLevel level, Vec3 vec) {
        this(level, vec.f_82479_, vec.f_82480_, vec.f_82481_);
    }

    CustomParticle(ClientLevel level, double x, double y, double z) {
        this(level, x, y, z, 0.0, 0.0, 0.0);
    }

    CustomParticle(ClientLevel level, double x, double y, double z, double mX, double mY, double mZ) {
        super(level, x, y, z);
        this.f_107215_ = mX;
        this.f_107216_ = mY;
        this.f_107217_ = mZ;
        this.f_107219_ = false;
    }

    protected boolean requireRemoval() {
        return this.f_107224_ >= this.f_107225_;
    }

    public void m_5989_() {
        if (this.requireRemoval()) {
            this.m_107274_();
        } else {
            ++this.f_107224_;
            this.updateLastPos();
            this.updatePosition();
            this.update();
        }
    }

    public Particle m_6569_(float scale) {
        this.quadSize *= scale;
        this.m_107250_(this.quadSize, this.quadSize);
        return this;
    }

    protected abstract ResourceLocation getTexture();

    protected void updatePosition() {
        if (this.f_107215_ != 0.0 || this.f_107216_ != 0.0 || this.f_107217_ != 0.0) {
            this.m_107259_(this.m_107277_().m_82386_(this.f_107215_, this.f_107216_, this.f_107217_));
            this.m_107275_();
        }
    }

    protected void update() {
        if (this.rollIncrement > 0.0f) {
            this.f_107204_ = this.f_107231_;
            this.f_107231_ += this.rollIncrement;
        }
        if (this.colorSetter != null) {
            this.colorSetter.run();
        }
        if (this.alphaSupplier != null) {
            this.f_107230_ = this.alphaSupplier.get().floatValue();
        }
    }

    protected void updateLastPos() {
        this.f_107209_ = this.f_107212_;
        this.f_107210_ = this.f_107213_;
        this.f_107211_ = this.f_107214_;
    }

    public CustomParticle withColor(int color) {
        float[] colors = Helper.getRGBColor3F(color);
        this.m_107253_(colors[0], colors[1], colors[2]);
        return this;
    }

    public CustomParticle withColor(Supplier<Float> func) {
        this.colorSetter = () -> {
            float color = ((Float)func.get()).floatValue();
            this.m_107253_(color, color, color);
        };
        return this;
    }

    public void setSolid(boolean isSolid) {
        this.isSolid = isSolid;
    }

    public void setRolling(float rollIncrement) {
        this.setRolling((float)Math.PI * 2 * Helper.RANDOM.nextFloat(), rollIncrement);
    }

    public void setRolling(float rollStart, float rollIncrement) {
        if (rollIncrement != 0.0f) {
            this.f_107231_ = rollStart;
            this.rollIncrement = rollIncrement;
            this.f_107204_ = this.f_107231_ - this.rollIncrement;
        } else {
            this.f_107231_ = this.f_107204_ = rollStart;
            this.rollIncrement = 0.0f;
        }
    }

    public void m_107271_(float alpha) {
        this.alphaSupplier = null;
        this.f_107230_ = alpha;
    }

    public void setAlpha(Supplier<Float> alphaSupplier) {
        this.alphaSupplier = alphaSupplier;
        this.f_107230_ = alphaSupplier.get().floatValue();
    }

    protected float getU0() {
        return 0.0f;
    }

    protected float getU1() {
        return 1.0f;
    }

    protected float getV0() {
        return 0.0f;
    }

    protected float getV1() {
        return 1.0f;
    }

    public ParticleRenderType m_7556_() {
        return this.isSolid ? CUSTOM_SOLID : CUSTOM_ALPHA;
    }

    protected int m_6355_(float partialTick) {
        return 0xF000F0;
    }

    public boolean shouldCull() {
        return true;
    }

    public void m_5744_(VertexConsumer buffer, Camera renderInfo, float partialTicks) {
        this.beginRender();
        Vec3 vecFromCamera = new Vec3(Mth.m_14139_((double)partialTicks, (double)this.f_107209_, (double)this.f_107212_), Mth.m_14139_((double)partialTicks, (double)this.f_107210_, (double)this.f_107213_), Mth.m_14139_((double)partialTicks, (double)this.f_107211_, (double)this.f_107214_)).m_82546_(renderInfo.m_90583_());
        int light = this.m_6355_(partialTicks);
        Quaternion rollTransform = this.getRollQuaternion(renderInfo, partialTicks);
        Vector3f[] vecFaceQuad = this.getFaceQuad();
        Arrays.stream(vecFaceQuad).forEach(v -> {
            v.m_122251_(rollTransform);
            v.m_122261_(this.quadSize);
            v.m_122272_((float)vecFromCamera.f_82479_, (float)vecFromCamera.f_82480_, (float)vecFromCamera.f_82481_);
        });
        this.addQuad(buffer, vecFaceQuad, light);
        this.endRender();
    }

    protected void beginRender() {
        RenderSystem.m_157456_((int)0, (ResourceLocation)this.getTexture());
        Tesselator.m_85913_().m_85915_().m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85813_);
    }

    protected void endRender() {
        Tesselator.m_85913_().m_85914_();
    }

    protected Quaternion getRollQuaternion(Camera renderInfo, float partialTicks) {
        if (this.f_107231_ == 0.0f) {
            return renderInfo.m_90591_();
        }
        Quaternion rollTransform = new Quaternion(renderInfo.m_90591_());
        rollTransform.m_80148_(Vector3f.f_122227_.m_122270_(Mth.m_14179_((float)partialTicks, (float)this.f_107204_, (float)this.f_107231_)));
        return rollTransform;
    }

    protected Vector3f[] getFaceQuad() {
        return new Vector3f[]{new Vector3f(-1.0f, -1.0f, 0.0f), new Vector3f(-1.0f, 1.0f, 0.0f), new Vector3f(1.0f, 1.0f, 0.0f), new Vector3f(1.0f, -1.0f, 0.0f)};
    }

    protected void addQuad(VertexConsumer buffer, Vector3f[] points, int light) {
        buffer.m_5483_((double)points[0].m_122239_(), (double)points[0].m_122260_(), (double)points[0].m_122269_()).m_7421_(this.getU1(), this.getV1()).m_85950_(this.f_107227_, this.f_107228_, this.f_107229_, this.f_107230_).m_85969_(light).m_5752_();
        buffer.m_5483_((double)points[1].m_122239_(), (double)points[1].m_122260_(), (double)points[1].m_122269_()).m_7421_(this.getU1(), this.getV0()).m_85950_(this.f_107227_, this.f_107228_, this.f_107229_, this.f_107230_).m_85969_(light).m_5752_();
        buffer.m_5483_((double)points[2].m_122239_(), (double)points[2].m_122260_(), (double)points[2].m_122269_()).m_7421_(this.getU0(), this.getV0()).m_85950_(this.f_107227_, this.f_107228_, this.f_107229_, this.f_107230_).m_85969_(light).m_5752_();
        buffer.m_5483_((double)points[3].m_122239_(), (double)points[3].m_122260_(), (double)points[3].m_122269_()).m_7421_(this.getU0(), this.getV1()).m_85950_(this.f_107227_, this.f_107228_, this.f_107229_, this.f_107230_).m_85969_(light).m_5752_();
    }
}

