/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.capability;

import java.util.Optional;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.Nullable;
import ovh.corail.tombstone.api.capability.ISpellCaster;
import ovh.corail.tombstone.network.CMessageSpellCasting;
import ovh.corail.tombstone.network.PacketHandler;

public class SpellCasterImpl
implements ISpellCaster {
    protected int castingTime = 0;
    protected int castingColor = -1;
    protected int spellCooldown = 0;
    protected Entity specialTarget = null;

    @Override
    public boolean isCasting() {
        return this.castingColor > -1;
    }

    @Override
    public void startCasting(Mob caster, int castingTime, int castingColor) {
        this.castingTime = castingTime;
        this.castingColor = castingColor;
        PacketHandler.sendToAllTrackingPlayers(new CMessageSpellCasting(caster.m_19879_(), this.castingColor), (LivingEntity)caster);
        caster.m_5496_(this.getCastingSoundEvent(), 1.0f, 1.0f);
    }

    @Override
    public void stopCasting(Mob caster) {
        this.castingTime = 0;
        this.castingColor = -1;
        this.specialTarget = null;
        this.setSpellCooldown();
        PacketHandler.sendToAllTrackingPlayers(new CMessageSpellCasting(caster.m_19879_(), this.castingColor), (LivingEntity)caster);
    }

    @Override
    public int getCastingColor() {
        return this.castingColor;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void setCastingColor(int castingColor) {
        this.castingColor = castingColor;
    }

    @Override
    public boolean hasSpellCooldown() {
        return this.spellCooldown > 0;
    }

    @Override
    public void setSpellCooldown() {
        this.spellCooldown = 60;
    }

    @Override
    public Optional<Entity> getSpecialTarget() {
        return Optional.ofNullable(this.specialTarget);
    }

    @Override
    public void setSpecialTarget(@Nullable Entity specialTarget) {
        this.specialTarget = specialTarget;
    }

    @Override
    public void tick(Mob caster) {
        if (!caster.f_19853_.m_5776_()) {
            if (this.spellCooldown > 0) {
                --this.spellCooldown;
            } else if (this.castingTime > 0 && --this.castingTime == 0) {
                this.stopCasting(caster);
            }
        }
    }

    @Override
    public SoundEvent getCastingSoundEvent() {
        return SoundEvents.f_11862_;
    }
}

