/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.theurgy.item;

import com.google.common.collect.ImmutableList;
import com.klikli_dev.theurgy.Theurgy;
import com.klikli_dev.theurgy.client.render.SulfurBEWLR;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.BlockEntityWithoutLevelRenderer;
import net.minecraft.core.NonNullList;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentUtils;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.extensions.common.IClientItemExtensions;
import net.minecraftforge.fml.loading.FMLEnvironment;
import net.minecraftforge.registries.ForgeRegistries;

public class AlchemicalSulfurItem
extends Item {
    public AlchemicalSulfurItem(Item.Properties pProperties) {
        super(pProperties);
    }

    public static ItemStack getSourceStack(ItemStack sulfurStack) {
        if (sulfurStack.m_41782_() && sulfurStack.m_41783_().m_128441_("theurgy:sulfur.source.id")) {
            ResourceLocation itemId = new ResourceLocation(sulfurStack.m_41783_().m_128461_("theurgy:sulfur.source.id"));
            ItemStack sourceStack = new ItemStack((ItemLike)ForgeRegistries.ITEMS.getValue(itemId));
            if (sulfurStack.m_41783_().m_128441_("theurgy:sulfur.source.nbt")) {
                sourceStack.m_41751_(sulfurStack.m_41783_().m_128469_("theurgy:sulfur.source.nbt"));
            }
            return sourceStack;
        }
        return ItemStack.f_41583_;
    }

    public static List<MutableComponent> getTooltipData(ItemStack sulfurStack) {
        Component component;
        ItemStack source = AlchemicalSulfurItem.getSourceStack(sulfurStack);
        if (!source.m_41619_() && (component = source.m_41786_()) instanceof MutableComponent) {
            MutableComponent hoverName = (MutableComponent)component;
            return ImmutableList.of((Object)hoverName.m_130948_(Style.f_131099_.m_131140_(ChatFormatting.GREEN).m_131155_(Boolean.valueOf(true))));
        }
        return ImmutableList.of();
    }

    public void initializeClient(Consumer<IClientItemExtensions> consumer) {
        consumer.accept(new IClientItemExtensions(){

            public BlockEntityWithoutLevelRenderer getCustomRenderer() {
                return SulfurBEWLR.get();
            }
        });
    }

    public Component m_7626_(ItemStack pStack) {
        Component component;
        ItemStack source = AlchemicalSulfurItem.getSourceStack(pStack);
        if (!source.m_41619_() && (component = source.m_41786_()) instanceof MutableComponent) {
            MutableComponent hoverName = (MutableComponent)component;
            return Component.m_237110_((String)this.m_5524_(), (Object[])new Object[]{ComponentUtils.m_130748_((Component)hoverName.m_130948_(Style.f_131099_.m_131140_(ChatFormatting.GREEN).m_131155_(Boolean.valueOf(true))))});
        }
        return super.m_7626_(pStack);
    }

    public void m_6787_(CreativeModeTab tab, NonNullList<ItemStack> items) {
        if (FMLEnvironment.dist == Dist.CLIENT) {
            DistHelper.fillItemCategory(this, tab, items);
        }
    }

    public static class DistHelper {
        public static void fillItemCategory(AlchemicalSulfurItem item, CreativeModeTab tab, NonNullList<ItemStack> items) {
            if (tab != Theurgy.CREATIVE_MODE_TAB && tab != CreativeModeTab.f_40754_) {
                return;
            }
            ClientLevel level = Minecraft.m_91087_().f_91073_;
            if (level != null) {
                RecipeManager recipeManager = level.m_7465_();
                recipeManager.m_44051_().forEach(recipe -> {
                    if (recipe.m_8043_() != null && recipe.m_8043_().m_41720_() == item) {
                        items.add((Object)recipe.m_8043_().m_41777_());
                    }
                });
            }
        }
    }
}

