/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermal.locomotion.item;

import cofh.core.entity.AbstractMinecartCoFH;
import cofh.core.item.MinecartItemCoFH;
import cofh.core.util.ProxyUtils;
import cofh.core.util.helpers.AugmentDataHelper;
import cofh.core.util.helpers.AugmentableHelper;
import cofh.core.util.helpers.FluidHelper;
import cofh.lib.api.ContainerType;
import cofh.lib.api.item.IColorableItem;
import cofh.lib.api.item.IFluidContainerItem;
import cofh.lib.fluid.FluidStorageCoFH;
import cofh.lib.util.helpers.StringHelper;
import cofh.thermal.locomotion.entity.FluidMinecart;
import cofh.thermal.locomotion.item.AugmentableMinecartItem;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;

public class FluidMinecartItem
extends AugmentableMinecartItem
implements IFluidContainerItem,
IColorableItem {
    public FluidMinecartItem(Item.Properties builder) {
        super((MinecartItemCoFH.IMinecartFactory<? extends AbstractMinecartCoFH>)((MinecartItemCoFH.IMinecartFactory)FluidMinecart::new), builder);
        this.setEnchantability(10);
        ProxyUtils.registerColorable((Item)this);
    }

    protected void tooltipDelegate(ItemStack stack, @Nullable Level worldIn, List<Component> tooltip, TooltipFlag flagIn) {
        FluidStack fluid = this.getFluid(stack);
        if (!fluid.isEmpty()) {
            tooltip.add((Component)StringHelper.getFluidName((FluidStack)fluid));
        }
        tooltip.add((Component)(this.isCreative(stack, ContainerType.FLUID) ? StringHelper.getTextComponent((String)"info.cofh.infinite").m_130940_(ChatFormatting.LIGHT_PURPLE).m_130940_(ChatFormatting.ITALIC) : StringHelper.getTextComponent((String)(StringHelper.localize((String)"info.cofh.amount") + ": " + StringHelper.format((long)fluid.getAmount()) + " / " + StringHelper.format((long)this.getCapacity(stack)) + " " + StringHelper.localize((String)"info.cofh.unit_mb")))));
        if (FluidHelper.hasPotionTag((FluidStack)fluid)) {
            tooltip.add((Component)StringHelper.getEmptyLine());
            tooltip.add((Component)StringHelper.getTextComponent((String)(StringHelper.localize((String)"info.cofh.effects") + ":")));
            FluidHelper.addPotionTooltip((FluidStack)fluid, tooltip);
        }
    }

    protected void setAttributesFromAugment(ItemStack container, CompoundTag augmentData) {
        CompoundTag subTag = container.m_41737_("Properties");
        if (subTag == null) {
            return;
        }
        AugmentableHelper.setAttributeFromAugmentMax((CompoundTag)subTag, (CompoundTag)augmentData, (String)"BaseMod");
        AugmentableHelper.setAttributeFromAugmentMax((CompoundTag)subTag, (CompoundTag)augmentData, (String)"FluidMax");
        AugmentableHelper.setAttributeFromAugmentMax((CompoundTag)subTag, (CompoundTag)augmentData, (String)"FluidCre");
    }

    public CompoundTag getOrCreateTankTag(ItemStack container) {
        CompoundTag tag = container.m_41784_();
        if (!tag.m_128441_("Capacity")) {
            new FluidStorageCoFH(32000).write(tag);
        }
        return container.m_41783_();
    }

    public FluidStack getFluid(ItemStack container) {
        CompoundTag tag = this.getOrCreateTankTag(container);
        return FluidStack.loadFluidStackFromNBT((CompoundTag)tag);
    }

    public int getCapacity(ItemStack container) {
        CompoundTag tag = this.getOrCreateTankTag(container);
        float base = AugmentableHelper.getPropertyWithDefault((ItemStack)container, (String)"BaseMod", (float)1.0f);
        float mod = AugmentableHelper.getPropertyWithDefault((ItemStack)container, (String)"FluidMax", (float)1.0f);
        return this.getMaxStored(container, Math.round((float)tag.m_128451_("Capacity") * mod * base));
    }

    @Override
    public void updateAugmentState(ItemStack container, List<ItemStack> augments) {
        container.m_41784_().m_128365_("Properties", (Tag)new CompoundTag());
        for (ItemStack augment : augments) {
            CompoundTag augmentData = AugmentDataHelper.getAugmentData((ItemStack)augment);
            if (augmentData == null) continue;
            this.setAttributesFromAugment(container, augmentData);
        }
        int fluidExcess = this.getFluidAmount(container) - this.getCapacity(container);
        if (fluidExcess > 0) {
            this.drain(container, fluidExcess, IFluidHandler.FluidAction.EXECUTE);
        }
    }

    public int getColor(ItemStack item, int colorIndex) {
        if (colorIndex == 1) {
            return this.getFluidAmount(item) > 0 ? FluidHelper.color((FluidStack)this.getFluid(item)) : 0xFFFFFF;
        }
        return 0xFFFFFF;
    }
}

