/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermal.locomotion.client.renderer.entity;

import cofh.core.util.helpers.FluidHelper;
import cofh.core.util.helpers.RenderHelper;
import cofh.lib.util.helpers.MathHelper;
import cofh.thermal.locomotion.client.renderer.entity.model.FluidMinecartModel;
import cofh.thermal.locomotion.entity.FluidMinecart;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Vector3f;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.fluids.FluidStack;

public class FluidMinecartRenderer
extends EntityRenderer<FluidMinecart> {
    public static final ResourceLocation TEXTURE = new ResourceLocation("thermal:textures/entity/fluid_minecart.png");
    protected final EntityModel<FluidMinecart> model;
    protected final AABB storageAABB = new AABB(-0.59375, -0.40625, -0.46875, 0.59375, 0.21875, 0.46875);

    public FluidMinecartRenderer(EntityRendererProvider.Context ctx) {
        super(ctx);
        this.f_114477_ = 0.7f;
        this.model = new FluidMinecartModel(ctx.m_174027_().m_171103_(FluidMinecartModel.FLUID_MINECART_LAYER));
    }

    public void render(FluidMinecart entityIn, float entityYaw, float partialTicks, PoseStack poseStackIn, MultiBufferSource bufferIn, int packedLightIn) {
        super.m_7392_((Entity)entityIn, entityYaw, partialTicks, poseStackIn, bufferIn, packedLightIn);
        poseStackIn.m_85836_();
        long i = (long)entityIn.m_19879_() * 493286711L;
        i = i * i * 4392167121L + i * 98761L;
        float f = (((float)(i >> 16 & 7L) + 0.5f) / 8.0f - 0.5f) * 0.004f;
        float f1 = (((float)(i >> 20 & 7L) + 0.5f) / 8.0f - 0.5f) * 0.004f;
        float f2 = (((float)(i >> 24 & 7L) + 0.5f) / 8.0f - 0.5f) * 0.004f;
        poseStackIn.m_85837_((double)f, (double)f1, (double)f2);
        double d0 = Mth.m_14139_((double)partialTicks, (double)entityIn.f_19790_, (double)entityIn.m_20185_());
        double d1 = Mth.m_14139_((double)partialTicks, (double)entityIn.f_19791_, (double)entityIn.m_20186_());
        double d2 = Mth.m_14139_((double)partialTicks, (double)entityIn.f_19792_, (double)entityIn.m_20189_());
        Vec3 vec3 = entityIn.m_38179_(d0, d1, d2);
        float f3 = Mth.m_14179_((float)partialTicks, (float)entityIn.f_19860_, (float)entityIn.f_19858_);
        if (vec3 != null) {
            Vec3 vec31 = entityIn.m_38096_(d0, d1, d2, 0.3f);
            Vec3 vec32 = entityIn.m_38096_(d0, d1, d2, -0.3f);
            if (vec31 == null) {
                vec31 = vec3;
            }
            if (vec32 == null) {
                vec32 = vec3;
            }
            poseStackIn.m_85837_(vec3.f_82479_ - d0, (vec31.f_82480_ + vec32.f_82480_) / 2.0 - d1, vec3.f_82481_ - d2);
            Vec3 vec33 = vec32.m_82520_(-vec31.f_82479_, -vec31.f_82480_, -vec31.f_82481_);
            if (vec33.m_82553_() != 0.0) {
                vec33 = vec33.m_82541_();
                entityYaw = (float)(Math.atan2(vec33.f_82481_, vec33.f_82479_) * 180.0 / Math.PI);
                f3 = (float)(Math.atan(vec33.f_82480_) * 73.0);
            }
        }
        poseStackIn.m_85837_(0.0, 0.375, 0.0);
        poseStackIn.m_85845_(Vector3f.f_122225_.m_122240_(180.0f - entityYaw));
        poseStackIn.m_85845_(Vector3f.f_122227_.m_122240_(-f3));
        float f5 = (float)entityIn.m_38176_() - partialTicks;
        float f6 = entityIn.m_38169_() - partialTicks;
        if (f6 < 0.0f) {
            f6 = 0.0f;
        }
        if (f5 > 0.0f) {
            poseStackIn.m_85845_(Vector3f.f_122223_.m_122240_(MathHelper.sin((float)f5) * f5 * f6 / 10.0f * (float)entityIn.m_38177_()));
        }
        poseStackIn.m_85841_(-1.0f, -1.0f, 1.0f);
        this.model.m_6973_((Entity)entityIn, 0.0f, 0.0f, -0.1f, 0.0f, 0.0f);
        VertexConsumer ivertexbuilder = bufferIn.m_6299_(this.model.m_103119_(this.getTextureLocation(entityIn)));
        this.model.m_7695_(poseStackIn, ivertexbuilder, packedLightIn, OverlayTexture.f_118083_, 1.0f, 1.0f, 1.0f, 1.0f);
        FluidStack renderFluid = entityIn.getTank().getFluidStack();
        if (!renderFluid.isEmpty()) {
            ivertexbuilder = bufferIn.m_6299_(RenderType.m_110466_());
            int color = FluidHelper.color((FluidStack)renderFluid);
            RenderHelper.setShaderColorFromInt((int)color);
            RenderHelper.renderCuboid((AABB)this.storageAABB, (PoseStack)poseStackIn, (VertexConsumer)ivertexbuilder, (int)packedLightIn, (float)RenderHelper.red((int)color), (float)RenderHelper.green((int)color), (float)RenderHelper.blue((int)color), (float)0.8f, (TextureAtlasSprite)RenderHelper.getFluidTexture((FluidStack)renderFluid));
        }
        poseStackIn.m_85849_();
    }

    public ResourceLocation getTextureLocation(FluidMinecart entity) {
        return TEXTURE;
    }
}

