/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermal.expansion.block.entity.machine;

import cofh.core.util.helpers.AugmentableHelper;
import cofh.core.util.helpers.FluidHelper;
import cofh.core.util.helpers.ItemHelper;
import cofh.lib.api.StorageGroup;
import cofh.lib.api.inventory.IItemStackHolder;
import cofh.lib.fluid.FluidStorageCoFH;
import cofh.lib.inventory.ItemStorageCoFH;
import cofh.lib.util.helpers.MathHelper;
import cofh.thermal.core.config.ThermalCoreConfig;
import cofh.thermal.core.item.SlotSealItem;
import cofh.thermal.core.util.managers.machine.InsolatorRecipeManager;
import cofh.thermal.expansion.init.TExpTileEntities;
import cofh.thermal.expansion.inventory.container.machine.MachineInsolatorContainer;
import cofh.thermal.lib.block.entity.MachineBlockEntity;
import cofh.thermal.lib.util.recipes.IMachineInventory;
import cofh.thermal.lib.util.recipes.IThermalInventory;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraftforge.fluids.FluidStack;

public class MachineInsolatorTile
extends MachineBlockEntity {
    protected ItemStorageCoFH inputSlot = new ItemStorageCoFH(item -> this.filter.valid(item) && InsolatorRecipeManager.instance().validRecipe(item));
    protected ItemStorageCoFH catalystSlot = new ItemStorageCoFH(item -> item.m_41720_() instanceof SlotSealItem || InsolatorRecipeManager.instance().validCatalyst(item));
    protected FluidStorageCoFH waterTank = new FluidStorageCoFH(4000, FluidHelper.IS_WATER);
    protected boolean cyclicProcessingFeature = false;

    public MachineInsolatorTile(BlockPos pos, BlockState state) {
        super((BlockEntityType)TExpTileEntities.MACHINE_INSOLATOR_TILE.get(), pos, state);
        this.inventory.addSlot(this.inputSlot, StorageGroup.INPUT);
        this.inventory.addSlot(this.catalystSlot, StorageGroup.CATALYST);
        this.inventory.addSlots(StorageGroup.OUTPUT, 4);
        this.inventory.addSlot(this.chargeSlot, StorageGroup.INTERNAL);
        this.tankInv.addTank(this.waterTank, StorageGroup.INPUT);
        this.renderFluid = new FluidStack((Fluid)Fluids.f_76193_, 1000);
        this.addAugmentSlots(ThermalCoreConfig.machineAugments);
        this.initHandlers();
    }

    protected int getBaseProcessTick() {
        return InsolatorRecipeManager.instance().getBasePower();
    }

    protected boolean cacheRecipe() {
        this.curRecipe = InsolatorRecipeManager.instance().getRecipe((IThermalInventory)this);
        this.curCatalyst = InsolatorRecipeManager.instance().getCatalyst((IItemStackHolder)this.catalystSlot);
        if (this.curRecipe != null) {
            this.itemInputCounts = this.curRecipe.getInputItemCounts((IMachineInventory)this);
            this.fluidInputCounts = this.curRecipe.getInputFluidCounts((IMachineInventory)this);
        }
        return this.curRecipe != null;
    }

    protected void resolveInputs() {
        int decrement;
        int primaryCount = (Integer)this.itemInputCounts.get(0);
        if (this.cyclicProcessingFeature) {
            boolean recycled = false;
            ItemStack input = this.inputSlot.getItemStack();
            for (ItemStorageCoFH slot : this.outputSlots()) {
                if (!ItemHelper.itemsEqualWithTags((ItemStack)slot.getItemStack(), (ItemStack)input) || slot.getCount() < primaryCount) continue;
                slot.modify(-primaryCount);
                recycled = true;
                break;
            }
            if (!recycled) {
                this.inputSlot.modify(-primaryCount);
            }
        } else {
            this.inputSlot.modify(-primaryCount);
        }
        int n = decrement = this.itemInputCounts.size() > 1 ? (Integer)this.itemInputCounts.get(1) : 0;
        if (decrement > 0) {
            if (this.catalystSlot.getItemStack().m_41763_()) {
                if (this.catalystSlot.getItemStack().m_220157_(decrement, MathHelper.RANDOM, null)) {
                    this.catalystSlot.modify(-1);
                }
            } else {
                this.catalystSlot.modify(-decrement);
            }
        }
        if (!this.fluidInputCounts.isEmpty()) {
            this.waterTank.modify(-((Integer)this.fluidInputCounts.get(0)).intValue());
        }
    }

    @Nullable
    public AbstractContainerMenu m_7208_(int i, Inventory inventory, Player player) {
        return new MachineInsolatorContainer(i, this.f_58857_, this.f_58858_, inventory, player);
    }

    protected boolean validateInputs() {
        if (!this.cacheRecipe()) {
            return false;
        }
        return this.inputSlot.getCount() >= (Integer)this.itemInputCounts.get(0) && (this.fluidInputCounts.isEmpty() || this.waterTank.getAmount() >= (Integer)this.fluidInputCounts.get(0));
    }

    protected void resetAttributes() {
        super.resetAttributes();
        this.cyclicProcessingFeature = false;
    }

    protected void setAttributesFromAugment(CompoundTag augmentData) {
        super.setAttributesFromAugment(augmentData);
        this.cyclicProcessingFeature |= AugmentableHelper.getAttributeMod((CompoundTag)augmentData, (String)"CycProc") > 0.0f;
    }
}

