/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermal.dynamics.api.helper;

import cofh.lib.util.helpers.BlockHelper;
import cofh.thermal.dynamics.api.TDynApi;
import cofh.thermal.dynamics.api.grid.IDuct;
import java.util.Iterator;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.entity.BlockEntity;
import org.jetbrains.annotations.Nullable;

public class GridHelper {
    private GridHelper() {
    }

    @Nullable
    public static IDuct<?, ?> getGridHost(BlockGetter reader, BlockPos pos) {
        LevelReader worldReader;
        if (reader instanceof LevelReader && !(worldReader = (LevelReader)reader).m_46805_(pos)) {
            return null;
        }
        return GridHelper.getGridHost(reader.m_7702_(pos));
    }

    @Nullable
    public static IDuct<?, ?> getGridHost(@Nullable BlockEntity tile) {
        if (tile == null) {
            return null;
        }
        if (tile instanceof IDuct) {
            IDuct host = (IDuct)tile;
            return host;
        }
        return (IDuct)tile.getCapability(TDynApi.GRID_HOST_CAPABILITY).orElse(null);
    }

    public static Iterable<BlockPos> positionsBetween(final BlockPos a, final BlockPos b) {
        assert (GridHelper.isOnSameAxis(a, b));
        final Direction dir = BlockHelper.getSide((BlockPos)b.m_121996_((Vec3i)a));
        assert (dir != null) : "Not on the same axis??";
        return () -> new Iterator<BlockPos>(){
            BlockPos curr;
            {
                this.curr = a.m_121945_(dir);
            }

            @Override
            public boolean hasNext() {
                return !this.curr.equals((Object)b);
            }

            @Override
            public BlockPos next() {
                BlockPos ret = this.curr;
                this.curr = this.curr.m_121945_(dir);
                return ret;
            }
        };
    }

    public static int numBetween(BlockPos a, BlockPos b) {
        assert (GridHelper.isOnSameAxis(a, b));
        return Math.abs(a.m_123341_() - b.m_123341_()) + Math.abs(a.m_123342_() - b.m_123342_()) + Math.abs(a.m_123343_() - b.m_123343_()) - 1;
    }

    public static boolean isOnEdge(BlockPos middle, BlockPos a, BlockPos b) {
        assert (GridHelper.isOnSameAxis(a, b));
        if (a.m_123341_() != b.m_123341_()) {
            return middle.m_123342_() == a.m_123342_() && middle.m_123343_() == a.m_123343_() && GridHelper.betweenExclusive(middle.m_123341_(), a.m_123341_(), b.m_123341_());
        }
        if (a.m_123342_() != b.m_123342_()) {
            return middle.m_123343_() == a.m_123343_() && middle.m_123341_() == a.m_123341_() && GridHelper.betweenExclusive(middle.m_123342_(), a.m_123342_(), b.m_123342_());
        }
        if (a.m_123343_() != b.m_123343_()) {
            return middle.m_123341_() == a.m_123341_() && middle.m_123342_() == a.m_123342_() && GridHelper.betweenExclusive(middle.m_123343_(), a.m_123343_(), b.m_123343_());
        }
        throw new IllegalArgumentException("A == B");
    }

    private static boolean betweenExclusive(int v, int a, int b) {
        return a < b ? a < v && v < b : b < v && v < a;
    }

    public static boolean isOnSameAxis(BlockPos a, BlockPos b) {
        boolean z;
        boolean x = a.m_123341_() == b.m_123341_();
        boolean y = a.m_123342_() == b.m_123342_();
        boolean bl = z = a.m_123343_() == b.m_123343_();
        if (x && y) {
            return true;
        }
        if (x && z) {
            return true;
        }
        return y && z;
    }

    public static BlockPos stepTowards(BlockPos from, BlockPos towards) {
        assert (GridHelper.isOnSameAxis(from, towards)) : "Not on the same axis";
        Direction dir = BlockHelper.getSide((BlockPos)towards.m_121996_((Vec3i)from));
        assert (dir != null) : "Not on the same axis??";
        return from.m_121945_(dir);
    }
}

