/*
 * Decompiled with CFR 0.152.
 */
package mcjty.theoneprobe.apiimpl.providers;

import com.mojang.authlib.GameProfile;
import java.util.Collections;
import java.util.Objects;
import java.util.Optional;
import mcjty.theoneprobe.TheOneProbe;
import mcjty.theoneprobe.Tools;
import mcjty.theoneprobe.api.Color;
import mcjty.theoneprobe.api.CompoundText;
import mcjty.theoneprobe.api.ElementAlignment;
import mcjty.theoneprobe.api.IBlockDisplayOverride;
import mcjty.theoneprobe.api.IProbeConfig;
import mcjty.theoneprobe.api.IProbeHitData;
import mcjty.theoneprobe.api.IProbeInfo;
import mcjty.theoneprobe.api.IProbeInfoProvider;
import mcjty.theoneprobe.api.NumberFormat;
import mcjty.theoneprobe.api.ProbeMode;
import mcjty.theoneprobe.api.TextStyleClass;
import mcjty.theoneprobe.apiimpl.ProbeConfig;
import mcjty.theoneprobe.apiimpl.elements.ElementProgress;
import mcjty.theoneprobe.apiimpl.providers.ChestInfoTools;
import mcjty.theoneprobe.apiimpl.providers.HarvestInfoTools;
import mcjty.theoneprobe.compat.TeslaTools;
import mcjty.theoneprobe.config.Config;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.BaseSpawner;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BrewingStandBlock;
import net.minecraft.world.level.block.ComparatorBlock;
import net.minecraft.world.level.block.InfestedBlock;
import net.minecraft.world.level.block.LeverBlock;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.NoteBlock;
import net.minecraft.world.level.block.RedStoneWireBlock;
import net.minecraft.world.level.block.RepeaterBlock;
import net.minecraft.world.level.block.SkullBlock;
import net.minecraft.world.level.block.SpawnerBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BrewingStandBlockEntity;
import net.minecraft.world.level.block.entity.SkullBlockEntity;
import net.minecraft.world.level.block.entity.SpawnerBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.ComparatorMode;
import net.minecraft.world.level.block.state.properties.NoteBlockInstrument;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraftforge.client.extensions.common.IClientFluidTypeExtensions;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;

public class DefaultProbeInfoProvider
implements IProbeInfoProvider {
    private static final String[] NOTE_TABLE = new String[]{"F#", "G", "G#", "A", "A#", "B", "C", "C#", "D", "D#", "E", "F", "F#", "G", "G#", "A", "A#", "B", "C", "C#", "D", "D#", "E", "F", "F#"};

    @Override
    public ResourceLocation getID() {
        return new ResourceLocation("theoneprobe", "default");
    }

    @Override
    public void addProbeInfo(ProbeMode mode, IProbeInfo probeInfo, Player player, Level world, BlockState blockState, IProbeHitData data) {
        Block block = blockState.m_60734_();
        BlockPos pos = data.getPos();
        IProbeConfig config = Config.getRealConfig();
        boolean handled = false;
        for (IBlockDisplayOverride override : TheOneProbe.theOneProbeImp.getBlockOverrides()) {
            if (!override.overrideStandardInfo(mode, probeInfo, player, world, blockState, data)) continue;
            handled = true;
            break;
        }
        if (!handled) {
            DefaultProbeInfoProvider.showStandardBlockInfo(config, mode, probeInfo, blockState, block, world, pos, player, data);
        }
        if (Tools.show(mode, config.getShowCropPercentage())) {
            this.showGrowthLevel(probeInfo, blockState);
        }
        boolean showHarvestLevel = Tools.show(mode, config.getShowHarvestLevel());
        boolean showHarvested = Tools.show(mode, config.getShowCanBeHarvested());
        if (showHarvested && showHarvestLevel) {
            HarvestInfoTools.showHarvestInfo(probeInfo, world, pos, block, blockState, player);
        } else if (showHarvestLevel) {
            HarvestInfoTools.showHarvestLevel(probeInfo, blockState);
        } else if (showHarvested) {
            HarvestInfoTools.showCanBeHarvested(probeInfo, world, pos, blockState, player);
        }
        if (Tools.show(mode, config.getShowRedstone())) {
            this.showRedstonePower(probeInfo, world, blockState, data, block, Tools.show(mode, config.getShowLeverSetting()));
        }
        if (Tools.show(mode, config.getShowLeverSetting())) {
            this.showLeverSetting(probeInfo, world, blockState, data, block);
        }
        ChestInfoTools.showChestInfo(mode, probeInfo, world, pos, config);
        if (config.getRFMode() > 0) {
            this.showEnergy(probeInfo, world, pos);
        }
        if (Tools.show(mode, config.getShowTankSetting()) && config.getTankMode() > 0) {
            this.showTankInfo(probeInfo, world, pos);
        }
        if (Tools.show(mode, config.getShowBrewStandSetting())) {
            this.showBrewingStandInfo(probeInfo, world, data, block);
        }
        if (Tools.show(mode, config.getShowMobSpawnerSetting())) {
            this.showMobSpawnerInfo(probeInfo, world, data, block);
        }
        if (Tools.show(mode, config.getShowNoteblockInfo())) {
            this.showNoteblockInfo(probeInfo, world, data, blockState);
        }
        if (Tools.show(mode, config.getShowSkullInfo())) {
            this.showSkullInfo(probeInfo, world, data, blockState);
        }
    }

    private void showBrewingStandInfo(IProbeInfo probeInfo, Level world, IProbeHitData data, Block block) {
        BlockEntity te;
        if (block instanceof BrewingStandBlock && (te = world.m_7702_(data.getPos())) instanceof BrewingStandBlockEntity) {
            BrewingStandBlockEntity brewingStand = (BrewingStandBlockEntity)te;
            int brewtime = brewingStand.f_58976_;
            int fuel = brewingStand.f_58979_;
            probeInfo.horizontal(probeInfo.defaultLayoutStyle().alignment(ElementAlignment.ALIGN_CENTER)).item(new ItemStack((ItemLike)Items.f_42593_), probeInfo.defaultItemStyle().width(16).height(16)).text(CompoundText.createLabelInfo("Fuel: ", fuel));
            if (brewtime > 0) {
                probeInfo.text(CompoundText.createLabelInfo("Time: ", brewtime + " ticks"));
            }
        }
    }

    private void showNoteblockInfo(IProbeInfo probeInfo, Level world, IProbeHitData data, BlockState blockState) {
        if (blockState.m_60734_() instanceof NoteBlock) {
            int note = (Integer)blockState.m_61143_((Property)NoteBlock.f_55013_);
            NoteBlockInstrument instrument = (NoteBlockInstrument)blockState.m_61143_((Property)NoteBlock.f_55011_);
            if (note < 0) {
                note = 0;
            } else if (note > 24) {
                note = 24;
            }
            probeInfo.horizontal(probeInfo.defaultLayoutStyle().alignment(ElementAlignment.ALIGN_CENTER)).text(CompoundText.create().style(TextStyleClass.LABEL).text("Note: ").info(instrument.name().toLowerCase() + " " + NOTE_TABLE[note] + " (" + note + ")"));
        }
    }

    private void showSkullInfo(IProbeInfo probeInfo, Level world, IProbeHitData data, BlockState blockState) {
        SkullBlockEntity skullBlockEntity;
        GameProfile profile;
        BlockEntity te;
        if (blockState.m_60734_() instanceof SkullBlock && (te = world.m_7702_(data.getPos())) instanceof SkullBlockEntity && (profile = (skullBlockEntity = (SkullBlockEntity)te).m_59779_()) != null && profile.isComplete()) {
            probeInfo.horizontal(probeInfo.defaultLayoutStyle().alignment(ElementAlignment.ALIGN_CENTER)).text(CompoundText.create().style(TextStyleClass.LABEL).text("Player: ").info(profile.getName()));
        }
    }

    private void showMobSpawnerInfo(IProbeInfo probeInfo, Level world, IProbeHitData data, Block block) {
        BlockEntity te;
        if (block instanceof SpawnerBlock && (te = world.m_7702_(data.getPos())) instanceof SpawnerBlockEntity) {
            SpawnerBlockEntity spawnerBlock = (SpawnerBlockEntity)te;
            BaseSpawner logic = spawnerBlock.m_59801_();
            CompoundTag tag = logic.f_45444_.m_186567_();
            Optional optional = EntityType.m_20637_((CompoundTag)tag);
            optional.ifPresent(type -> probeInfo.horizontal(probeInfo.defaultLayoutStyle().alignment(ElementAlignment.ALIGN_CENTER)).text(CompoundText.create().style(TextStyleClass.LABEL).text("Mob: ").info(type.m_20675_())));
        }
    }

    private void showRedstonePower(IProbeInfo probeInfo, Level world, BlockState blockState, IProbeHitData data, Block block, boolean showLever) {
        if (showLever && block instanceof LeverBlock) {
            return;
        }
        int redstonePower = block instanceof RedStoneWireBlock ? ((Integer)blockState.m_61143_((Property)RedStoneWireBlock.f_55500_)).intValue() : world.m_46681_(data.getPos(), data.getSideHit().m_122424_());
        if (redstonePower > 0) {
            probeInfo.horizontal().item(new ItemStack((ItemLike)Items.f_42451_), probeInfo.defaultItemStyle().width(14).height(14)).text(CompoundText.createLabelInfo("Power: ", redstonePower));
        }
    }

    private void showLeverSetting(IProbeInfo probeInfo, Level world, BlockState blockState, IProbeHitData data, Block block) {
        if (block instanceof LeverBlock) {
            Boolean powered = (Boolean)blockState.m_61143_((Property)LeverBlock.f_54622_);
            probeInfo.horizontal().item(new ItemStack((ItemLike)Items.f_42451_), probeInfo.defaultItemStyle().width(14).height(14)).text(CompoundText.createLabelInfo("State: ", powered != false ? "On" : "Off"));
        } else if (block instanceof ComparatorBlock) {
            ComparatorMode mode = (ComparatorMode)blockState.m_61143_((Property)ComparatorBlock.f_51854_);
            probeInfo.text(CompoundText.createLabelInfo("Mode: ", mode.m_7912_()));
        } else if (block instanceof RepeaterBlock) {
            Boolean locked = (Boolean)blockState.m_61143_((Property)RepeaterBlock.f_55797_);
            Integer delay = (Integer)blockState.m_61143_((Property)RepeaterBlock.f_55798_);
            probeInfo.text(CompoundText.createLabelInfo("Delay: ", delay + " ticks"));
            if (locked.booleanValue()) {
                probeInfo.text(CompoundText.create().style(TextStyleClass.INFO).text("Locked"));
            }
        }
    }

    private void showTankInfo(IProbeInfo probeInfo, Level world, BlockPos pos) {
        ProbeConfig config = Config.getDefaultConfig();
        BlockEntity te = world.m_7702_(pos);
        if (te != null && te.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY).isPresent()) {
            te.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY).ifPresent(handler -> {
                for (int i = 0; i < handler.getTanks(); ++i) {
                    FluidStack fluidStack = handler.getFluidInTank(i);
                    int maxContents = handler.getTankCapacity(i);
                    if (fluidStack.isEmpty()) continue;
                    this.addFluidInfo(probeInfo, config, fluidStack, maxContents);
                }
            });
        }
    }

    private void addFluidInfo(IProbeInfo probeInfo, ProbeConfig config, FluidStack fluidStack, int maxContents) {
        int contents = fluidStack.getAmount();
        if (config.getTankMode() == 1) {
            int tintColor = IClientFluidTypeExtensions.of((Fluid)fluidStack.getFluid()).getTintColor(fluidStack);
            Color color = new Color(tintColor);
            if (Objects.equals(fluidStack.getFluid(), Fluids.f_76195_)) {
                color = new Color(255, 139, 27);
            }
            MutableComponent text = Component.m_237113_((String)"");
            text.m_7220_(ElementProgress.format(contents, Config.tankFormat.get(), (Component)Component.m_237113_((String)"mB")));
            text.m_130946_("/");
            text.m_7220_(ElementProgress.format(maxContents, Config.tankFormat.get(), (Component)Component.m_237113_((String)"mB")));
            probeInfo.tankSimple(maxContents, fluidStack, probeInfo.defaultProgressStyle().numberFormat(NumberFormat.NONE).borderlessColor(color, color.darker().darker()).prefix((Component)((MutableComponent)fluidStack.getDisplayName()).m_130946_(": ")).suffix((Component)text));
        } else {
            if (!fluidStack.isEmpty()) {
                probeInfo.text(CompoundText.create().style(TextStyleClass.NAME).text("Liquid:").info(fluidStack.getTranslationKey()));
            }
            if (config.getTankMode() == 2) {
                probeInfo.progress(contents, maxContents, probeInfo.defaultProgressStyle().suffix("mB").filledColor(Config.tankbarFilledColor).alternateFilledColor(Config.tankbarAlternateFilledColor).borderColor(Config.tankbarBorderColor).numberFormat(Config.tankFormat.get()));
            } else {
                probeInfo.text(CompoundText.create().style(TextStyleClass.PROGRESS).text(ElementProgress.format(contents, Config.tankFormat.get(), (Component)Component.m_237113_((String)"mB"))));
            }
        }
    }

    private void showEnergy(IProbeInfo probeInfo, Level world, BlockPos pos) {
        ProbeConfig config = Config.getDefaultConfig();
        BlockEntity te = world.m_7702_(pos);
        if (TheOneProbe.tesla && TeslaTools.isEnergyHandler(te)) {
            long energy = TeslaTools.getEnergy(te);
            long maxEnergy = TeslaTools.getMaxEnergy(te);
            this.addEnergyInfo(probeInfo, config, energy, maxEnergy);
        } else if (te != null && te.getCapability(CapabilityEnergy.ENERGY).isPresent()) {
            te.getCapability(CapabilityEnergy.ENERGY).ifPresent(handler -> this.addEnergyInfo(probeInfo, config, handler.getEnergyStored(), handler.getMaxEnergyStored()));
        }
    }

    private void addEnergyInfo(IProbeInfo probeInfo, ProbeConfig config, long energy, long maxEnergy) {
        if (config.getRFMode() == 1) {
            probeInfo.progress(energy, maxEnergy, probeInfo.defaultProgressStyle().suffix("FE").filledColor(Config.rfbarFilledColor).alternateFilledColor(Config.rfbarAlternateFilledColor).borderColor(Config.rfbarBorderColor).numberFormat(Config.rfFormat.get()));
        } else {
            probeInfo.text(CompoundText.create().style(TextStyleClass.PROGRESS).text("FE: " + ElementProgress.format(energy, Config.rfFormat.get(), (Component)Component.m_237113_((String)"FE"))));
        }
    }

    private void showGrowthLevel(IProbeInfo probeInfo, BlockState blockState) {
        for (Property property : blockState.m_61147_()) {
            if (!"age".equals(property.m_61708_())) continue;
            if (property.m_61709_() == Integer.class) {
                int maxAge;
                Property integerProperty = property;
                int age = (Integer)blockState.m_61143_(integerProperty);
                if (age == (maxAge = ((Integer)Collections.max(integerProperty.m_6908_())).intValue())) {
                    probeInfo.text(CompoundText.create().style(TextStyleClass.OK).text("Fully grown"));
                } else {
                    probeInfo.text(CompoundText.create().style(TextStyleClass.LABEL).text("Growth: ").style(TextStyleClass.WARNING).text(age * 100 / maxAge + "%"));
                }
            }
            return;
        }
    }

    public static void showStandardBlockInfo(IProbeConfig config, ProbeMode mode, IProbeInfo probeInfo, BlockState blockState, Block block, Level world, BlockPos pos, Player player, IProbeHitData data) {
        FluidState fluidState;
        Fluid fluid;
        String modName = Tools.getModName(block);
        ItemStack pickBlock = data.getPickBlock();
        if (block instanceof InfestedBlock && mode != ProbeMode.DEBUG && !Tools.show(mode, config.getShowSilverfish())) {
            block = ((InfestedBlock)block).m_54192_();
            pickBlock = new ItemStack((ItemLike)block, 1);
        }
        if (block instanceof LiquidBlock && !Objects.equals(fluid = (fluidState = blockState.m_60819_()).m_76152_(), Fluids.f_76191_)) {
            IProbeInfo horizontal = probeInfo.horizontal();
            FluidStack fluidStack = new FluidStack(fluid, 1000);
            int tintColor = IClientFluidTypeExtensions.of((Fluid)fluid).getTintColor(fluidStack);
            ResourceLocation stillTexture = IClientFluidTypeExtensions.of((Fluid)fluid).getStillTexture();
            Color color = new Color(tintColor);
            horizontal.icon(stillTexture, -1, -1, 16, 16, probeInfo.defaultIconStyle().width(20).color(color));
            ItemStack bucketStack = FluidUtil.getFilledBucket((FluidStack)fluidStack);
            FluidUtil.getFluidContained((ItemStack)bucketStack).ifPresent(fc -> {
                if (fluidStack.isFluidEqual(fc)) {
                    horizontal.item(bucketStack);
                }
            });
            horizontal.vertical().text(CompoundText.create().name(fluidStack.getTranslationKey())).text(CompoundText.create().style(TextStyleClass.MODNAME).text(modName));
            return;
        }
        if (!pickBlock.m_41619_()) {
            if (Tools.show(mode, config.getShowModName())) {
                probeInfo.horizontal().item(pickBlock).vertical().itemLabel(pickBlock).text(CompoundText.create().style(TextStyleClass.MODNAME).text(modName));
            } else {
                probeInfo.horizontal(probeInfo.defaultLayoutStyle().alignment(ElementAlignment.ALIGN_CENTER)).item(pickBlock).itemLabel(pickBlock);
            }
        } else if (Tools.show(mode, config.getShowModName())) {
            probeInfo.vertical().text(CompoundText.create().name(block.m_7705_())).text(CompoundText.create().style(TextStyleClass.MODNAME).text(modName));
        } else {
            probeInfo.vertical().text(CompoundText.create().name(block.m_7705_()));
        }
    }
}

