/*
 * Decompiled with CFR 0.152.
 */
package se.mickelus.tetra.blocks.workbench.gui;

import java.util.Arrays;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.ChatFormatting;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.world.item.ItemStack;
import se.mickelus.mutil.gui.GuiAttachment;
import se.mickelus.mutil.gui.GuiElement;
import se.mickelus.mutil.gui.GuiString;
import se.mickelus.mutil.gui.GuiStringSmall;
import se.mickelus.mutil.gui.GuiTextSmall;
import se.mickelus.mutil.gui.GuiTexture;
import se.mickelus.tetra.blocks.workbench.gui.GuiModuleGlyph;
import se.mickelus.tetra.gui.GuiItemRolling;
import se.mickelus.tetra.gui.GuiMagicUsage;
import se.mickelus.tetra.gui.GuiSettleProgress;
import se.mickelus.tetra.gui.GuiSynergyIndicator;
import se.mickelus.tetra.gui.GuiTextures;
import se.mickelus.tetra.module.ItemModule;
import se.mickelus.tetra.module.ItemModuleMajor;
import se.mickelus.tetra.module.RepairRegistry;
import se.mickelus.tetra.module.data.GlyphData;

@ParametersAreNonnullByDefault
public class GuiModuleDetails
extends GuiElement {
    private final GuiElement glyph = new GuiElement(3, 3, 16, 16);
    private final GuiString title;
    private final GuiTextSmall description;
    private final GuiString emptyLabel;
    private final GuiMagicUsage magicBar;
    private final GuiSettleProgress settleBar;
    private final GuiSynergyIndicator synergyIndicator;
    private final GuiElement repairGroup;
    private final GuiStringSmall repairTitle;
    private final GuiItemRolling repairMaterial;
    private final GuiStringSmall noRepairLabel;

    public GuiModuleDetails(int x, int y) {
        super(x, y, 224, 67);
        this.addChild(this.glyph);
        this.title = new GuiString(20, 7, 105, "");
        this.addChild((GuiElement)this.title);
        this.description = new GuiTextSmall(5, 19, 105, "");
        this.addChild((GuiElement)this.description);
        this.emptyLabel = new GuiString(0, -3, ChatFormatting.DARK_GRAY + I18n.m_118938_((String)"tetra.workbench.module_detail.empty", (Object[])new Object[0]));
        this.emptyLabel.setAttachment(GuiAttachment.middleCenter);
        this.addChild((GuiElement)this.emptyLabel);
        this.synergyIndicator = new GuiSynergyIndicator(130, 8);
        this.addChild(this.synergyIndicator);
        this.repairGroup = new GuiElement(150, 5, 60, 16);
        this.addChild(this.repairGroup);
        this.repairTitle = new GuiStringSmall(0, 7, I18n.m_118938_((String)"item.tetra.modular.repair_material.label", (Object[])new Object[0]));
        this.repairGroup.addChild((GuiElement)this.repairTitle);
        this.noRepairLabel = new GuiStringSmall(0, 7, ChatFormatting.GRAY + I18n.m_118938_((String)"item.tetra.modular.repair_material.empty", (Object[])new Object[0]));
        this.noRepairLabel.setAttachment(GuiAttachment.topCenter);
        this.noRepairLabel.setVisible(false);
        this.repairGroup.addChild((GuiElement)this.noRepairLabel);
        this.repairMaterial = new GuiItemRolling(-2, 0);
        this.repairMaterial.setAttachment(GuiAttachment.topRight);
        this.repairGroup.addChild((GuiElement)this.repairMaterial);
        this.magicBar = new GuiMagicUsage(130, 30, 80);
        this.addChild(this.magicBar);
        this.settleBar = new GuiSettleProgress(130, 45, 80);
        this.addChild(this.settleBar);
    }

    public void update(ItemModule module, ItemStack itemStack) {
        this.glyph.clearChildren();
        if (module != null) {
            this.title.setString(module.getName(itemStack));
            this.description.setString(ChatFormatting.GRAY + module.getDescription(itemStack).replace(ChatFormatting.RESET.toString(), ChatFormatting.GRAY.toString()));
            GlyphData glyphData = module.getVariantData((ItemStack)itemStack).glyph;
            if (module instanceof ItemModuleMajor) {
                this.glyph.addChild((GuiElement)new GuiTexture(0, 0, 15, 15, 52, 0, GuiTextures.workbench));
                this.glyph.addChild((GuiElement)new GuiModuleGlyph(-1, 0, 16, 16, glyphData).setShift(false));
                this.settleBar.update(itemStack, (ItemModuleMajor)module);
            } else {
                this.glyph.addChild((GuiElement)new GuiTexture(3, 2, 11, 11, 68, 0, GuiTextures.workbench));
                this.glyph.addChild((GuiElement)new GuiModuleGlyph(5, 4, 8, 8, glyphData).setShift(false));
            }
            this.magicBar.update(itemStack, ItemStack.f_41583_, module.getSlot());
            this.synergyIndicator.update(itemStack, module);
            ItemStack[] repairItemStacks = (ItemStack[])RepairRegistry.instance.getDefinitions(module.getVariantData((ItemStack)itemStack).key).stream().map(definition -> definition.material.getApplicableItemStacks()).flatMap(Arrays::stream).toArray(ItemStack[]::new);
            this.repairMaterial.setItems(repairItemStacks);
            boolean canRepair = repairItemStacks.length > 0;
            this.repairTitle.setVisible(canRepair);
            this.repairMaterial.setVisible(canRepair);
            this.noRepairLabel.setVisible(!canRepair);
        }
        this.synergyIndicator.setVisible(module != null);
        this.title.setVisible(module != null);
        this.description.setVisible(module != null);
        this.settleBar.setVisible(module instanceof ItemModuleMajor);
        this.magicBar.setVisible(module instanceof ItemModuleMajor);
        this.emptyLabel.setVisible(module == null);
        this.repairGroup.setVisible(module != null);
    }
}

