/*
 * Decompiled with CFR 0.152.
 */
package se.mickelus.tetra.module.schematic;

import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import java.util.stream.Stream;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.common.ToolAction;
import se.mickelus.tetra.ConfigHandler;
import se.mickelus.tetra.TetraToolActions;
import se.mickelus.tetra.aspect.TetraEnchantmentHelper;
import se.mickelus.tetra.gui.GuiTextures;
import se.mickelus.tetra.items.modular.IModularItem;
import se.mickelus.tetra.module.ItemModule;
import se.mickelus.tetra.module.SchematicRegistry;
import se.mickelus.tetra.module.data.GlyphData;
import se.mickelus.tetra.module.schematic.BaseSchematic;
import se.mickelus.tetra.module.schematic.SchematicType;

@ParametersAreNonnullByDefault
public class RemoveSchematic
extends BaseSchematic {
    private static final String localizationPrefix = "tetra/schematic/";
    private static final String nameSuffix = ".name";
    private static final String descriptionSuffix = ".description";
    private final String key = "remove";
    private final IModularItem item;
    private final String slot;
    private final String identifier;
    private final GlyphData glyph = new GlyphData(GuiTextures.workbench, 52, 32);

    public RemoveSchematic(IModularItem item, String slot, String identifier) {
        this.item = item;
        this.slot = slot;
        this.identifier = "remove/" + identifier + "/" + slot;
    }

    public static void registerRemoveSchematics(IModularItem item, String identifier) {
        Stream.concat(Arrays.stream(item.getMajorModuleKeys()), Arrays.stream(item.getMinorModuleKeys())).filter(slot -> !item.isModuleRequired((String)slot)).forEach(slot -> {
            RemoveSchematic schematic = new RemoveSchematic(item, (String)slot, identifier);
            SchematicRegistry.instance.registerSchematic(schematic);
        });
    }

    @Override
    public String getKey() {
        return this.identifier;
    }

    @Override
    public String getName() {
        return I18n.m_118938_((String)"tetra/schematic/remove.name", (Object[])new Object[0]);
    }

    @Override
    public String getDescription(ItemStack itemStack) {
        return I18n.m_118938_((String)"tetra/schematic/remove.description", (Object[])new Object[0]);
    }

    @Override
    public int getNumMaterialSlots() {
        return 0;
    }

    @Override
    public String getSlotName(ItemStack itemStack, int index) {
        return "";
    }

    @Override
    public int getRequiredQuantity(ItemStack itemStack, int index, ItemStack materialStack) {
        return 0;
    }

    @Override
    public boolean acceptsMaterial(ItemStack itemStack, String itemSlot, int index, ItemStack materialStack) {
        return false;
    }

    @Override
    public boolean isRelevant(ItemStack itemStack) {
        return this.item.getClass().isInstance(itemStack.m_41720_());
    }

    @Override
    public boolean isApplicableForSlot(String slot, ItemStack targetStack) {
        return this.slot.equals(slot) && this.item.getModuleFromSlot(targetStack, this.slot) != null;
    }

    @Override
    public boolean canApplyUpgrade(Player player, ItemStack itemStack, ItemStack[] materials, String slot, Map<ToolAction, Integer> availableTools) {
        return !this.isIntegrityViolation(player, itemStack, materials, slot) && this.checkTools(itemStack, materials, availableTools);
    }

    @Override
    public boolean isMaterialsValid(ItemStack itemStack, String itemSlot, ItemStack[] materials) {
        return true;
    }

    @Override
    public ItemStack applyUpgrade(ItemStack itemStack, ItemStack[] materials, boolean consumeMaterials, String slot, Player player) {
        ItemStack upgradedStack = itemStack.m_41777_();
        IModularItem item = (IModularItem)itemStack.m_41720_();
        float durabilityFactor = 0.0f;
        if (consumeMaterials && upgradedStack.m_41763_()) {
            durabilityFactor = (float)upgradedStack.m_41773_() * 1.0f / (float)upgradedStack.m_41776_();
        }
        float honingFactor = Mth.m_14036_((float)(1.0f * (float)item.getHoningProgress(upgradedStack) / (float)item.getHoningLimit(upgradedStack)), (float)0.0f, (float)1.0f);
        ItemModule previousModule = item.getModuleFromSlot(upgradedStack, slot);
        if (previousModule != null) {
            TetraEnchantmentHelper.removeEnchantments(upgradedStack, slot);
            previousModule.removeModule(upgradedStack);
            if (consumeMaterials) {
                previousModule.postRemove(upgradedStack, player);
            }
        }
        if (consumeMaterials) {
            if (((Boolean)ConfigHandler.moduleProgression.get()).booleanValue() && IModularItem.isHoneable(upgradedStack)) {
                item.setHoningProgress(upgradedStack, (int)Math.ceil(honingFactor * (float)item.getHoningLimit(upgradedStack)));
            }
            if (upgradedStack.m_41763_()) {
                upgradedStack.m_41721_((int)(durabilityFactor * (float)upgradedStack.m_41776_()));
            }
        }
        return upgradedStack;
    }

    @Override
    public Map<ToolAction, Integer> getRequiredToolLevels(ItemStack targetStack, ItemStack[] materials) {
        return Collections.singletonMap(TetraToolActions.hammer, 1);
    }

    @Override
    public SchematicType getType() {
        return SchematicType.other;
    }

    @Override
    public GlyphData getGlyph() {
        return this.glyph;
    }
}

