/*
 * Decompiled with CFR 0.152.
 */
package se.mickelus.tetra.blocks.forged.extractor;

import java.util.List;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.registries.ObjectHolder;
import se.mickelus.tetra.blocks.TetraBlock;
import se.mickelus.tetra.blocks.forged.ForgedBlockCommon;
import se.mickelus.tetra.blocks.forged.extractor.SeepingBedrockBlock;

@ParametersAreNonnullByDefault
public class CoreExtractorPipeBlock
extends TetraBlock {
    public static final DirectionProperty facingProp = BlockStateProperties.f_61372_;
    public static final BooleanProperty poweredProp = BooleanProperty.m_61465_((String)"powered");
    public static final String identifier = "extractor_pipe";
    @ObjectHolder(registryName="block", value="tetra:extractor_pipe")
    public static CoreExtractorPipeBlock instance;

    public CoreExtractorPipeBlock() {
        super(ForgedBlockCommon.propertiesSolid);
    }

    public static boolean isPowered(Level world, BlockPos pos) {
        BlockState pipeState = world.m_8055_(pos);
        return pipeState.m_60713_((Block)instance) && (Boolean)pipeState.m_61143_((Property)poweredProp) != false;
    }

    public void m_5871_(ItemStack stack, @Nullable BlockGetter worldIn, List<Component> tooltip, TooltipFlag flagIn) {
        tooltip.add(ForgedBlockCommon.locationTooltip);
    }

    private boolean shouldGetPower(Level world, BlockPos pos, Direction blockFacing) {
        for (Direction facing : Direction.values()) {
            BlockState adjacent;
            if (facing.equals((Object)blockFacing) || !(adjacent = world.m_8055_(pos.m_121945_(facing))).m_60734_().equals(this) || !facing.equals((Object)((Direction)adjacent.m_61143_((Property)facingProp)).m_122424_()) || !((Boolean)adjacent.m_61143_((Property)poweredProp)).booleanValue()) continue;
            return true;
        }
        return SeepingBedrockBlock.isActive(world, pos.m_121945_(blockFacing.m_122424_()));
    }

    public void m_6861_(BlockState state, Level world, BlockPos pos, Block fromBlock, BlockPos fromPos, boolean isMoving) {
        boolean getsPowered = this.shouldGetPower(world, pos, (Direction)state.m_61143_((Property)facingProp));
        if ((Boolean)state.m_61143_((Property)poweredProp) != getsPowered) {
            world.m_46597_(pos, (BlockState)state.m_61124_((Property)poweredProp, (Comparable)Boolean.valueOf(getsPowered)));
        }
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{facingProp, poweredProp});
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext context) {
        return (BlockState)((BlockState)super.m_5573_(context).m_61124_((Property)facingProp, (Comparable)context.m_43719_())).m_61124_((Property)poweredProp, (Comparable)Boolean.valueOf(this.shouldGetPower(context.m_43725_(), context.m_8083_(), context.m_43719_())));
    }

    public BlockState m_6843_(BlockState state, Rotation direction) {
        return (BlockState)state.m_61124_((Property)facingProp, (Comparable)direction.m_55954_((Direction)state.m_61143_((Property)facingProp)));
    }

    public BlockState m_6943_(BlockState state, Mirror mirror) {
        return state.m_60717_(mirror.m_54846_((Direction)state.m_61143_((Property)facingProp)));
    }
}

