/*
 * Decompiled with CFR 0.152.
 */
package me.codexadrian.tempad.network.messages;

import java.util.UUID;
import java.util.function.BiConsumer;
import me.codexadrian.tempad.data.TempadComponent;
import me.codexadrian.tempad.network.handlers.IPacket;
import me.codexadrian.tempad.network.handlers.IPacketHandler;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;

public record DeleteLocationPacket(UUID location, InteractionHand hand) implements IPacket<DeleteLocationPacket>
{
    public static Handler HANDLER = new Handler();
    public static final ResourceLocation ID = new ResourceLocation("tempad", "delete_location");

    @Override
    public ResourceLocation getID() {
        return ID;
    }

    @Override
    public IPacketHandler<DeleteLocationPacket> getHandler() {
        return HANDLER;
    }

    private static class Handler
    implements IPacketHandler<DeleteLocationPacket> {
        private Handler() {
        }

        @Override
        public void encode(DeleteLocationPacket message, FriendlyByteBuf buffer) {
            buffer.m_130077_(message.location);
            buffer.m_130068_((Enum)message.hand);
        }

        @Override
        public DeleteLocationPacket decode(FriendlyByteBuf buffer) {
            return new DeleteLocationPacket(buffer.m_130259_(), (InteractionHand)buffer.m_130066_(InteractionHand.class));
        }

        @Override
        public BiConsumer<MinecraftServer, Player> handle(DeleteLocationPacket message) {
            return (server, player) -> TempadComponent.deleteStackLocation(player.m_21120_(message.hand), message.location);
        }
    }
}

