/*
 * Decompiled with CFR 0.152.
 */
package chiefarug.mods.systeams.recipe;

import chiefarug.mods.systeams.Systeams;
import chiefarug.mods.systeams.SysteamsRegistry;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.TagParser;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.Container;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.ShapelessRecipe;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.NotNull;

public class UpgradeShapelessRecipe
extends ShapelessRecipe {
    private final ItemStack replacement;

    public UpgradeShapelessRecipe(ShapelessRecipe original, ItemStack replacement) {
        this(original.m_6423_(), original.m_6076_(), original.m_8043_(), (NonNullList<Ingredient>)original.m_7527_(), replacement);
    }

    public UpgradeShapelessRecipe(ResourceLocation id, String group, ItemStack result, NonNullList<Ingredient> ingredients, ItemStack replacement) {
        super(id, group, result, ingredients);
        this.replacement = replacement;
    }

    @NotNull
    public ItemStack m_5874_(CraftingContainer inv) {
        ItemStack result = super.m_5874_(inv);
        int index = this.getMainItem(inv);
        if (index == -1) {
            Systeams.LGGR.warn("Just crafted a Systeams upgrade recipe but couldn't find a main item! Did tags fail to load, or has someone changed the recipe but not the tags? Check the status of the #systeams:recipe_logic/upgrade_main item tag!");
            return result;
        }
        ItemStack input = inv.m_8020_(index);
        result.m_41751_(Systeams.mergeTags(result.m_41783_(), input.m_41783_()));
        return result;
    }

    @NotNull
    public NonNullList<ItemStack> getRemainingItems(CraftingContainer container) {
        NonNullList original = super.m_7457_((Container)container);
        int index = this.getMainItem(container);
        if (!this.replacement.m_41619_() && index > -1) {
            original.set(index, (Object)this.replacement.m_41777_());
        }
        return original;
    }

    private int getMainItem(CraftingContainer container) {
        int i;
        boolean matchFound = false;
        for (i = 0; i < container.m_6643_(); ++i) {
            ItemStack item = container.m_8020_(i);
            if (!item.m_204117_(SysteamsRegistry.Items.UPGRADE_MAIN.getKey())) continue;
            matchFound = true;
            break;
        }
        if (!matchFound) {
            return -1;
        }
        return i;
    }

    public static class Serializer
    extends ShapelessRecipe.Serializer {
        @NotNull
        public UpgradeShapelessRecipe fromJson(ResourceLocation recipeId, JsonObject json) {
            ShapelessRecipe original = super.m_6729_(recipeId, json);
            ItemStack replacement = ItemStack.f_41583_;
            if (json.has("replacement")) {
                replacement = this.itemFromJson(json.get("replacement"));
            }
            return new UpgradeShapelessRecipe(original, replacement);
        }

        public UpgradeShapelessRecipe fromNetwork(ResourceLocation recipeId, FriendlyByteBuf buffer) {
            ShapelessRecipe original = super.m_8005_(recipeId, buffer);
            ItemStack replacement = buffer.m_130267_();
            return new UpgradeShapelessRecipe(original, replacement);
        }

        public void m_6178_(FriendlyByteBuf buffer, ShapelessRecipe recipe) {
            this.toNetwork(buffer, (UpgradeShapelessRecipe)recipe);
        }

        public void toNetwork(FriendlyByteBuf buffer, UpgradeShapelessRecipe recipe) {
            super.m_6178_(buffer, (ShapelessRecipe)recipe);
            buffer.writeItemStack(recipe.replacement, true);
        }

        private ItemStack itemFromJson(JsonElement json) {
            if (json instanceof JsonObject) {
                JsonObject o = (JsonObject)json;
                ItemStack item = this.itemFromString(o.get("item").getAsString());
                if (o.has("nbt")) {
                    try {
                        item.m_41751_(TagParser.m_129359_((String)o.get("nbt").getAsString()));
                    }
                    catch (CommandSyntaxException e) {
                        throw new JsonSyntaxException("Error while parsing NBT for item '" + item.m_41720_() + "'", (Throwable)e);
                    }
                }
                return item;
            }
            return this.itemFromString(json.getAsString());
        }

        private ItemStack itemFromString(String name) {
            if (name.isEmpty()) {
                return ItemStack.f_41583_;
            }
            Item item = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(name));
            if (item == null) {
                throw new JsonSyntaxException("Unknown item '" + name + "'");
            }
            return item.m_7968_();
        }
    }
}

