/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.reg;

import com.google.common.base.Stopwatch;
import java.util.ArrayList;
import java.util.List;
import net.mehvahdjukaar.moonlight.api.platform.RegHelper;
import net.mehvahdjukaar.supplementaries.Supplementaries;
import net.mehvahdjukaar.supplementaries.common.block.blocks.FrameBlock;
import net.mehvahdjukaar.supplementaries.common.block.cauldron.CauldronBehaviorsManager;
import net.mehvahdjukaar.supplementaries.common.block.dispenser.DispenserBehaviorsManager;
import net.mehvahdjukaar.supplementaries.common.block.faucet.FaucetBehaviorsManager;
import net.mehvahdjukaar.supplementaries.common.block.present.PresentBehaviorsManager;
import net.mehvahdjukaar.supplementaries.common.events.overrides.InteractEventOverrideHandler;
import net.mehvahdjukaar.supplementaries.common.items.loot.CurseLootFunction;
import net.mehvahdjukaar.supplementaries.common.items.loot.RandomArrowFunction;
import net.mehvahdjukaar.supplementaries.common.utils.FlowerPotHandler;
import net.mehvahdjukaar.supplementaries.integration.CompatHandler;
import net.mehvahdjukaar.supplementaries.reg.LootTablesInjects;
import net.mehvahdjukaar.supplementaries.reg.ModRegistry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.world.entity.animal.Chicken;
import net.minecraft.world.entity.animal.Parrot;
import net.minecraft.world.entity.animal.horse.AbstractHorse;
import net.minecraft.world.item.FireworkRocketItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.FireworkStarRecipe;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.ComposterBlock;

public class ModSetup {
    private static boolean hasFinishedSetup = false;
    private static int setupStage = 0;
    private static boolean firstTagLoad = false;
    private static final List<Runnable> MOD_SETUP_WORK = List.of(CurseLootFunction::setup, CompatHandler::setup, FlowerPotHandler::setup, ModSetup::registerCompostables, ModSetup::registerMobFoods, ModSetup::registerFabricFlammable, ModSetup::registerFramed, CauldronBehaviorsManager::registerBehaviors, () -> FireworkStarRecipe.f_43879_.put(ModRegistry.ENDERMAN_SKULL_ITEM.get(), FireworkRocketItem.Shape.CREEPER));

    public static void asyncSetup() {
        PresentBehaviorsManager.registerBehaviors();
        FaucetBehaviorsManager.registerBehaviors();
        RandomArrowFunction.setup();
        LootTablesInjects.setup();
    }

    public static void setup() {
        ArrayList<Long> list = new ArrayList<Long>();
        try {
            Stopwatch watch = Stopwatch.createStarted();
            for (int i = 0; i < MOD_SETUP_WORK.size(); ++i) {
                setupStage = i;
                MOD_SETUP_WORK.get(i).run();
                list.add(watch.elapsed().toMillis());
                watch.reset();
                watch.start();
            }
            hasFinishedSetup = true;
            Supplementaries.LOGGER.info("Finished mod setup in: {} ms", list);
        }
        catch (Exception e) {
            Supplementaries.LOGGER.error((Object)e);
            ModSetup.terminateWhenSetupFails();
        }
    }

    private static void terminateWhenSetupFails() {
        throw new IllegalStateException("Mod setup has failed to complete (" + setupStage + ").\n This might be due to some mod incompatibility or outdated dependencies (check if everything is up to date).\n Refusing to continue loading with a broken modstate. Next step: crashing this game, no survivors");
    }

    private static void registerFabricFlammable() {
        RegHelper.registerBlockFlammability((Block)ModRegistry.ROPE.get(), (int)60, (int)100);
    }

    private static void registerMobFoods() {
        ArrayList<ItemStack> chickenFood = new ArrayList<ItemStack>(List.of(Chicken.f_28233_.m_43908_()));
        chickenFood.add(new ItemStack((ItemLike)ModRegistry.FLAX_SEEDS_ITEM.get()));
        Chicken.f_28233_ = Ingredient.m_43921_(chickenFood.stream());
        ArrayList<ItemStack> horseFood = new ArrayList<ItemStack>(List.of(new ItemStack((ItemLike)ModRegistry.FLAX_ITEM.get()), new ItemStack((ItemLike)ModRegistry.FLAX_BLOCK.get()), new ItemStack((ItemLike)ModRegistry.SUGAR_CUBE.get())));
        horseFood.addAll(List.of(AbstractHorse.f_30527_.m_43908_()));
        AbstractHorse.f_30527_ = Ingredient.m_43921_(horseFood.stream());
        Parrot.f_29357_.add(ModRegistry.FLAX_SEEDS_ITEM.get());
    }

    private static void registerFramed() {
        ((FrameBlock)ModRegistry.TIMBER_FRAME.get()).registerFilledBlock((Block)ModRegistry.DAUB.get(), (Block)ModRegistry.DAUB_FRAME.get());
        ModRegistry.TIMBER_BRACE.get().registerFilledBlock((Block)ModRegistry.DAUB.get(), (Block)ModRegistry.DAUB_BRACE.get());
        ModRegistry.TIMBER_CROSS_BRACE.get().registerFilledBlock((Block)ModRegistry.DAUB.get(), (Block)ModRegistry.DAUB_CROSS_BRACE.get());
    }

    private static void registerCompostables() {
        ComposterBlock.f_51914_.put((Object)((ItemLike)ModRegistry.FLAX_SEEDS_ITEM.get()), 0.3f);
        ComposterBlock.f_51914_.put((Object)((ItemLike)ModRegistry.FLAX_ITEM.get()), 0.65f);
        ComposterBlock.f_51914_.put((Object)ModRegistry.FLAX_WILD.get().m_5456_(), 0.65f);
        ComposterBlock.f_51914_.put((Object)ModRegistry.FLAX_BLOCK.get().m_5456_(), 1.0f);
    }

    public static void tagDependantSetup(RegistryAccess registryAccess) {
        if (!firstTagLoad) {
            Stopwatch watch = Stopwatch.createStarted();
            firstTagLoad = true;
            if (!hasFinishedSetup) {
                try {
                    Supplementaries.LOGGER.error("Something went wrong during mod setup, exiting");
                    MOD_SETUP_WORK.get(setupStage).run();
                    Supplementaries.LOGGER.error("No error found. Weird");
                }
                catch (Exception e) {
                    Supplementaries.LOGGER.error((Object)e);
                }
                ModSetup.terminateWhenSetupFails();
            }
            DispenserBehaviorsManager.registerBehaviors(registryAccess);
            InteractEventOverrideHandler.registerOverrides();
            Supplementaries.LOGGER.info("Finished additional setup in {} ms", (Object)watch.elapsed().toMillis());
        }
    }
}

