/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.common.worldgen;

import com.google.common.collect.Lists;
import com.mojang.datafixers.util.Pair;
import it.unimi.dsi.fastutil.objects.Object2ObjectArrayMap;
import it.unimi.dsi.fastutil.objects.ObjectArraySet;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.TreeMap;
import java.util.function.Consumer;
import net.mehvahdjukaar.moonlight.api.util.math.Vec2i;
import net.mehvahdjukaar.supplementaries.Supplementaries;
import net.mehvahdjukaar.supplementaries.configs.CommonConfigs;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.Registry;
import net.minecraft.core.SectionPos;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.TagKey;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.StructureManager;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.chunk.ChunkStatus;
import net.minecraft.world.level.chunk.StructureAccess;
import net.minecraft.world.level.levelgen.RandomState;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.StructureCheckResult;
import net.minecraft.world.level.levelgen.structure.StructureStart;
import net.minecraft.world.level.levelgen.structure.placement.ConcentricRingsStructurePlacement;
import net.minecraft.world.level.levelgen.structure.placement.RandomSpreadStructurePlacement;
import net.minecraft.world.level.levelgen.structure.placement.StructurePlacement;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class StructureLocator {
    private static final Comparator<Vec2i> COMPARATOR = (o1, o2) -> Float.compare(o1.lengthSqr(), o2.lengthSqr());

    @Nullable
    public static LocatedStruct findNearestRandomMapFeature(ServerLevel level, @NotNull HolderSet<Structure> targets, BlockPos pos, int maximumChunkDistance, boolean newlyGenerated) {
        boolean rand;
        List<LocatedStruct> found = StructureLocator.findNearestMapFeatures(level, targets, pos, maximumChunkDistance, newlyGenerated, 1, rand, !(rand = CommonConfigs.Tweaks.RANDOM_ADVENTURER_MAPS_RANDOM.get().booleanValue()));
        if (!found.isEmpty()) {
            return found.get(0);
        }
        return null;
    }

    public static List<LocatedStruct> findNearestMapFeatures(ServerLevel level, @NotNull TagKey<Structure> tagKey, BlockPos pos, int maximumChunkDistance, boolean newlyGenerated, int requiredCount, boolean selectRandom) {
        HolderSet.Named targets = level.m_5962_().m_175515_(Registry.f_235725_).m_203431_(tagKey).orElse(null);
        if (targets == null) {
            return List.of();
        }
        return StructureLocator.findNearestMapFeatures(level, (HolderSet<Structure>)targets, pos, maximumChunkDistance, newlyGenerated, requiredCount, selectRandom, false);
    }

    public static List<LocatedStruct> findNearestMapFeatures(ServerLevel level, HolderSet<Structure> taggedStructures, BlockPos pos, int maximumChunkDistance, boolean newlyGenerated, int requiredCount, boolean selectRandom, boolean exitEarly) {
        int n;
        List<LocatedStruct> foundStructures = new ArrayList<LocatedStruct>();
        if (!level.m_7654_().m_129910_().m_5961_().m_224677_()) {
            return foundStructures;
        }
        List<Object> selectedTargets = taggedStructures.m_203614_().toList();
        ChunkGenerator chunkGenerator = level.m_7726_().m_8481_();
        double maxDist = Double.MAX_VALUE;
        if (selectRandom) {
            Holder selected = (Holder)selectedTargets.get(level.f_46441_.m_188503_(selectedTargets.size()));
            selectedTargets = List.of(selected);
            Supplementaries.LOGGER.info("Searching for structure {}", selected.m_203543_().get());
        } else {
            selectedTargets = new ArrayList(selectedTargets);
            Collections.shuffle(selectedTargets);
        }
        Object2ObjectArrayMap reachableTargetsMap = new Object2ObjectArrayMap();
        RandomState structureState = level.m_7726_().m_214994_();
        for (Holder holder : selectedTargets) {
            for (StructurePlacement structureplacement : chunkGenerator.m_223138_(holder, structureState)) {
                reachableTargetsMap.computeIfAbsent(structureplacement, placement -> new ObjectArraySet()).add(holder);
            }
        }
        ArrayList<Pair> list = new ArrayList<Pair>(reachableTargetsMap.size());
        boolean bl = true;
        StructureManager structuremanager = level.m_215010_();
        for (Map.Entry entry : reachableTargetsMap.entrySet()) {
            StructurePlacement placement2 = (StructurePlacement)entry.getKey();
            if (placement2 instanceof ConcentricRingsStructurePlacement) {
                double d1;
                ConcentricRingsStructurePlacement concentricringsstructureplacement = (ConcentricRingsStructurePlacement)placement2;
                Pair foundPair = chunkGenerator.m_223181_((Set)entry.getValue(), level, structuremanager, pos, newlyGenerated, concentricringsstructureplacement);
                if (foundPair == null || !((d1 = pos.m_123331_((Vec3i)foundPair.getFirst())) < maxDist)) continue;
                maxDist = d1;
                foundStructures.add(new LocatedStruct((Pair<BlockPos, Holder<Structure>>)foundPair));
                continue;
            }
            if (!(placement2 instanceof RandomSpreadStructurePlacement)) continue;
            RandomSpreadStructurePlacement randomPlacement = (RandomSpreadStructurePlacement)placement2;
            list.add(Pair.of((Object)randomPlacement, (Object)((Set)entry.getValue())));
            n = Math.max(n, randomPlacement.m_205003_());
        }
        if (!list.isEmpty()) {
            int chunkX = SectionPos.m_123171_((int)pos.m_123341_());
            int n2 = SectionPos.m_123171_((int)pos.m_123343_());
            long seed = level.m_7328_();
            StructureManager manager = level.m_215010_();
            block3: for (int k = 0; k <= maximumChunkDistance / n; ++k) {
                int outerRing = (k + 1) * n;
                int innerRing = k * n;
                boolean lessPrecision = innerRing * 16 > 2000;
                TreeMap possiblePositions = new TreeMap(COMPARATOR);
                for (Pair pair : list) {
                    RandomSpreadStructurePlacement placement3 = (RandomSpreadStructurePlacement)pair.getFirst();
                    int spacing = placement3.m_205003_();
                    for (int r = innerRing; r < outerRing; r += spacing) {
                        StructureLocator.addAllPossibleFeatureChunksAtDistance(chunkX, n2, r, seed, placement3, c -> {
                            List ll;
                            Vec2i v = new Vec2i(c.f_45578_ - chunkX, c.f_45579_ - chunkZ);
                            if (possiblePositions.containsKey(v)) {
                                boolean bl = true;
                            }
                            if ((ll = possiblePositions.computeIfAbsent(v, o -> new ArrayList())).contains(p)) {
                                boolean bl = true;
                            } else {
                                ll.add(p);
                            }
                        });
                    }
                }
                for (Map.Entry entry : possiblePositions.entrySet()) {
                    Vec2i vec2i = (Vec2i)entry.getKey();
                    ChunkPos chunkPos = new ChunkPos(vec2i.x() + chunkX, vec2i.y() + n2);
                    List structuresThatCanSpawnAtChunkPos = (List)entry.getValue();
                    for (Pair pp : structuresThatCanSpawnAtChunkPos) {
                        foundStructures.addAll(StructureLocator.getStructuresAtChunkPos((Set)pp.getSecond(), (LevelReader)level, manager, newlyGenerated, (RandomSpreadStructurePlacement)pp.getFirst(), chunkPos));
                    }
                    if (foundStructures.size() < requiredCount) continue;
                    break block3;
                }
            }
        }
        foundStructures.sort(Comparator.comparingDouble(f -> pos.m_123331_((Vec3i)f.pos)));
        if (foundStructures.size() >= requiredCount) {
            foundStructures = (List)Lists.partition(foundStructures, (int)requiredCount).get(0);
        }
        if (newlyGenerated) {
            for (LocatedStruct locatedStruct : foundStructures) {
                if (locatedStruct.start == null || !locatedStruct.start.m_73606_()) continue;
                structuremanager.m_220484_(locatedStruct.start);
            }
        }
        return foundStructures;
    }

    private static void addAllPossibleFeatureChunksAtDistance(int chunkX, int chunkZ, int radius, long seed, RandomSpreadStructurePlacement placement, Consumer<ChunkPos> positionConsumer) {
        for (int j = -radius; j <= radius; ++j) {
            boolean flag = j == -radius || j == radius;
            for (int k = -radius; k <= radius; ++k) {
                boolean flag1;
                boolean bl = flag1 = k == -radius || k == radius;
                if (!flag && !flag1) continue;
                int px = chunkX + j;
                int pz = chunkZ + k;
                ChunkPos chunkpos = placement.m_227008_(seed, px, pz);
                positionConsumer.accept(chunkpos);
            }
        }
    }

    private static Set<LocatedStruct> getStructuresAtChunkPos(Set<Holder<Structure>> targets, LevelReader level, StructureManager structureManager, boolean skipKnown, RandomSpreadStructurePlacement placement, ChunkPos chunkpos) {
        HashSet<LocatedStruct> foundStructures = new HashSet<LocatedStruct>();
        for (Holder<Structure> holder : targets) {
            StructureCheckResult structurecheckresult = structureManager.m_220473_(chunkpos, (Structure)holder.m_203334_(), skipKnown);
            if (structurecheckresult == StructureCheckResult.START_NOT_PRESENT) continue;
            if (!skipKnown && structurecheckresult == StructureCheckResult.START_PRESENT) {
                foundStructures.add(new LocatedStruct(placement.m_227039_(chunkpos), holder, null));
                continue;
            }
            ChunkAccess chunkaccess = level.m_46819_(chunkpos.f_45578_, chunkpos.f_45579_, ChunkStatus.f_62315_);
            StructureStart structurestart = structureManager.m_220512_(SectionPos.m_175562_((ChunkAccess)chunkaccess), (Structure)holder.m_203334_(), (StructureAccess)chunkaccess);
            if (structurestart == null || !structurestart.m_73603_() || skipKnown && !structurestart.m_73606_()) continue;
            foundStructures.add(new LocatedStruct(placement.m_227039_(structurestart.m_163625_()), holder, structurestart));
        }
        return foundStructures;
    }

    @Nullable
    private static Set<LocatedStruct> getNearestGeneratedStructureAtDistance(Set<Holder<Structure>> targets, LevelReader level, StructureManager featureManager, int x, int z, int distance, boolean newChunk, long seed, RandomSpreadStructurePlacement placement) {
        int i = placement.m_205003_();
        for (int j = -distance; j <= distance; ++j) {
            boolean flag = j == -distance || j == distance;
            for (int k = -distance; k <= distance; ++k) {
                boolean flag1;
                boolean bl = flag1 = k == -distance || k == distance;
                if (!flag && !flag1) continue;
                int px = x + i * j;
                int pz = z + i * k;
                ChunkPos chunkpos = placement.m_227008_(seed, px, pz);
                return StructureLocator.getStructuresAtChunkPos(targets, level, featureManager, newChunk, placement, chunkpos);
            }
        }
        return null;
    }

    @Nullable
    public BlockPos findRandomMapFeature(TagKey<Structure> tagKey, BlockPos pos, int radius, boolean unexplored, ServerLevel level) {
        if (!level.m_7654_().m_129910_().m_5961_().m_224677_()) {
            return null;
        }
        Optional optional = level.m_5962_().m_175515_(Registry.f_235725_).m_203431_(tagKey);
        if (optional.isEmpty()) {
            return null;
        }
        HolderSet.Named set = (HolderSet.Named)optional.get();
        List list = set.m_203614_().toList();
        Holder chosen = (Holder)list.get(level.f_46441_.m_188503_(list.size()));
        Pair pair = level.m_7726_().m_8481_().m_223037_(level, (HolderSet)HolderSet.m_205809_((Holder[])new Holder[]{chosen}), pos, radius, unexplored);
        return pair != null ? (BlockPos)pair.getFirst() : null;
    }

    public record LocatedStruct(BlockPos pos, Holder<Structure> structure, @Nullable StructureStart start) {
        public LocatedStruct(Pair<BlockPos, Holder<Structure>> pair) {
            this((BlockPos)pair.getFirst(), (Holder<Structure>)((Holder)pair.getSecond()), null);
        }
    }
}

