/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.client.renderers;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.mehvahdjukaar.moonlight.api.client.util.RotHlpr;
import net.mehvahdjukaar.supplementaries.client.renderers.color.ColorHelper;
import net.mehvahdjukaar.supplementaries.configs.ClientConfigs;
import net.mehvahdjukaar.supplementaries.reg.ModTextures;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.core.BlockPos;
import net.minecraft.util.FastColor;
import net.minecraft.util.Mth;
import net.minecraft.world.level.Level;

public class VertexUtils {
    public static void addCube(VertexConsumer builder, PoseStack matrixStackIn, float w, float h, TextureAtlasSprite sprite, int combinedLightIn, int color, float a, int combinedOverlayIn, boolean up, boolean down, boolean fakeshading, boolean flippedY) {
        VertexUtils.addCube(builder, matrixStackIn, 0.0f, 0.0f, w, h, sprite, combinedLightIn, color, a, up, down, fakeshading, flippedY, false);
    }

    public static void addCube(VertexConsumer builder, PoseStack matrixStackIn, float uOff, float vOff, float w, float h, TextureAtlasSprite sprite, int combinedLightIn, int color, float a, int combinedOverlayIn, boolean up, boolean down, boolean fakeshading, boolean flippedY) {
        VertexUtils.addCube(builder, matrixStackIn, uOff, vOff, w, h, sprite, combinedLightIn, color, a, up, down, fakeshading, flippedY, false);
    }

    public static void addCube(VertexConsumer builder, PoseStack matrixStackIn, float uOff, float vOff, float w, float h, TextureAtlasSprite sprite, int combinedLightIn, int color, float a, boolean up, boolean down, boolean fakeshading, boolean flippedY, boolean wrap) {
        float b5;
        float g5;
        float r5;
        int lu = combinedLightIn & 0xFFFF;
        int lv = combinedLightIn >> 16 & 0xFFFF;
        float atlasScaleU = sprite.m_118410_() - sprite.m_118409_();
        float atlasScaleV = sprite.m_118412_() - sprite.m_118411_();
        float minU = sprite.m_118409_() + atlasScaleU * uOff;
        float minV = sprite.m_118411_() + atlasScaleV * vOff;
        float maxU = minU + atlasScaleU * w;
        float maxV = minV + atlasScaleV * h;
        float maxV2 = minV + atlasScaleV * w;
        float r = (float)(color >> 16 & 0xFF) / 255.0f;
        float g = (float)(color >> 8 & 0xFF) / 255.0f;
        float b = (float)(color & 0xFF) / 255.0f;
        float r6 = r5 = r;
        float r8 = r5;
        float g6 = g5 = g;
        float g8 = g5;
        float b6 = b5 = b;
        float b8 = b5;
        if (fakeshading) {
            float s1 = 0.8f;
            float s2 = 0.6f;
            float s3 = 0.5f;
            r8 *= s1;
            g8 *= s1;
            b8 *= s1;
            r6 *= s2;
            g6 *= s2;
            b6 *= s2;
            r5 *= s3;
            g5 *= s3;
            b5 *= s3;
        }
        float hw = w / 2.0f;
        float hh = h / 2.0f;
        if (up) {
            VertexUtils.addQuadTop(builder, matrixStackIn, -hw, h, hw, hw, h, -hw, minU, minV, maxU, maxV2, r, g, b, a, lu, lv, 0.0f, 1.0f, 0.0f);
        }
        if (down) {
            VertexUtils.addQuadTop(builder, matrixStackIn, -hw, 0.0f, -hw, hw, 0.0f, hw, minU, minV, maxU, maxV2, r5, g5, b5, a, lu, lv, 0.0f, -1.0f, 0.0f);
        }
        if (flippedY) {
            float temp = minV;
            minV = maxV;
            maxV = temp;
        }
        float inc = 0.0f;
        if (wrap) {
            inc = atlasScaleU * w;
        }
        VertexUtils.addQuadSide(builder, matrixStackIn, hw, 0.0f, -hw, -hw, h, -hw, minU, minV, maxU, maxV, r8, g8, b8, a, lu, lv, 0.0f, 0.0f, 1.0f);
        VertexUtils.addQuadSide(builder, matrixStackIn, -hw, 0.0f, -hw, -hw, h, hw, minU + inc, minV, maxU + inc, maxV, r6, g6, b6, a, lu, lv, -1.0f, 0.0f, 0.0f);
        VertexUtils.addQuadSide(builder, matrixStackIn, -hw, 0.0f, hw, hw, h, hw, minU + 2.0f * inc, minV, maxU + 2.0f * inc, maxV, r8, g8, b8, a, lu, lv, 0.0f, 0.0f, -1.0f);
        VertexUtils.addQuadSide(builder, matrixStackIn, hw, 0.0f, hw, hw, h, -hw, minU + 3.0f * inc, minV, maxU + 3.0f * inc, maxV, r6, g6, b6, a, lu, lv, 1.0f, 0.0f, 0.0f);
    }

    public static int setColorForAge(float age, float phase) {
        float a = (age + phase) % 1.0f;
        float[] col = ColorHelper.getBubbleColor(a);
        return FastColor.ARGB32.m_13660_((int)255, (int)((int)(col[0] * 255.0f)), (int)((int)(col[1] * 255.0f)), (int)((int)(col[2] * 255.0f)));
    }

    public static void renderBubble(VertexConsumer builder, PoseStack matrixStackIn, float w, TextureAtlasSprite sprite, int combinedLightIn, boolean flippedY, BlockPos pos, Level level, float partialTicks) {
        int lu = combinedLightIn & 0xFFFF;
        int lv = combinedLightIn >> 16 & 0xFFFF;
        float atlasScaleU = sprite.m_118410_() - sprite.m_118409_();
        float atlasScaleV = sprite.m_118412_() - sprite.m_118411_();
        float minU = sprite.m_118409_();
        float minV = sprite.m_118411_();
        float maxU = minU + atlasScaleU * w;
        float maxV = minV + atlasScaleV * w;
        float maxV2 = minV + atlasScaleV * w;
        long t = level == null ? System.currentTimeMillis() / 50L : level.m_46467_();
        float time = ((float)Math.floorMod((long)pos.m_123341_() * 7L + (long)pos.m_123342_() * 9L + (long)pos.m_123343_() * 13L + t, 100L) + partialTicks) / 100.0f;
        int cUnw = VertexUtils.setColorForAge(time, 0.0f);
        int cUne = VertexUtils.setColorForAge(time, 0.15f);
        int cUse = VertexUtils.setColorForAge(time, 0.55f);
        int cUsw = VertexUtils.setColorForAge(time, 0.35f);
        int cDnw = VertexUtils.setColorForAge(time, 0.45f);
        int cDne = VertexUtils.setColorForAge(time, 0.85f);
        int cDse = VertexUtils.setColorForAge(time, 1.0f);
        int cDsw = VertexUtils.setColorForAge(time, 0.65f);
        float amp = (float)(ClientConfigs.Blocks.BUBBLE_BLOCK_WOBBLE.get() / 10.0);
        w -= 2.0f * amp;
        float unw = amp * Mth.m_14089_((float)((float)Math.PI * 2 * (time + 0.0f)));
        float une = amp * Mth.m_14089_((float)((float)Math.PI * 2 * (time + 0.25f)));
        float use = amp * Mth.m_14089_((float)((float)Math.PI * 2 * (time + 0.5f)));
        float usw = amp * Mth.m_14089_((float)((float)Math.PI * 2 * (time + 0.75f)));
        float dnw = use;
        float dne = usw;
        float dse = unw;
        float dsw = une;
        float l = w / 2.0f;
        VertexUtils.addVert(builder, matrixStackIn, -l - usw, l + usw, l + usw, minU, maxV2, cUsw, lu, lv, 0.0f, 1.0f, 0.0f);
        VertexUtils.addVert(builder, matrixStackIn, l + use, l + use, l + use, maxU, maxV2, cUse, lu, lv, 0.0f, 1.0f, 0.0f);
        VertexUtils.addVert(builder, matrixStackIn, l + une, l + une, -l - une, maxU, minV, cUne, lu, lv, 0.0f, 1.0f, 0.0f);
        VertexUtils.addVert(builder, matrixStackIn, -l - unw, l + unw, -l - unw, minU, minV, cUnw, lu, lv, 0.0f, 1.0f, 0.0f);
        VertexUtils.addVert(builder, matrixStackIn, -l - dnw, -l - dnw, -l - dnw, minU, maxV2, cDnw, lu, lv, 0.0f, -1.0f, 0.0f);
        VertexUtils.addVert(builder, matrixStackIn, l + dne, -l - dne, -l - dne, maxU, maxV2, cDne, lu, lv, 0.0f, -1.0f, 0.0f);
        VertexUtils.addVert(builder, matrixStackIn, l + dse, -l - dse, l + dse, maxU, minV, cDse, lu, lv, 0.0f, -1.0f, 0.0f);
        VertexUtils.addVert(builder, matrixStackIn, -l - dsw, -l - dsw, l + dsw, minU, minV, cDsw, lu, lv, 0.0f, -1.0f, 0.0f);
        if (flippedY) {
            float temp = minV;
            minV = maxV;
            maxV = temp;
        }
        VertexUtils.addVert(builder, matrixStackIn, l + dne, -l - dne, -l - dne, minU, maxV, cDne, lu, lv, 0.0f, 0.0f, 1.0f);
        VertexUtils.addVert(builder, matrixStackIn, -l - dnw, -l - dnw, -l - dnw, maxU, maxV, cDnw, lu, lv, 0.0f, 0.0f, 1.0f);
        VertexUtils.addVert(builder, matrixStackIn, -l - unw, l + unw, -l - unw, maxU, minV, cUnw, lu, lv, 0.0f, 0.0f, 1.0f);
        VertexUtils.addVert(builder, matrixStackIn, l + une, l + une, -l - une, minU, minV, cUne, lu, lv, 0.0f, 0.0f, 1.0f);
        VertexUtils.addVert(builder, matrixStackIn, -l - dnw, -l - dnw, -l - dnw, minU, maxV, cDnw, lu, lv, -1.0f, 0.0f, 0.0f);
        VertexUtils.addVert(builder, matrixStackIn, -l - dsw, -l - dsw, l + dsw, maxU, maxV, cDsw, lu, lv, -1.0f, 0.0f, 0.0f);
        VertexUtils.addVert(builder, matrixStackIn, -l - usw, l + usw, l + usw, maxU, minV, cUsw, lu, lv, -1.0f, 0.0f, 0.0f);
        VertexUtils.addVert(builder, matrixStackIn, -l - unw, l + unw, -l - unw, minU, minV, cUnw, lu, lv, -1.0f, 0.0f, 0.0f);
        VertexUtils.addVert(builder, matrixStackIn, -l - dsw, -l - dsw, l + dsw, minU, maxV, cDsw, lu, lv, 0.0f, 0.0f, -1.0f);
        VertexUtils.addVert(builder, matrixStackIn, l + dse, -l - dse, l + dse, maxU, maxV, cDse, lu, lv, 0.0f, 0.0f, -1.0f);
        VertexUtils.addVert(builder, matrixStackIn, l + use, l + use, l + use, maxU, minV, cUse, lu, lv, 0.0f, 0.0f, -1.0f);
        VertexUtils.addVert(builder, matrixStackIn, -l - usw, l + usw, l + usw, minU, minV, cUsw, lu, lv, 0.0f, 0.0f, -1.0f);
        VertexUtils.addVert(builder, matrixStackIn, l + dse, -l - dse, l + dse, minU, maxV, cDse, lu, lv, 1.0f, 0.0f, 0.0f);
        VertexUtils.addVert(builder, matrixStackIn, l + dne, -l - dne, -l - dne, maxU, maxV, cDne, lu, lv, 1.0f, 0.0f, 0.0f);
        VertexUtils.addVert(builder, matrixStackIn, l + une, l + une, -l - une, maxU, minV, cUne, lu, lv, 1.0f, 0.0f, 0.0f);
        VertexUtils.addVert(builder, matrixStackIn, l + use, l + use, l + use, minU, minV, cUse, lu, lv, 1.0f, 0.0f, 0.0f);
    }

    public static void addVert(VertexConsumer builder, PoseStack matrixStackIn, float x, float y, float z, float u, float v, int color, int lu, int lv, float nx, float ny, float nz) {
        builder.m_85982_(matrixStackIn.m_85850_().m_85861_(), x, y, z).m_193479_(color).m_7421_(u, v).m_86008_(OverlayTexture.f_118083_).m_7120_(lu, lv).m_85977_(matrixStackIn.m_85850_().m_85864_(), nx, ny, nz).m_5752_();
    }

    public static void addQuadSide(VertexConsumer builder, PoseStack matrixStackIn, float x0, float y0, float z0, float x1, float y1, float z1, float u0, float v0, float u1, float v1, float r, float g, float b, float a, int lu, int lv, float nx, float ny, float nz) {
        VertexUtils.addVert(builder, matrixStackIn, x0, y0, z0, u0, v1, r, g, b, a, lu, lv, nx, ny, nz);
        VertexUtils.addVert(builder, matrixStackIn, x1, y0, z1, u1, v1, r, g, b, a, lu, lv, nx, ny, nz);
        VertexUtils.addVert(builder, matrixStackIn, x1, y1, z1, u1, v0, r, g, b, a, lu, lv, nx, ny, nz);
        VertexUtils.addVert(builder, matrixStackIn, x0, y1, z0, u0, v0, r, g, b, a, lu, lv, nx, ny, nz);
    }

    public static void addQuadSide(VertexConsumer builder, PoseStack matrixStackIn, float x0, float y0, float z0, float x1, float y1, float z1, float u0, float v0, float u1, float v1, float r, float g, float b, float a, int lu, int lv, float nx, float ny, float nz, TextureAtlasSprite sprite) {
        u0 = VertexUtils.getRelativeU(sprite, u0);
        u1 = VertexUtils.getRelativeU(sprite, u1);
        v0 = VertexUtils.getRelativeV(sprite, v0);
        v1 = VertexUtils.getRelativeV(sprite, v1);
        VertexUtils.addVert(builder, matrixStackIn, x0, y0, z0, u0, v1, r, g, b, a, lu, lv, nx, ny, nz);
        VertexUtils.addVert(builder, matrixStackIn, x1, y0, z1, u1, v1, r, g, b, a, lu, lv, nx, ny, nz);
        VertexUtils.addVert(builder, matrixStackIn, x1, y1, z1, u1, v0, r, g, b, a, lu, lv, nx, ny, nz);
        VertexUtils.addVert(builder, matrixStackIn, x0, y1, z0, u0, v0, r, g, b, a, lu, lv, nx, ny, nz);
    }

    public static void addQuadTop(VertexConsumer builder, PoseStack matrixStackIn, float x0, float y0, float z0, float x1, float y1, float z1, float u0, float v0, float u1, float v1, float r, float g, float b, float a, int lu, int lv, float nx, float ny, float nz) {
        VertexUtils.addVert(builder, matrixStackIn, x0, y0, z0, u0, v1, r, g, b, a, lu, lv, nx, ny, nz);
        VertexUtils.addVert(builder, matrixStackIn, x1, y0, z0, u1, v1, r, g, b, a, lu, lv, nx, ny, nz);
        VertexUtils.addVert(builder, matrixStackIn, x1, y1, z1, u1, v0, r, g, b, a, lu, lv, nx, ny, nz);
        VertexUtils.addVert(builder, matrixStackIn, x0, y1, z1, u0, v0, r, g, b, a, lu, lv, nx, ny, nz);
    }

    public static void addVert(VertexConsumer builder, PoseStack matrixStackIn, float x, float y, float z, float u, float v, float r, float g, float b, float a, int lu, int lv, float nx, float ny, float nz) {
        builder.m_85982_(matrixStackIn.m_85850_().m_85861_(), x, y, z).m_85950_(r, g, b, a).m_7421_(u, v).m_86008_(OverlayTexture.f_118083_).m_7120_(lu, lv).m_85977_(matrixStackIn.m_85850_().m_85864_(), nx, ny, nz).m_5752_();
    }

    public static void addVert(VertexConsumer builder, PoseStack matrixStackIn, float x, float y, float z, float u, float v, float r, float g, float b, float a, int lu, int lv, float nx, float ny, float nz, TextureAtlasSprite sprite) {
        builder.m_85982_(matrixStackIn.m_85850_().m_85861_(), x, y, z).m_85950_(r, g, b, a).m_7421_(VertexUtils.getRelativeU(sprite, u), VertexUtils.getRelativeV(sprite, v)).m_86008_(OverlayTexture.f_118083_).m_7120_(lu, lv).m_85977_(matrixStackIn.m_85850_().m_85864_(), nx, ny, nz).m_5752_();
    }

    public static float getRelativeU(TextureAtlasSprite sprite, float u) {
        float f = sprite.m_118410_() - sprite.m_118409_();
        return sprite.m_118409_() + f * u;
    }

    public static float getRelativeV(TextureAtlasSprite sprite, float v) {
        float f = sprite.m_118412_() - sprite.m_118411_();
        return sprite.m_118411_() + f * v;
    }

    public static void renderFish(VertexConsumer builder, PoseStack matrixStackIn, float wo, float ho, int fishType, int combinedLightIn) {
        int textW = 64;
        int textH = 32;
        int fishW = 5;
        int fishH = 4;
        int fishv = --fishType % (textH / fishH);
        int fishu = fishType / (textH / fishH);
        TextureAtlasSprite sprite = (TextureAtlasSprite)Minecraft.m_91087_().m_91258_(TextureAtlas.f_118259_).apply(ModTextures.FISHIES_TEXTURE);
        float w = (float)fishW / (float)textW;
        float h = (float)fishH / (float)textH;
        float hw = 4.0f * w / 2.0f;
        float hh = 2.0f * h / 2.0f;
        int lu = combinedLightIn & 0xFFFF;
        int lv = combinedLightIn >> 16 & 0xFFFF;
        float atlasscaleU = sprite.m_118410_() - sprite.m_118409_();
        float atlasscaleV = sprite.m_118412_() - sprite.m_118411_();
        float minu = sprite.m_118409_() + atlasscaleU * (float)fishu * w;
        float minv = sprite.m_118411_() + atlasscaleV * (float)fishv * h;
        float maxu = atlasscaleU * w + minu;
        float maxv = atlasscaleV * h + minv;
        for (int k = 0; k < 2; ++k) {
            for (int j = 0; j < 2; ++j) {
                VertexUtils.addVert(builder, matrixStackIn, hw - Math.abs(wo / 2.0f), -hh + ho, wo, minu, maxv, 1.0f, 1.0f, 1.0f, 1.0f, lu, lv, 0.0f, 1.0f, 0.0f);
                VertexUtils.addVert(builder, matrixStackIn, -hw + Math.abs(wo / 2.0f), -hh + ho, -wo, maxu, maxv, 1.0f, 1.0f, 1.0f, 1.0f, lu, lv, 0.0f, 1.0f, 0.0f);
                VertexUtils.addVert(builder, matrixStackIn, -hw + Math.abs(wo / 2.0f), hh + ho, -wo, maxu, minv, 1.0f, 1.0f, 1.0f, 1.0f, lu, lv, 0.0f, 1.0f, 0.0f);
                VertexUtils.addVert(builder, matrixStackIn, hw - Math.abs(wo / 2.0f), hh + ho, wo, minu, minv, 1.0f, 1.0f, 1.0f, 1.0f, lu, lv, 0.0f, 1.0f, 0.0f);
                matrixStackIn.m_85845_(RotHlpr.Y180);
                float temp = minu;
                minu = maxu;
                maxu = temp;
            }
            lu = 240;
            minu += atlasscaleU / 2.0f;
            maxu += atlasscaleU / 2.0f;
        }
    }
}

