/*
 * Decompiled with CFR 0.152.
 */
package com.ldtteam.structurize.storage;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.ldtteam.structurize.Network;
import com.ldtteam.structurize.api.util.Log;
import com.ldtteam.structurize.api.util.Utils;
import com.ldtteam.structurize.blocks.interfaces.ISpecialCreativeHandlerAnchorBlock;
import com.ldtteam.structurize.blueprints.v1.Blueprint;
import com.ldtteam.structurize.management.Manager;
import com.ldtteam.structurize.network.messages.BlueprintSyncMessage;
import com.ldtteam.structurize.network.messages.BuildToolPlacementMessage;
import com.ldtteam.structurize.network.messages.ClientBlueprintRequestMessage;
import com.ldtteam.structurize.placement.StructurePlacer;
import com.ldtteam.structurize.placement.structure.AbstractStructureHandler;
import com.ldtteam.structurize.placement.structure.CreativeStructureHandler;
import com.ldtteam.structurize.storage.ISurvivalBlueprintHandler;
import com.ldtteam.structurize.storage.ServerFutureProcessor;
import com.ldtteam.structurize.storage.StructurePacks;
import com.ldtteam.structurize.storage.SurvivalBlueprintHandlers;
import com.ldtteam.structurize.util.IOPool;
import com.ldtteam.structurize.util.PlacementSettings;
import com.ldtteam.structurize.util.RotationMirror;
import com.ldtteam.structurize.util.TickedWorldOperation;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.forgespi.language.IModInfo;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BlueprintPlacementHandling {
    public static void handlePlacement(BuildToolPlacementMessage message) {
        if (!StructurePacks.hasPack(message.structurePackId)) {
            Network.getNetwork().sendToPlayer(new ClientBlueprintRequestMessage(message), message.player);
        } else {
            ServerFutureProcessor.queueBlueprint(new ServerFutureProcessor.BlueprintProcessingData(StructurePacks.getBlueprintFuture(message.structurePackId, message.blueprintPath), message.world, blueprint -> BlueprintPlacementHandling.process(blueprint, message)));
        }
    }

    private static void process(@Nullable Blueprint blueprint, @NotNull BuildToolPlacementMessage message) {
        AbstractStructureHandler structure;
        if (blueprint == null) {
            Log.getLogger().warn("Couldn't retrieve blueprint: " + message.blueprintPath);
            return;
        }
        if (message.type == BuildToolPlacementMessage.HandlerType.Survival) {
            ISurvivalBlueprintHandler handler = SurvivalBlueprintHandlers.getHandler(message.handlerId);
            if (handler != null) {
                handler.handle(blueprint, message.structurePackId, message.blueprintPath, message.clientPack, message.world, (Player)message.player, message.pos, new PlacementSettings(message.mirror, message.rotation));
            }
            return;
        }
        Utils.playSuccessSound((Player)message.player);
        BlockState anchor = blueprint.getBlockState(blueprint.getPrimaryBlockOffset());
        blueprint.setRotationMirror(RotationMirror.of(message.rotation, message.mirror), message.world);
        if (anchor.m_60734_() instanceof ISpecialCreativeHandlerAnchorBlock) {
            if (!((ISpecialCreativeHandlerAnchorBlock)anchor.m_60734_()).setup(message.player, message.world, message.pos, blueprint, new PlacementSettings(message.mirror, message.rotation), message.type == BuildToolPlacementMessage.HandlerType.Pretty, message.structurePackId, message.blueprintPath)) {
                return;
            }
            structure = ((ISpecialCreativeHandlerAnchorBlock)anchor.m_60734_()).getStructureHandler(message.world, message.pos, blueprint, new PlacementSettings(message.mirror, message.rotation), message.type == BuildToolPlacementMessage.HandlerType.Pretty);
        } else {
            structure = new CreativeStructureHandler(message.world, message.pos, blueprint, new PlacementSettings(message.mirror, message.rotation), message.type == BuildToolPlacementMessage.HandlerType.Pretty);
        }
        StructurePlacer instantPlacer = new StructurePlacer(structure);
        Manager.addToQueue(new TickedWorldOperation(instantPlacer, (Player)message.player));
    }

    public static void handlePlacement(BlueprintSyncMessage blueprintSyncMessage, ServerPlayer player) {
        ServerFutureProcessor.queueBlueprint(new ServerFutureProcessor.BlueprintProcessingData(IOPool.submit(() -> {
            Path blueprintParentPath = new File(".").toPath().resolve("blueprints").resolve("clients").resolve(player.m_20148_().toString()).resolve(blueprintSyncMessage.structurePackId);
            Path blueprintPath = blueprintParentPath.resolve(blueprintSyncMessage.blueprintPath);
            String packId = player.m_20148_() + blueprintSyncMessage.structurePackId;
            blueprintSyncMessage.structurePackId = packId;
            try {
                Files.createDirectories(blueprintPath.getParent(), new FileAttribute[0]);
                JsonObject jsonObject = new JsonObject();
                jsonObject.addProperty("version", (Number)1);
                jsonObject.addProperty("pack-format", (Number)1);
                jsonObject.addProperty("desc", "Local Dummy");
                JsonArray authorArray = new JsonArray();
                jsonObject.add("authors", (JsonElement)authorArray);
                JsonArray modsArray = new JsonArray();
                modsArray.add("structurize");
                jsonObject.add("mods", (JsonElement)modsArray);
                jsonObject.addProperty("name", packId);
                jsonObject.addProperty("icon", "");
                Files.write(blueprintParentPath.resolve("pack.json"), jsonObject.toString().getBytes(), new OpenOption[0]);
                ArrayList<String> modList = new ArrayList<String>();
                for (IModInfo mod : ModList.get().getMods()) {
                    modList.add(mod.getModId());
                }
                StructurePacks.discoverPackAtPath(blueprintParentPath, false, modList, true, "Local");
            }
            catch (IOException e) {
                Log.getLogger().error("Failed to create folder structure for client blueprint: " + blueprintSyncMessage.blueprintPath, (Throwable)e);
                return null;
            }
            try {
                Files.write(blueprintPath, blueprintSyncMessage.blueprintData, new OpenOption[0]);
            }
            catch (IOException e) {
                Log.getLogger().error("Failed to save blueprint file for client blueprint: " + blueprintSyncMessage.blueprintPath, (Throwable)e);
            }
            return StructurePacks.getBlueprint(packId, blueprintPath);
        }), player.f_19853_, blueprint -> BlueprintPlacementHandling.process(blueprint, new BuildToolPlacementMessage(blueprintSyncMessage, player, player.f_19853_))));
    }
}

